// mcp.h
//
// Copyright (C) 2000 Neil Stevens <multivac@fcmail.com>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
// 
// Except as contained in this notice, the name(s) of the author(s) shall not be
// used in advertising or otherwise to promote the sale, use or other dealings
// in this Software without prior written authorization from the author(s).

#ifndef MCP_H
#define MCP_H

#include <qarray.h>
#include <qdom.h>
#include "noatunplaylist.h"

namespace KIO
{
class Job;
}

class MCPItem;

class MCP : public PlayList
{
Q_OBJECT

public:
	MCP(QObject *parent, const char *name = 0);
	virtual ~MCP();

	virtual void reset(void);
	virtual void clear(void);

	void play(PlayListItem *);
	virtual PlayListItem *next(void);
	virtual PlayListItem *current(void);
	virtual PlayListItem *previous(void);

	virtual PlayListItem *getFirst(void) const;
	virtual PlayListItem *getAfter(const PlayListItem *) const;
	PlayListItem *getBefore(const PlayListItem *) const;

	void moveAfter(PlayListItem *item, PlayListItem *afterThisOne);

	virtual void addFile(const KURL &, bool = false);
	PlayListItem *addFile(const KURL &, PlayListItem *);
	PlayListItem *importWindowsPlayList(const KURL &, PlayListItem * = 0);
	PlayListItem *importPlayList(const KURL &, PlayListItem * = 0);

	virtual bool listVisible(void) const;

	void setShuffle(bool);

	/**
	 * Internal
	 *
	 * To be used by MCPItem only
	 */
	void itemModified(PlayListItem *);

public slots:
	virtual void showList(void);
	virtual void hideList(void);
	virtual void toggleList(void);
	virtual void remove(PlayListItem *);

	void load(const KURL &, bool errorFree = false);
	void save(const KURL &);

signals:
	void cleared(void);
	void loaded(void);
	void saved(void);
	void modified(PlayListItem *);
	void removed(PlayListItem *);
	void moved(PlayListItem *item, PlayListItem *afterThis);

	/**
	 * This is emitted when the current playlist item is set or changed
	 */
	void current(PlayListItem *);

private:
	static const MCPItem *AtBottom;

	void clearInternal(void);
	MCPItem *addFileG(const KURL &_url, bool _play = false, MCPItem *_afterThis = const_cast<MCPItem *>(AtBottom));

	QDomDocument doc;
	QDomElement cur;

	bool shuffle;
	QList<MCPItem> shuffleUnused;
};

#endif
