#ifndef MAIN_H
#define MAIN_H
#include <qiomanager.h>
#include <dispatcher.h>
#include <qmessagebox.h>
#include <kapp.h>
#include <qframe.h>
#include <kmainwindow.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kstdaction.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <artsflow.h>
#include <soundserver.h>
#include <qobject.h>
#include "flowsystem.h"
#include "artsmodules.h"
#include "freeverbui.h"

class LevelMeter;

class PeakBar;

class PeakLevelMeter;

class VScale;

class FFTScopeView : public QWidget {
	Q_OBJECT
protected:
	Arts::StereoFFTScope scopefx;
	Arts::SimpleSoundServer server;
	long effectID;

	vector<float> *scopeData;
	vector<float> scopeDraw;
	vector<LevelMeter *> scopeScales;

	void closeEvent(QCloseEvent *e);
public:
	void updateScopeData();
	FFTScopeView(Arts::SimpleSoundServer server);
	~FFTScopeView();

public slots:
	void updateScope();
signals:
	void closed();
};

class FreeVerbView : public QWidget {
	Q_OBJECT
protected:
	Arts::Synth_FREEVERB freeverb;
	Arts::SimpleSoundServer server;
	FreeVerbUI *freeverbui;
	long effectID;

	void closeEvent(QCloseEvent *e);
public:
	FreeVerbView(Arts::SimpleSoundServer server);
	~FreeVerbView();
signals:
	void closed();
};

class ArtsStatusView : public QWidget {
	Q_OBJECT
public:
	ArtsStatusView(Arts::SoundServer server);
	
public slots:
	void updateStatus();
	void suspendButtonClicked();
	
signals:
	void closed();

protected:
	QTimer *artsPollStatusTimer;
	Arts::SoundServer server;
	QLabel *suspendLabel;
	QButton *suspendButton;
	
	void closeEvent(QCloseEvent *e);
};

class VControl : public QFrame {
	Q_OBJECT
protected:
	class StereoLevelMeter *stereoMeter;
	class FFTScopeView *scopeView;
	class FreeVerbView *freeVerbView;
	class Gui_AUDIO_MANAGER *audioManager;
	class ArtsStatusView *artsStatusView;
	class MidiManagerView *midiManagerView;
	Arts::StereoVolumeControl svc;
	Arts::SoundServer server;
	long effectID;
	
	QBoxLayout *boxLayout;

public:
	VControl(QWidget *parent);
	~VControl();

public slots:
	void updateScales();
	void setVolume(int vol);
	void useOldVolumeBar(int old);
	void showScopeView();
	void removeScopeView();
	void showAudioManager();
	void removeAudioManager();
	void showMidiManager();
	void removeMidiManager();
	void showFreeVerbView();
	void removeFreeVerbView();
	void showArtsStatusView();
	void removeArtsStatusView();
};

class MainWindow : public KMainWindow {
	Q_OBJECT
protected:
	VControl *vc;
	KToggleAction *showOldVolumeDisplay;

	void closeEvent(QCloseEvent *);
	
public slots:
	void toggleVolumeBar();

public:
	MainWindow();
};

#endif /* MAIN_H */
