// $Id: canvassize.cpp,v 1.14 2000/11/27 14:06:02 mlaurent Exp $

#include <kdebug.h>
#include <stdlib.h>
#include <qlayout.h>

#include <klocale.h>
#include <kapp.h>
#include <kglobal.h>
#include <knumvalidator.h>

#include "canvassize.h"

/**
 * A modal dialog to ask for the size of the canvas.
 */
canvasSizeDialog::canvasSizeDialog(QWidget *parent, const char *name,int _width,int _height)
 : QDialog (parent, name, TRUE)
{
  setCaption(i18n("Canvas Size"));
  width=_width;
  height=_height;
  // Create top level layout
  QVBoxLayout *topLevelLayout= new QVBoxLayout(this, 4);

  // Create the grid for the entry widgets
  QGridLayout *mainLayout= new QGridLayout(3, 2);
  topLevelLayout->addLayout(mainLayout, 0);

  widthLabel= new QLabel(i18n("Width:"), this);
  heightLabel= new QLabel(i18n("Height:"), this);
  widthEdit= new QLineEdit(this);
  widthEdit->setValidator( new KIntValidator( widthEdit ) );
  widthEdit->setFocus();
  QString tmp;
  widthEdit->setText(tmp.setNum(_width));
  heightEdit= new QLineEdit(this);
  heightEdit->setValidator( new KIntValidator( heightEdit ) );
  heightEdit->setText(tmp.setNum(_height));
  pictureRatio=new QCheckBox(i18n("Keep picture ratio"),this);
  pictureRatio->setChecked(false);

  connect(widthEdit, SIGNAL(returnPressed()), SLOT(accept()) );
  connect(heightEdit, SIGNAL(returnPressed()), SLOT(accept()) );
  connect(widthEdit, SIGNAL(textChanged(const QString &)),this, SLOT(slotWidthTextChanged(const QString &) ));
  connect(pictureRatio,SIGNAL(clicked ()),this,SLOT(changeState()));

  mainLayout->addWidget(widthLabel, 0, 0, AlignCenter);
  widthEdit->setFixedHeight(widthLabel->sizeHint().height()+8);
  mainLayout->addWidget(widthEdit, 0, 1);
  mainLayout->addWidget(heightLabel, 1, 0, AlignCenter);
  heightEdit->setFixedHeight(heightLabel->sizeHint().height()+8);
  mainLayout->addWidget(heightEdit, 1, 1);
  mainLayout->setColStretch(0, 1);
  mainLayout->setColStretch(1, 3);
  mainLayout->addMultiCellWidget(pictureRatio,2,2,0,1);

  // Now a box layout for the buttons
  QHBoxLayout *buttonLayout= new QHBoxLayout();
  topLevelLayout->addLayout(buttonLayout);

  okButton= new QPushButton(i18n("OK"), this);
  cancelButton= new QPushButton(i18n("Cancel"), this);
  okButton->setFixedHeight(okButton->sizeHint().height());
  okButton->setMinimumWidth(okButton->sizeHint().width());
  cancelButton->setFixedHeight(cancelButton->sizeHint().height());
  cancelButton->setMinimumWidth(okButton->sizeHint().width());

  buttonLayout->addStretch();
  buttonLayout->addWidget(okButton);
  buttonLayout->addWidget(cancelButton);

  connect(okButton, SIGNAL(clicked()), SLOT(accept()) );
  connect(cancelButton, SIGNAL(clicked()), SLOT(reject()) );

  resize(200, 100);

  // Now start things off
  topLevelLayout->activate();
}

int canvasSizeDialog::getHeight()
{
  return (int)KGlobal::locale()->readNumber(heightEdit->text());
}

int canvasSizeDialog::getWidth()
{
  return (int)KGlobal::locale()->readNumber(widthEdit->text());
}

void canvasSizeDialog::slotWidthTextChanged(const QString &/*_str*/)
{
if( pictureRatio->isChecked())
        {
        double ratioinv=(double)height/(double)width;
        int val=getWidth();
        QString tmp=tmp.setNum((int)(ratioinv*val));
        heightEdit->setText(tmp);
        }
}

void canvasSizeDialog::changeState()
{
if(pictureRatio->isChecked())
        heightEdit->setEnabled(false);
else
        heightEdit->setEnabled(true);
}

#include "canvassize.moc"
