// $Id: brush.cpp,v 1.2 2000/12/23 02:41:26 jcaliff Exp $

#include <stdio.h>
#include <qcursor.h>
#include <qpainter.h>
#include <qstring.h>
#include <qwmatrix.h>
#include <qclipboard.h>

#include <klocale.h>
#include <kapp.h>
#include <kdebug.h>
#include <kmessagebox.h>
#include <kiconloader.h>

#include "brush.h"

#define TIMER_INTERVALL 500


/* #################  Paste Tool ############################*/

PasteTool::PasteTool(const QString & toolname) : Tool(toolname)
{
  drawing= FALSE;
  showedSF= false;
  tooltip= i18n("Paste");
  props= 0;
}

/*
PasteTool::~PasteTool()
{ }
*/

void PasteTool::activating()
{
  kdDebug(4400) << "PasteTool::activating() hook called\n" << endl;
  
  canvas->setCursor(crossCursor);
  QPixmap cPixmap = kapp->clipboard()->pixmap();        

  noContent = cPixmap.isNull() ? true : false;
  if(noContent) KMessageBox::sorry(NULL, "The clipboard is empty!", "", FALSE);
}

void PasteTool::deactivating()
{
  kdDebug(4400) << "PasteTool::deactivating() hook called\n" << endl;
}

void
PasteTool::timerEvent(QTimerEvent *)
{
  // drawFrame();
}


void PasteTool::mousePressEvent(QMouseEvent *e)
{
  kdDebug(4400) << "PasteTool::mousePressEvent() handler called\n" << endl;
  
    
  if (isActive() && (e->button() == LeftButton) && !noContent) 
  {
    if (drawing) 
    {
      kdWarning(4400) << "PasteTool: Warning Left Button press received when pressed\n" << endl;
    }
    else 
    {
        QPainter paint;
        
        startx= (e->pos()).x();
        starty= (e->pos()).y();
      
        lastx= startx;
        lasty= starty;
        drawing= TRUE;
        
        paint.begin(canvas->zoomedPixmap());
        
        QPixmap cPixmap = kapp->clipboard()->pixmap();        
        if(!cPixmap.isNull())
        {
	        paint.setRasterOp(Qt::NotROP);
            paint.drawPixmap(lastx, lasty, cPixmap);
        }    
	    paint.end();
	    canvas->repaint(0);
    } 
  }
  if (!isActive()) 
  {
    kdWarning(4400) << "PasteTool: Warning event received when inactive (ignoring)\n" << endl;
  }
}



void PasteTool::mouseMoveEvent(QMouseEvent *e)
{
    int x,y;
    QPainter paint;

    if ( isActive() && !noContent)
    {
        x= (e->pos()).x();
        y= (e->pos()).y();

        if ((lastx != x) || (lasty != y)) 
        {
            if (drawing) 
            {
	            paint.begin(canvas->zoomedPixmap());

                QPixmap cPixmap = kapp->clipboard()->pixmap();        
                if(!cPixmap.isNull())
                {
	                paint.setRasterOp(Qt::NotROP);
                    paint.drawPixmap(lastx, lasty, cPixmap); 
	                paint.setRasterOp(Qt::NotROP);    
                    paint.drawPixmap(x, y, cPixmap);                     
                }    

	            lastx= x;
	            lasty= y;

	            paint.end();
	            canvas->repaint(0);
            }
        }
    }
    else 
    {
        kdWarning(4400) << "Warning event received when inactive (ignoring)\n" << endl;
    }
}


void PasteTool::mouseReleaseEvent(QMouseEvent *e)
{
  int x,y;
  QPainter paint;
  QWMatrix m;

kdDebug(4400) << "PasteTool::mouseReleaseEvent() handler called\n" << endl;

  if (isActive() && (e->button() == LeftButton) && !noContent) 
  {
    x= (e->pos()).x();
    y= (e->pos()).y();

    // Erase old line
    paint.begin(canvas->zoomedPixmap());
    paint.setPen(QPen(green, 0, DashLine));
    paint.setRasterOp(DEFAULT_RASTER_OP);
    //paint.drawRect(startx, starty, lastx-startx, lasty-starty);

    paint.end();

    m.scale((float) 100/(canvas->zoom()), (float) 100/(canvas->zoom()));
    paint.begin(canvas->pixmap());
    // paint.setPen(pen);
    paint.setWorldMatrix(m);
    paint.setRasterOp(CopyROP);

    QPixmap cPixmap = kapp->clipboard()->pixmap();
    if(!cPixmap.isNull())
        paint.drawPixmap(x, y, cPixmap);         
       
    paint.end();
    drawing= FALSE;
    canvas->updateZoomed();
    canvas->repaint(0);

    showedSF= false;
  }
  else 
  {
kdWarning(4400) << "Warning event received when inactive (ignoring)\n" << endl;
  }
}

QPixmap PasteTool::pixmap() const
{
    return UserIcon("brush");
}

void 
PasteTool::drawFrame()
{
}
#include "brush.moc"

#undef TIMER_INTERVALL /* for --enable-final */

