/*
 *   kghostview: KDE PostScript viewer
 *   This file: Copyright (C) 2000 Wilco Greven, greven@kde.org
 *   Uses ideas from earlier dialog code by Mark Donohoe and Tim Theisen
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "printdialog.h"
#include "printdialogbody.h"

#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qradiobutton.h>

#include <knuminput.h>
#include <klocale.h>
#include <kurlrequester.h>

#include "printsetupdialog.h"

PrintDialog::PrintDialog( QWidget* parent, const char* name, 
			  const QString& caption, int maxPages, bool marked )
 : KDialogBase( parent, name, true, caption, User1|Ok|Cancel, Ok, true, 
		i18n( "&Setup..." ) )
{
    _body = new PrintDialogBody( this );
    setMainWidget( _body );

    _body->rbMarked->setEnabled( marked );
    _body->laMax->setText( i18n( "of %1" ).arg( maxPages ) );

    connect( this, SIGNAL( user1Clicked() ), 
	     this, SLOT( slotUser1Clicked() ) );
}

bool PrintDialog::printToFile() const
{
    return _body->cbFile->isChecked();
}

QString PrintDialog::saveURL() const
{
    return _body->urFile->url();
}

PrintDialog::PageMode PrintDialog::pageMode() const
{
    return (PageMode) _body->bgPages->id( _body->bgPages->selected() );
}

int PrintDialog::from() const
{
    return _body->leFrom->text().toInt();
}

int PrintDialog::to() const
{
    return _body->leTo->text().toInt();
}

bool PrintDialog::reverseOrder() const
{
    return _body->cbReverse->isChecked();
}

unsigned int PrintDialog::copies() const
{
    return static_cast<unsigned int>( _body->sbCopies->value() );
}

void PrintDialog::slotUser1Clicked() 
{
    // Create and execute the print setup dialog.
    PrintSetupDialog* psd = new PrintSetupDialog( 
	    this, "printsetupdialog",  i18n( "Printer setup" ) );
    psd->exec();
    delete psd;
     
}

#include "printdialog.moc"
