#include <qdir.h>

#include <kcmdlineargs.h>
#include <kapp.h>
#include <kurl.h>
#include <klocale.h>
#include <kaboutdata.h>

#include "kgvshell.h"

#include "version.h"

static KCmdLineOptions options[] =
{
 { "+file(s)",          I18N_NOOP("Files to load"), 0 },
 { 0,0,0 }
};

static const char *description = I18N_NOOP("Viewer for Postscript (.ps, .eps) and Portable Document Format (.pdf) files.");




int
main( int argc, char **argv )
{
  KAboutData about ("kghostview", I18N_NOOP("KGhostView"), KGHOSTVIEW_VERSION,
		    description, KAboutData::License_GPL,
		    "(C) 1998, Mark Donohoe, (C) 1999-2000 David Sweet",
		    I18N_NOOP("KGhostView displays, prints, and saves "
		    "Postscript and PDF files.\n"
		    "Based on original work by Tim Theisen."));
  about.addAuthor ("Wilco Greven",
		   I18N_NOOP("Maintainer"),
		   "greven@kde.org");
  about.addAuthor ("David Sweet", 
		   I18N_NOOP("Maintainer 1999-2000"),
		   "dsweet@kde.org",
		   "http://www.chaos.umd.edu/~dsweet");
  about.addAuthor ("Mark Donohoe",
		   I18N_NOOP("Author"));
  about.addAuthor ("David Faure",
		   I18N_NOOP("Basis for shell"));
  about.addAuthor ("Daniel Duley",
		   I18N_NOOP("Port to KParts"));
  about.addAuthor ("Espen Sand",
		   I18N_NOOP("Dialog boxes"));

  KCmdLineArgs::init(argc, argv, &about);
  KCmdLineArgs::addCmdLineOptions( options ); // Add my own options.
  KApplication app;
  KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

  if (kapp->isRestored())
    RESTORE(KGVShell)
  else
    {
      KGVShell *shell = new KGVShell;
      if ( args->count() == 1 )
	{
	  // Allow full paths, but also simple filenames from current dir
	  if (QString(args->arg(0))!="-") //a request for stdin
	    {
	      KURL url( QDir::currentDirPath()+"/", args->arg(0) );
	      shell->openURL( url );
	    }
	  else
	    shell->openStdin();
	  
	}
      shell->show();
    }
  return app.exec();
}
