#include <stdio.h>
#include <stdlib.h>

#include <qapplication.h>
#include <qpushbutton.h>
#include <kapp.h>
#include <qimage.h>
#include <klocale.h>
#include <kimageio.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <kdebug.h>

#include "toplevel.h"



void dumpMap()
{
  // guess some default parameters
  QSize   mapSize(kapp->desktop()->size());

  KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

  QCString mapName = args->getOption("map");
  QCString outName = args->getOption("o");

  QCString ssize = args->getOption("size");
  if (!ssize.isEmpty())
    {
      int w,h;
      if (sscanf(ssize.data(), "%dx%d", &w, &h) == 2)
        mapSize = QSize(w,h);
    }

  kdDebug() << "map=" << mapName << " out=" << outName << " size=" << mapSize.width() << "x" << mapSize.height() << endl;

  // create a toplevel object
  World world;
  world.loadMap(mapName);
  world.loadFlags();

  world.dumpMap(outName, mapSize);
}

static const char* description=I18N_NOOP("KDE's Watch for the Planet!");
static const char* version="0.0.1";

static KCmdLineOptions options[] =
{
  { "dump", I18N_NOOP("Write out a file containing the actual map"), 0 },
  { "map <file>", I18N_NOOP("The name of the map to use for -dump"), "depths_400.png"},
  { "o <file>", I18N_NOOP("The name of the file to write to"), "dump.ppm" },
  { "size <WxH>", I18N_NOOP("The size of the map to dump"), 0 },
  { 0, 0, 0 }
};

int main( int argc, char **argv )
{
  KAboutData aboutData("kworldwatch", I18N_NOOP("KWorldWatch"),
    version, description, KAboutData::License_GPL,
    "(c) 1998-2000, Matthias Hoelzer-Kluepfel");
  aboutData.addAuthor("Matthias Hoelzer-Kluepfel",0, "hoelzer@kde.org");

  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions(options);

  KApplication app;

  KImageIO::registerFormats();

  // dump mode, used for background drawing
  KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
  if (args->isSet("dump"))
    {
      dumpMap();
      exit(0);
    }

  TopLevel *toplevel;

  if (kapp->isRestored())
    RESTORE(TopLevel)
  else
    {
      toplevel = new TopLevel();
      toplevel->setCaption(i18n("KDE World Wide Watch"));

      app.setMainWidget(toplevel);
    }

  return app.exec();
}
