/**********************************************************************
CatalogManager.cpp
Ktranslator Version 0.6.0, catalog manager               

    KDE Translation Utility
    
    
    
    
    "Dedicated to the KDE Translators"
    
    
    
    
    
    
    program by Andrea Rizzi <rizzi@kde.org>  
    01 Jun 99 / 24 Dec 99

*********************************************************************/
#include <qpixmap.h>
#include <qprogressbar.h>
#include "CatalogManager.h"
#include <qdir.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qtextstream.h>
#include <qpopupmenu.h>
#include <kapp.h>
#include <stdlib.h>
#include <qmsgbox.h>
 
CatalogManager::CatalogManager(QWidget *parent, QString basePath, QString language)
               :QListView(parent)
 {
   lang=language;
   path=basePath;
         setCaption(i18n( "Catalogues Manager") );
       addColumn(i18n( "Name") );  //0
       addColumn(i18n( "Lines") );  //1
       addColumn(i18n( "Id (lines)") );//2
       addColumn(i18n( "Str (lines)") );//3
       addColumn(i18n( "Fuzzy" ));//4
       addColumn(i18n( "Last-Translator" ));//5
       addColumn(i18n( "Creation") );//6
       addColumn(i18n( "Revision") );//7
 // setMinimumSize(140,400);
 }    

QString CatalogManager::activeName()
 { 
  Catalog *c;
  c=(Catalog *)currentItem();
  if(c!=0)
    return c->name();
  else return QString("");
 }         

QString CatalogManager::activeMsgPath()
 { 
  Catalog *c;
  c=(Catalog *)currentItem();
  if(c!=0)
    return c->msgPath();
  else return QString("");
 }

QString CatalogManager::activeTemPath()
 {
  Catalog *c;
  c=(Catalog *)currentItem();
  if(c!=0)
    return c->temPath(); 
  else return QString("") ;
 }


void CatalogManager::buildDatabase()
 {
 clear();
 warning("Building database");
 QListViewItem *lan=new QListViewItem(this,"CVS");
   QDir thisDir(path+"/templates/"); 
  int t,cou;
    
   cou=thisDir.count();    
    emit resetPb();
    emit setStatus(1);
    emit setTotal(cou);
//   QProgressBar *pb=new QProgressBar(cou);
//   pb->setCaption("Loading CVS data...");
//   pb->show();
//   pb->setGeometry(300,300,300,50);
   t=0;
 const QFileInfoList * files = thisDir.entryInfoList();
  if ( files ) {
    QFileInfoListIterator it( *files );
    QFileInfo * f;
    while( (f=it.current()) != 0 ) {
	++it;
	
	if ( f->fileName()  == "." || f->fileName() == ".." ||  f->fileName() == "CVS" )
		    emit setProgress(t++);
	   else if ( f->isDir() ){
	     new Catalog( lan, path+"/templates/"+f->fileName(),
	                 path+"/"+lang+"/messages/"+f->fileName());
			    emit setProgress(t++); 
		    KApplication::getKApplication()->processEvents();     
			 } 
	  	else 
		 if ( f->fileName().find(".po") != -1 ) {
    		new Catalog( lan, path+"/templates/",path+"/"+lang+"/messages/", /*(const char *)*/ f->fileName());
		 emit setProgress(t++); 
		}
		else emit setProgress(t++); 
	    }
	}
    emit setProgress(cou);
  // pb->close();
 }
 
 void  CatalogManager::runapp()
 {
    system((const char *)activeName());
 }     
 

void  CatalogManager::install()
 {
   QString cmd;
    cmd.sprintf("cd %s/%s/messages/%s ; make ; make install ",
    (const char *)path,(const char*)lang,(const char *)activeName());
    
//    warning((const char* )cmd);
    if(system((const char *)cmd)==0)
    {   
    QMessageBox *b= new QMessageBox(      "Compile and install","Catalogs compiled and installed",
			QMessageBox::Information, 0,0,  0,this);                       
    b->show();
    }
    
     else
     {     QMessageBox *b= new QMessageBox(      "Compile and install",
     "Cannot compile or install. Possible problems:\n-There are no Makefiles configured\n-You may need to be root",
			QMessageBox::Warning, 0,0,  0,this);                       
     b->show();
     }     
 }     

void  CatalogManager::msgCheck()
 {
    QString cmd;
    cmd.sprintf("msgfmt %s -o /tmp/ktrans_msg.mo 2> /tmp/ktrans_report",(const char *)activeMsgPath());
    warning((const char* )cmd);
    if(system((const char *)cmd)==0)
    {   
    QMessageBox *b= new QMessageBox(      "Message Format Check","No errors found",
			QMessageBox::Information, 0,0,  0,this);                       
    b->show();
    }
    
     else
     {  
	QFile report;
	QString text,rline;
	text=i18n("Errors found.\n");
	report.setName("/tmp/ktrans_report");
	if(report.open(IO_ReadOnly)) {
	QTextStream t(&report);
	while(!t.eof()) {
	rline = t.readLine();
	text+=rline;
	text+="\n";
	}
	}
        QMessageBox *b= new QMessageBox(      "Message Format Check",text,
			QMessageBox::Warning, 0,0,  0,this);                       
     b->show();
     }     
     
    system("rm -f /tmp/ktrans_msg.mo /tmp/ktrans_report");
 }     
 
void  CatalogManager::refresh()
 {
    buildDatabase();
 }


void  CatalogManager::mousePressEvent( QMouseEvent *e)
{
 if(itemAt(e->pos())==NULL) return;
 setCurrentItem(itemAt(e->pos()));
 setSelected(itemAt(e->pos()),true);
 if(e->button()==RightButton) 
   {
    
     if(itemAt(e->pos())!=firstChild())
     ((Catalog *) itemAt(e->pos()) )->popUpMenu(mapToGlobal( e->pos()),this);
     else
      {
	 QPopupMenu *file = new QPopupMenu;
          file->insertItem( i18n("Reload CVS") ,this    , SLOT(refresh()));
         // file->insertItem( "CVS Check-Out" ,this , SLOT(nothing()));
          file->popup(mapToGlobal(e->pos()));
      }
   }
 if(e->button()==MidButton)
   {
    if(itemAt(e->pos())!=firstChild())
	emit openFile();
   }
}


Catalog::Catalog( QListViewItem *parent,QString temPath,QString msgPath,const char * name=0)
	:QListViewItem(parent)
{
 QString iconName;
 QPixmap pm;
if (name!=0)
 {
   myName=name;
   myName.truncate(myName.length()-4);
   fPot.setName(temPath+"/"+myName+".pot");
   fPo.setName(msgPath+"/"+myName+".po");
  
     iconName=kapp->kde_icondir()+"/mini/";
  //iconName="/opt/kde/share/icons/mini";

   if (fPo.exists())
   {

  
    if(!fPo.open(IO_ReadOnly))
      {
       warning("Non si apre!!!");
      }
    QTextStream t(&fPo);
    QString s,n;
    int f=0,mi=0,ms=0,li=0,lc=0,le=0,lmi=0,lms=0,cf=0;
    int status=0;
     int r;
    bool lfd0=true,lfd1=true,lft=true,inc=true,fm=false;
    while (!t.eof())
    {

     s = t.readLine();
     n = s.copy();
     while (n.find(" ")==0)
     {
      n = n.right(n.length()-1);
     
     }
     if (n.find("#")==0) { status=1; lc++;}
//     if (status==1) if(n.find("~")==1) {status==-1;warning("old"); }
     if (status==1) if(n.find("fuzzy")!=-1) {fm=true; /*f++;*/}
     if (status==1) if(n.find("c-format")!=-1) {cf++;}
     if (n.find("msgid")==0) { status=2;mi++;if (fm) {f++;fm=false;  }}
     if (n.find("msgstr")==0) { status=3; inc=true;/*ms++;*/}
     if ((n.find("\"")==-1)) { if(status!=1) le++; status=0; }
     if (status==2) lmi++;
     if (status==3)
			{ int a,b;
//				     warning(n);
				a= n.find("\"");
        b= n.right(n.length()-a-1).find("\"");
//	 			     warning("%d %d",b,a);
				if(b>0)
				{
//				    warning("inc");
					lms++;
 					if(inc) { ms++; inc=false;}
				}
      }
     if ((lfd0)&&(status==3)) {
      r = n.find("PO-Revision-Date: ");
        if(r!=-1) {setText(7,n.mid(r+18,n.length()-r-18-3));
      lfd0 =false;}
      }
     if ((lfd1)&&(status==3)) {
      r = n.find("POT-Creation-Date: ");
        if(r!=-1) {setText(6,n.mid(r+19,n.length()-r-19-3));
      lfd1 =false;}
      }
     if ((lft)&&(status==3)) {
      r = n.find("Last-Translator: ");
        if(r!=-1) {setText(5,n.mid(r+17,n.length()-r-17-3));
      lft =false;}
      } 
      

     li++;
    }
    QString tmpS;
    tmpS.sprintf("%d",li);
    setText(1,tmpS);
    tmpS.sprintf("%d (%d)",mi,lmi);
    setText(2,tmpS);
    tmpS.sprintf("%d (%d)",ms,lms);
    setText(3,tmpS);
    tmpS.sprintf("%d",f);
    setText(4,tmpS);
//    warning("Lines:%d MsgId:%d (l:%d) MsgStr:%d (l:%d)\n",li,mi,lmi,ms,lms);
//    warning("Fuzzy:%d CFormat:%d EmptyLines:%d Comment:%d\n",f,cf,le,lc);
   if((mi==ms)&&(f==0))
 		 pm.load(iconName+"/mini-exclam.xpm");
    else
 		 pm.load(iconName+"/mini-exp.xpm");

  } else
   if (fPot.exists())
    pm.load(iconName+"/mini-cross.xpm");
 

 
 
 }
 else
 {
   myName=temPath.right(temPath.length()-temPath.findRev("/")-1);
   iconName=myName.right(myName.length()-3);
   iconName+="_package.xpm";

      iconName.insert(0,kapp->kde_icondir()+"/mini/");
//   iconName.insert(0,"/opt/kde/share/icons/mini/");
   if (myName=="kdeadmin")
       pm.load(kapp->kde_icondir()+"/mini/settings_package.xpm");
   else
   if (!pm.load(iconName))
        pm.load(kapp->kde_icondir()+"/mini/package.xpm");

   
   QDir thisDir(temPath+"/");   
  const QFileInfoList *files = thisDir.entryInfoList();
   if (files) {
      QFileInfoListIterator it(*files); 
      QFileInfo *f;
      while( (f=it.current()) != 0 ) {
  	++it;
  	if( f->isFile() )    
  	     if ( f->fileName().find(".po") != -1 )
 		new Catalog( this, temPath,msgPath, /*(const char *)*/ f->fileName());
   				       
 	    }
    }

 }
 setPixmap(0,pm);  
 setText(0,myName); 
}


void  Catalog::popUpMenu(QPoint pos,QWidget *receiver    )
{
 QPopupMenu *file = new QPopupMenu;
 if (fPo.exists())
  file->insertItem("Open po" ,receiver    , SIGNAL(openFile()));
 if (fPot.exists())
    file->insertItem("Open pot",receiver  , SIGNAL(openFilePot()));
  else
   file->insertItem( "make ; make install" ,receiver      , SLOT(install()));
 
  //file->insertItem( "Open with..." ,receiver      , SLOT(nothing()));
  file->insertItem( "MsgFmt Check" ,receiver      , SLOT(msgCheck()));
 // file->insertItem( "Compile && Install" ,receiver      , SLOT(install()));
  file->insertItem( "Run application" ,receiver, SLOT( runapp()));
  
  file->popup(pos);
}


QString  Catalog::name()
{
return myName;
}
QString  Catalog::msgPath()
{
return fPo.name();
}

QString  Catalog::temPath()
{
return fPot.name();
}    

#include "CatalogManager.moc"























