/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */

#ifndef POAUXILIARY_H
#define POAUXILIARY_H

#include "searchengine.h"

#include <qguardedptr.h>
#include <qdict.h>
class QTimer;
class KConfig;

class Catalog;
class PreferencesWidget;

class PoAuxiliary : public SearchEngine
{
    Q_OBJECT

public:
    PoAuxiliary(QObject *parent=0, const char *name=0);
    virtual ~PoAuxiliary();

    virtual bool isReady() const;

    virtual QString translate(const QString text);

    virtual bool isSearching() const;

    virtual void saveSettings(KConfigBase *config);
    virtual void readSettings(KConfigBase *config);

    virtual PrefWidget *preferencesWidget(QWidget *parent);

    virtual const KAboutData *about() const;

    virtual QString name() const;
    
    virtual QString id() const;

    virtual QString lastError();

    virtual bool usesRichTextResults();

public slots:
    virtual bool startSearch(QString);
    
    virtual void stopSearch();

    virtual void setEditedFile(QString);
    virtual void setEditedPackage(QString);
    virtual void setLanguageCode(QString);
        

protected slots:
    /** reads the current settings from the preferences dialog */
    void applySettings();
    
    /** sets the current settings in the preferences dialog */
    void restoreSettings();

    void loadAuxiliary();
    
private:
    QGuardedPtr<PreferencesWidget> prefWidget;
    Catalog *catalog;
    QString auxPackage;
    QString auxTranslator;

    QString url;
    bool ignoreFuzzy;

    QString editedFile;
    QString package;
    QString langCode;

    bool error;
    QString errorMsg;

    bool stop;
    bool active;
    bool loading;
    bool initialized;

    QTimer *loadTimer;

    struct Entry
    {
        QString translation;
        QString comment;
        bool fuzzy;
    };

    QDict<Entry> entryDict;
    
    KConfigBase *conf;
    QString confGroup;
};

#endif
