/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2001 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */
#ifndef ROUGHTRANSDLG_H
#define ROUGHTRANSDLG_H

#include <kdialogbase.h>


class KBabelDictBox;
class Catalog;
class DictChooser;

class KProgress;
class QCheckBox;
class QRadioButton;
class QVBox;

class RoughTransDlg : public KDialogBase
{
    Q_OBJECT

public:
    RoughTransDlg(KBabelDictBox* dictBox, Catalog* catalog, QWidget *parent
            , const char *name=0);
    ~RoughTransDlg();

    void statistics(int &total, int& exactTranslated
            , int& partlyTranslated) const; 
    

protected slots:
    void slotUser1();
    void slotUser2();
    void slotUser3();

    void slotClose();

    void msgButtonClicked();
    void fuzzyButtonToggled(bool);

private:
    KBabelDictBox *dictBox;
    Catalog *catalog;
    
    DictChooser *dictChooser;
    QVBox *configWidget;
    
    KProgress *progressbar;
    
    QRadioButton *allButton;
    QRadioButton *untransButton;
    
    QRadioButton *wholeMsgButton;
    QRadioButton *singleWordButton;

    QCheckBox *markFuzzyButton;

    bool active;
    bool stop;
    bool cancel;

    int exactTransCounter;
    int partTransCounter;
    int totalTried;
};

#endif // ROUGHTRANSDLG_H
