/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */
#include "catalogsettings.h"
#include <kconfig.h>
#include <kglobal.h>
#include <klocale.h>
#include <stdlib.h>
#include <qtextcodec.h>
#include <qregexp.h>

#include <stdlib.h>

const QString Defaults::Save::customDateFormat="%Y-%m-%d %H:%M%Z";

QString charsetString(QTextCodec *codec)
{
    QString encodingStr;
    if(codec)
    {
        encodingStr = codec->name();
        encodingStr=encodingStr.upper();
        encodingStr.replace(QRegExp(" "),"-");
    }

    return encodingStr;
}

QString charsetString(FileEncoding e)
{
    QString encodingStr;

    switch(e)
    {
        case Locale:
        {
            QTextCodec *codec=QTextCodec::codecForLocale();
            if(codec)
               encodingStr=charsetString(codec);
            else
               encodingStr="unknown";

            break;
        }
        case UTF8:
        {
            encodingStr="UTF-8";
            break;
        }
        case UTF16:
        {
            encodingStr="UTF-16";
            break;
        }
    }

    return encodingStr;
}

QString Defaults::Identity::authorName()
{
   if(_authorName.isNull())
   {
      KConfig mailConf("emaildefaults",true);
      mailConf.setGroup("UserInfo");

      _authorName=mailConf.readEntry("FullName","");
   }

   return _authorName;
}

QString Defaults::Identity::authorEmail()
{
   if(_authorEmail.isNull())
   {
      KConfig mailConf("emaildefaults",true);
      mailConf.setGroup("UserInfo");

      _authorEmail=mailConf.readEntry("EmailAddress","");
   }

   return _authorEmail;
}

QString Defaults::Identity::mailingList()
{
   if(_mailingList.isNull())
   {
      QString lang="de_DE";//=Defaults::Search::defaultLang();
      int temp=lang.find("_");
      lang=lang.left(temp);
      _mailingList=lang+"@li.org";
   }

   return _mailingList;
}

QString Defaults::Identity::languageName()
{
   if(_languageName.isNull())
   {
      _languageName="";
   }

   return _languageName;
}

QString Defaults::Identity::languageCode()
{   
   if(_languageCode.isNull())
   {     
      // first try to get the language from KDE settings
      KLocale *locale = KGlobal::locale();
      QString lang;
      if(locale)
      {
          lang=locale->languageList().first();
      }

      if(lang.isEmpty())
      {
         lang=getenv("LC_ALL");
         if(lang.isEmpty())
         {
            lang=getenv("LC_MESSAGES");
            if(lang.isEmpty())
            {
               lang=getenv("LANG");
            }
         }
      }

      _languageCode=lang;
   }

   return _languageCode;
}

QString Defaults::Identity::timezone()
{
   if(_timezone.isNull())
   {
     _timezone=getenv("TIMEZONE");
     if(_timezone.isEmpty())
       _timezone="GMT";
   }

   return _timezone;
}


QString Defaults::Identity::_authorName=QString::null;
QString Defaults::Identity::_authorEmail=QString::null;
QString Defaults::Identity::_mailingList=QString::null;
QString Defaults::Identity::_timezone=QString::null;
QString Defaults::Identity::_languageName=QString::null;
QString Defaults::Identity::_languageCode=QString::null;


const QChar Defaults::Misc::accelMarker('&');
const QRegExp Defaults::Misc::contextInfo("^_:[^\n]+\n");

