/* $TOG: dpylist.c /main/30 1998/02/09 13:55:07 kaleb $ */
/* $Id: dpylist.c,v 1.5.2.1 2001/03/15 17:35:05 ossi Exp $ */
/*

Copyright 1988, 1998  The Open Group

All Rights Reserved.

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of The Open Group shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from The Open Group.

*/
/* $XFree86: xc/programs/xdm/dpylist.c,v 1.3 2000/04/27 16:26:50 eich Exp $ */

/*
 * xdm - display manager daemon
 * Author:  Keith Packard, MIT X Consortium
 *
 * a simple linked list of known displays
 */

# include "dm.h"
# include "dm_error.h"

static struct display	*displays;
static struct disphist	*disphist;

int
AnyDisplaysLeft (void)
{
	return displays != (struct display *) 0;
}

void
ForEachDisplay (void (*f)(struct display *))
{
	struct display	*d, *next;

	for (d = displays; d; d = next) {
		next = d->next;
		(*f) (d);
	}
}

struct display *
FindDisplayByName (char *name)
{
	struct display	*d;

	for (d = displays; d; d = d->next)
		if (!strcmp (name, d->name))
			return d;
	return 0;
}

struct display *
FindDisplayByPid (int pid)
{
	struct display	*d;

	for (d = displays; d; d = d->next)
		if (pid == d->pid)
			return d;
	return 0;
}

struct display *
FindDisplayByServerPid (int serverPid)
{
	struct display	*d;

	for (d = displays; d; d = d->next)
		if (serverPid == d->serverPid)
			return d;
	return 0;
}

#ifdef XDMCP

struct display *
FindDisplayBySessionID (CARD32 sessionID)
{
    struct display	*d;

    for (d = displays; d; d = d->next)
	if (sessionID == d->sessionID)
	    return d;
    return 0;
}

struct display *
FindDisplayByAddress (XdmcpNetaddr addr, int addrlen, CARD16 displayNumber)
{
    struct display  *d;

    for (d = displays; d; d = d->next)
	if (d->displayType.origin == FromXDMCP &&
	    d->displayNumber == displayNumber &&
	    addressEqual (d->from, d->fromlen, addr, addrlen))
	{
	    return d;
	}
    return 0;
}

#endif /* XDMCP */

#define IfFree(x)  if (x) free ((char *) x)
    
void
RemoveDisplay (struct display *old)
{
    struct display	*d, *p;
    char		**x;
    int			i;

    p = 0;
    for (d = displays; d; d = d->next) {
	if (d == old) {
	    if (p)
		p->next = d->next;
	    else
		displays = d->next;
	    IfFree (d->class2);
	    for (x = d->argv; x && *x; x++)
		IfFree (*x);
	    IfFree (d->argv);
	    IfFree (d->resources);
	    IfFree (d->xrdb);
	    IfFree (d->setup);
	    IfFree (d->startup);
	    IfFree (d->reset);
	    IfFree (d->session);
	    IfFree (d->userPath);
	    IfFree (d->systemPath);
	    IfFree (d->systemShell);
	    IfFree (d->failsafeClient);
	    IfFree (d->chooser);
	    if (d->authorizations)
	    {
		for (i = 0; i < d->authNum; i++)
		    XauDisposeAuth (d->authorizations[i]);
		free ((char *) d->authorizations);
	    }
	    IfFree (d->clientAuthFile);
	    if (d->authFile)
		(void) unlink (d->authFile);
	    IfFree (d->authFile);
	    IfFree (d->userAuthDir);
	    for (x = d->authNames; x && *x; x++)
		IfFree (*x);
	    IfFree (d->authNames);
	    IfFree (d->authNameLens);
#ifdef XDMCP
	    IfFree (d->peer);
	    IfFree (d->from);
	    XdmcpDisposeARRAY8 (&d->clientAddr);
#endif
	    IfFree (d->noPassUsers);
	    IfFree (d->autoUser);
	    IfFree (d->autoPass);
	    IfFree (d->autoString);
	    free ((char *) d);
	    break;
	}
	p = d;
    }
}

struct disphist *
FindHist (char *name)
{
    struct disphist *hstent;

    for (hstent = disphist; hstent; hstent = hstent->next)
	if (!strcmp (hstent->name, name))
	    return hstent;
    return 0;
}

struct display *
NewDisplay (char *name, char *class2)
{
    struct display	*d;
    struct disphist	*hstent;

    if (!(hstent = FindHist (name))) {
	if (!(hstent = malloc (sizeof (*hstent)))) {
	    LogOutOfMem ("NewDisplay");
	    return 0;
	}
	hstent->startTries = 0;
	hstent->lastExit = 0;
	hstent->goodExit = 0;
	hstent->nLogPipe = NULL;
	if (!StrDup (&hstent->name, name)) {
	    free (hstent);
	    LogOutOfMem ("NewDisplay");
	    return 0;
	}
	hstent->next = disphist; disphist = hstent;
    }

    if (!(d = (struct display *) malloc (sizeof (*d)))) {
	LogOutOfMem ("NewDisplay");
	return 0;
    }
    d->next = displays;
    d->hstent = hstent;
    d->name = hstent->name;
    if (!StrDup (&d->class2, class2)) {
	LogOutOfMem ("NewDisplay");
	free ((char *) d);
	return 0;
    }
    /* initialize every field to avoid possible problems */
    d->argv = 0;
    d->status = notRunning;
    d->pid = -1;
    d->serverPid = -1;
    d->state = NewEntry;
    d->resources = NULL;
    d->xrdb = NULL;
    d->setup = NULL;
    d->startup = NULL;
    d->reset = NULL;
    d->session = NULL;
    d->userPath = NULL;
    d->systemPath = NULL;
    d->systemShell = NULL;
    d->failsafeClient = NULL;
    d->chooser = NULL;
    d->authorize = FALSE;
    d->authorizations = NULL;
    d->authNum = 0;
    d->authNameNum = 0;
    d->clientAuthFile = NULL;
    d->authFile = NULL;
    d->userAuthDir = NULL;
    d->authNames = NULL;
    d->authNameLens = NULL;
    d->authComplain = 1;
    d->openDelay = 0;
    d->openRepeat = 0;
    d->openTimeout = 0;
    d->startAttempts = 0;
    d->startTries = 0;	/* unused */
    d->terminateServer = 0;
    d->grabTimeout = 0;
#ifdef XDMCP
    d->sessionID = 0;
    d->peer = 0;
    d->peerlen = 0;
    d->from = 0;
    d->fromlen = 0;
    d->displayNumber = 0;
    d->useChooser = 0;
    d->clientAddr.data = NULL;
    d->clientAddr.length = 0;
    d->connectionType = 0;
#endif
    d->startInterval = 0;
    d->noPassUsers = NULL;
    d->autoLogin = autoLogin;
    d->autoReLogin = 0;
    d->autoLogin1st = 1;
    d->autoUser = NULL;
    d->autoPass = NULL;
    d->autoString = NULL;
    d->fifoCreate = 0;
    d->fifoOwner = -1;
    d->fifoGroup = -1;
    d->fifofd = -1;
    d->pipefd[0] = -1;
    d->pipefd[1] = -1;
    d->version = 1;		/* registered with The Open Group */
    displays = d;
    return d;
}
