#include "expert.moc"
#include <ui.h>
#include <qwhatsthis.h>
#include <String.h>
#include <strstream>
Expert::Expert(liloconf *l, QWidget *parent, const char *name):QWidget(parent, name)
{
	lilo=l;
	layout=new QHBoxLayout(this);
	edit=new QMultiLineEdit(this);
	layout->addWidget(edit);
	connect(edit, SIGNAL(textChanged()), SIGNAL(configChanged()));
	QWhatsThis::add(edit, _("You can edit the lilo.conf file directly here. All changes you make here are automatically transferred to the graphical interface."));
	update();
}
Expert::~Expert()
{
	delete edit;
}
void Expert::update()
{
	edit->setText(((String)*lilo).cstr());
}
void Expert::saveChanges()
{
	lilo->set(edit->text().latin1());
}

