/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#include <qlayout.h>

#include "devtitle.h"
#include "propdrvtab.h"
#include "vendorinfobox.h"


DriverPropertiesTab::DriverPropertiesTab(Device *device, QWidget *parent, 
					 const char *name) : QWidget(parent, name)
{
  QString  devname   = device->deviceName();
  QString  classname = device->deviceClassName();
  
  if (!classname.isEmpty()) devname += " ("+classname+")";
  
  DeviceTitle    *devtitle  = new DeviceTitle(device->bigPixmapFile(), devname, this, "devtitle");
  VendorInfoBox  *vendorbox = new VendorInfoBox(device,                         this, "vendorbox");
  
  QVBoxLayout    *toplayout = new QVBoxLayout(this, 16, 4, "toplayout");
  
  toplayout->addWidget(devtitle);
  toplayout->addSpacing(16);
  toplayout->addWidget(vendorbox);
  toplayout->addStretch(1);  
  
  toplayout->activate();
}


