/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#ifndef __PCCARDDEVICE_H
#define __PCCARDDEVICE_H

#include <qstring.h>

#include "device.h"


QString runCardCtl(QString cmd, int socket);


class PCCardDevice : public Device
{
  public:
  
    PCCardDevice(QString ident, int socket);
    ~PCCardDevice() {}
    
    virtual bustype   busType() 	     const { return BusPCI; }
    
    virtual QString   deviceClassName();
    virtual QString   deviceName();
    virtual devstate  deviceState();
    virtual QString   vendorName();
    
  private:

    QString _ident;

    int _function;
    int _socket;

    QString   _vendorname;
    QString   _devicename;
    
    uint      _bus, _slot, _func;
    uint      _vendorid, _deviceid;
    devstate  _devicestate;
    
    void  lookupData();
};


#endif
