/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#ifndef __PARTITIONINFO_H
#define __PARTITIONINFO_H

#include <qstring.h>


class PartitionInfo
{
  public:
  
    PartitionInfo(const QString& partid, ushort major, ushort minor,
    		  const QString& mountp, 
                  ulong blocks, ulong total, ulong used, ulong avail);
                  
    ~PartitionInfo() {}

    ulong    blocks() const { return _blocks;                  }
    QString  path()   const { return QString("/dev/")+_partid; }
    
  private:
  
    QString  _partid, _mountp;
    ushort   _major, _minor;
    ulong    _blocks, _total, _used, _avail;
};


#endif
