/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#include <kapp.h>

#include "device.h"


Device::Device(baseclass bclass, const QString& name) : _devname(name),
				                        _baseclass(bclass),
							_conflict(false)
{
  _reslist.setAutoDelete(true);
  _reslist.clear();
}


void  Device::addResource(Resource *res)
{
  _reslist.append(res);
}


void  Device::removeResource(Resource *res)
{
  _reslist.removeRef(res);
}


QString  Device::bigPixmapFile()
{
  switch (_baseclass)
  {
    case BaseClassPCIUnclassified       : return QString("system");
    case BaseClassPCIStorage	        : return QString("drivectrl");
    case BaseClassPCINetwork	        : return QString("network");
    case BaseClassPCIDisplay	        : return QString("display");
    case BaseClassPCIMultimedia	        : return QString("audio");
    case BaseClassPCIMemory	        : return QString("memory");
    case BaseClassPCIBridge	        : return QString("system");
    case BaseClassPCICommunication      : return QString("network");
    case BaseClassPCISystem	        : return QString("system");
    case BaseClassPCIInput 	        : return QString("system");
    case BaseClassPCIDocking	        : return QString("system");
    case BaseClassPCIProcessor	        : return QString("system");
    case BaseClassPCISerial	        : return QString("usb");

    case BaseClassConnector             : return QString("connectors");
    case BaseClassMassStorageController : return QString("drivectrl");
    case BaseClassMassStorage           : return QString("storage");
    case BaseClassPrinter               : return QString("printer");
    case BaseClassCDROM                 : return QString("cdrom");
    case BaseClassSCSIController        : return QString("scsi");
    case BaseClassScanner               : return QString("scanner");

    default			        : return QString("system");
  }
}


QString  Device::deviceBaseClassName()
{
  switch (_baseclass)
  {
    case BaseClassPCIUnclassified       : return QString(i18n("Unclassified devices"));
    case BaseClassPCIStorage	        : return QString(i18n("Mass storage controllers"));
    case BaseClassPCINetwork	        : return QString(i18n("Network controllers"));
    case BaseClassPCIDisplay	        : return QString(i18n("Display controllers"));
    case BaseClassPCIMultimedia	        : return QString(i18n("Audio, video and game controllers"));
    case BaseClassPCIMemory	        : return QString(i18n("Memory"));
    case BaseClassPCIBridge	        : return QString(i18n("System components"));
    case BaseClassPCICommunication      : return QString(i18n("Communication controllers"));
    case BaseClassPCISystem	        : return QString(i18n("System components"));
    case BaseClassPCIInput 	        : return QString(i18n("Input device controllers"));
    case BaseClassPCIDocking	        : return QString(i18n("Docking stations"));
    case BaseClassPCIProcessor	        : return QString(i18n("System components"));
    case BaseClassPCISerial	        : return QString(i18n("Serial bus controllers"));

    case BaseClassConnector             : return QString(i18n("Connectors"));
    case BaseClassMassStorage           : return QString(i18n("Drives"));
    case BaseClassMassStorageController : return QString(i18n("Mass storage controllers"));
    case BaseClassPrinter               : return QString(i18n("Printer"));
    case BaseClassCDROM                 : return QString(i18n("CD-ROM"));
    case BaseClassSCSIController        : return QString(i18n("SCSI controllers"));
    case BaseClassScanner               : return QString(i18n("Scanners"));
    case BaseClassPCCard                : return QString(i18n("PC-Cards"));
	case BaseClassProcessor				: return QString(i18n("Processor"));

    default			        : return QString(i18n("Unknown device class"));
  }
}


QString  Device::smallPixmapFile()
{
  switch (_baseclass)
  {
    case BaseClassPCIUnclassified       : return QString("kcmsystem");
    case BaseClassPCIStorage	        : return QString("drivectrl");
    case BaseClassPCINetwork	        : return QString("network");
    case BaseClassPCIDisplay	        : return QString("kcontrol");
    case BaseClassPCIMultimedia	        : return QString("kcmsound");
    case BaseClassPCIMemory	        : return QString("kcmmemory");
    case BaseClassPCIBridge	        : return QString("kcmsystem");
    case BaseClassPCICommunication      : return QString("network");
    case BaseClassPCISystem	        : return QString("kcmsystem");
    case BaseClassPCIInput 	        : return QString("kcmsystem");
    case BaseClassPCIDocking	        : return QString("kcmsystem");
    case BaseClassPCIProcessor	        : return QString("kcmsystem");
    case BaseClassPCISerial	        : return QString("usb");

    case BaseClassConnector             : return QString("connectors");
    case BaseClassMassStorage           : return QString("hdd_unmount");
    case BaseClassMassStorageController : return QString("drivectrl");
    case BaseClassPrinter               : return QString("printer1.png");
    case BaseClassCDROM                 : return QString("cdrom_unmount");
    case BaseClassSCSIController        : return QString("kcmscsi");
    //case BaseClassScanner               : return QString("scanner");
    case BaseClassPCCard                : return QString("laptop_pcmcia");
	case BaseClassProcessor				: return QString("kcmprocessor");
    default			        : return QString("kcmsystem");
  }
}


