//////////////////////////////////////////////////////////////         
//      $Id: options.h,v 1.11 2001/01/13 04:36:26 toivo Exp $ 
//
// Author: Toivo Pedaste
//
#ifndef OPTIONS_H
#define OPTIONS_H

#include "../config.h"

// Standard Headers
#include <stdio.h>

// Qt Headers
#include <qdir.h>
#include <qwidget.h>
#include <qframe.h>
#include <qlabel.h>
#include <qfiledlg.h> 
#include <qgrpbox.h> 
#include <qchkbox.h>
#include <qlayout.h> 
#include <qlined.h>
#include <qbttngrp.h>
#include <qradiobt.h>
#include <qtabdlg.h>

// KDE headers
#include <kapp.h>
#include <kmenubar.h>
#include <kbuttonbox.h> 
#include <kfiledialog.h> 

#include <kpackage.h>

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
class Options : public QDialog
{
  Q_OBJECT

public:

  Options ( QWidget *parent = 0);
  ~Options(); 

  void restore();
  // show window, setting the buttons

  void setValues();
  // set the dialog to match options values

private:

  bool verifyFL;
  bool PkgRead;
  int  DCache, dc, PCache, pc;

  QTabDialog *tab;


  QVBoxLayout* vl;

  QVBoxLayout* vt;
  QGroupBox *framet;
  QCheckBox *packageHandle[kpinterfaceN];

  QVBoxLayout* vb;
  QButtonGroup *bg;
  QRadioButton *disp[4];

  QVBoxLayout*  vc;
  QButtonGroup *bc;
  QRadioButton *dcache[3];

  QVBoxLayout*  vp;
  QButtonGroup *bp;
  QRadioButton *pcache[3];

  QVBoxLayout* vr;
  QGroupBox *framer;
  QCheckBox *pkgRead;

  QVBoxLayout* vf;
  QGroupBox *framem;
  QCheckBox *valid;

  QCheckBox *ssh;

public slots:
    void apply_slot();
    void cancel_slot();
    void PDCache(int);
    void PPCache(int);
};

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

class Opts
{
public:
  void readSettings();
  void writeSettings();

  bool VerifyFL;
  // config: verify the file list

  bool PkgRead;
  // read information about uninstalled packages from each RPM file itself

  bool handlePackage[kpinterfaceN];

  enum {INSTALLED, UPDATED, NEW, ALL};
  enum {ALWAYS, SESSION, NEVER};

  int DCache;
  // how much to cache uninstall package directories

  int PCache;
  // how much to cache uninstall packages

  bool useSSH;

  Opts();
  ~Opts();
};
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
#endif 
