//////////////////////////////////////////////////////////////         
//      $Id: options.cpp,v 1.18 2001/01/13 04:36:26 toivo Exp $ 
//
// Author: Toivo Pedastse
//
#include "../config.h"

#include "kpackage.h"
#include "managementWidget.h"
#include "pkgInterface.h"
#include "options.h"
#include "cache.h"
#include <klocale.h>

extern Opts *opts;
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
Options::Options(QWidget *parent)
    : QDialog(parent, 0, FALSE){


    DCache = dc = opts->DCache;
    PCache = pc = opts->PCache;

    if (DCache >= Opts::SESSION) {
      cacheObj::clearDCache(); // clear dir caches if needed
    }
    if (PCache >= Opts::SESSION) {
      cacheObj::clearPCache(); // clear package caches if needed
    }

    tab = new QTabDialog(0,"Options");
    tab->setCaption(i18n("Options"));

    {
      framet = new QGroupBox(i18n("Handle package type"), tab);
      QVBoxLayout* vt = new QVBoxLayout(framet,20,20);

      int i;
      for (i = 0; i < kpinterfaceN; i++)  {
	if (kpinterface[i]) {
	  packageHandle[i] =  new QCheckBox(kpinterface[i]->name, framet);
	  vt->addWidget(packageHandle[i],0,AlignLeft);
	} else {
	  packageHandle[i] =  0;
	}
      }

    }
    tab->addTab(framet,i18n("Types"));

     {
      bc = new QButtonGroup(tab);
      bc->setTitle(i18n("Cache remote package directories"));
      connect( bc, SIGNAL(clicked(int)), SLOT(PDCache(int)) );

      QVBoxLayout* vc = new QVBoxLayout( bc, 15, 10, "vc");
      vc->addSpacing( bc->fontMetrics().height() );

      dcache[0] = new QRadioButton(i18n("Always"),bc);
      vc->addWidget(dcache[0]);

      dcache[1] = new QRadioButton(i18n("During a session"),bc);
      vc->addWidget(dcache[1]);

      dcache[2] = new QRadioButton(i18n("Never"),bc);
      vc->addWidget(dcache[2]);

    }
    tab->addTab(bc,i18n("Directory Cache"));

    {
      bp = new QButtonGroup(tab);
      bp->setTitle(i18n("Cache remote package files"));
      connect( bp, SIGNAL(clicked(int)), SLOT(PPCache(int)) );

      QVBoxLayout* vp = new QVBoxLayout( bp, 15, 10, "vp");
      vp->addSpacing( bp->fontMetrics().height() );

      pcache[0] = new QRadioButton(i18n("Always"),bp);
      vp->addWidget(pcache[0]);

      pcache[1] = new QRadioButton(i18n("During a session"),bp);
      vp->addWidget(pcache[1]);

      pcache[2] = new QRadioButton(i18n("Never"),bp);
      vp->addWidget(pcache[2]);

    }
    tab->addTab(bp,i18n("Package Cache"));

    {
      framem = new QGroupBox("", tab);
      QVBoxLayout* vf = new QVBoxLayout(framem,20,20);

      ssh = new QCheckBox(i18n("Use SSH for privileged commands"), framem, "ssh");
      vf->addWidget(ssh,0,AlignLeft);

      valid = new QCheckBox(i18n("Verify file list"), framem, "valid");
      vf->addWidget(valid,0,AlignLeft);

      pkgRead = new QCheckBox(i18n("Read information from all local package files"), framem, "pkgr");
      vf->addWidget(pkgRead,0,AlignLeft);
    }
    tab->addTab(framem,i18n("misc"));

    tab->setCancelButton( i18n("Cancel") );
    tab->setApplyButton( i18n("Apply") );
    tab->setOkButton( i18n("OK") );

    connect( tab, SIGNAL(applyButtonPressed()), SLOT(apply_slot()) );
    connect( tab, SIGNAL(cancelButtonPressed()), SLOT(cancel_slot()) );

    setValues();
}

void Options::setValues() {

  DCache = dc = opts->DCache;
  PCache = pc = opts->PCache;

  int i;
  for (i = 0; i < kpinterfaceN; i++)  {
    if (kpinterface[i]) {
      packageHandle[i]->setChecked(opts->handlePackage[i]);
    }
  }

  dcache[DCache]->setChecked(TRUE);
  pcache[PCache]->setChecked(TRUE);

  ssh->setChecked(opts->useSSH);
  valid->setChecked(opts->VerifyFL);
  pkgRead->setChecked(opts->PkgRead);
}

Options::~Options()
{
}

void Options::restore() 
{
  opts->readSettings();
  setValues();
  tab->show();
}

void Options::cancel_slot() 
{
  kdDebug() << "Cancel\n";
  opts->readSettings();
}

 void Options::apply_slot() 
{
  kdDebug() << "Apply\n";
  opts->useSSH = ssh->isChecked();
  opts->VerifyFL = valid->isChecked();
  opts->PkgRead = pkgRead->isChecked();

  opts->DCache = dc;
  opts->PCache = pc;

  int i;
  for (i = 0; i < kpinterfaceN; i++)  {
    if (packageHandle[i]) {
      opts->handlePackage[i] = packageHandle[i]->isChecked();
    }
  }

  kpkg->scanLocates();
  opts->writeSettings();
}

void Options::PDCache(int r)
{
  dc = r;
}

void Options::PPCache(int r)
{
  pc = r;
}

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

Opts::Opts()
{
readSettings();
}

Opts::~Opts()
{
}

void Opts::readSettings()
{
  
  KConfig *config = kapp->config();

  config->setGroup("Kpackage");

  DCache = config->readNumEntry("Dir_Cache",1);
  if (DCache >2) {
    kdDebug() << "DCache=" << DCache << "\n";
    DCache = 1;
  }
  PCache = config->readNumEntry("Package_Cache",0);
  if (PCache >2) {
    kdDebug() << "PCache=" << PCache << "\n";
    PCache = 0;
  }

  useSSH = config->readNumEntry("Use_SSH",0);
  VerifyFL = config->readNumEntry("Verify_File_List",1);
  PkgRead = config->readNumEntry("Read_Package_files",0);

  int i;
  for (i = 0; i < kpinterfaceN; i++)  {
    if (kpinterface[i])
      handlePackage[i] = config->readBoolEntry(kpinterface[i]->head,
						      kpinterface[i]->defaultHandle);
  }
}

void Opts::writeSettings()
{
  
  KConfig *config = kapp->config();

  config->setGroup("Kpackage");

  config->writeEntry("Dir_Cache", DCache);
  config->writeEntry("Package_Cache", PCache);

  config->writeEntry("Use_SSH",useSSH );
  config->writeEntry("Verify_File_List",VerifyFL );
  config->writeEntry("Read_Package_files", PkgRead);

  int i;
  for (i = 0; i < kpinterfaceN; i++)  {
    if (kpinterface[i])
      config->writeEntry(kpinterface[i]->head, handlePackage[i]);
  }
}

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
