/* vi:set ts=8 sts=0 sw=8:
 * $Id: prefs_private.h,v 1.1 2000/03/29 06:23:08 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __PREFS_PRIVATE_H__
#define __PREFS_PRIVATE_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gtk/gtk.h>
#include "main.h"

#define COL_VAL_GDK	65535.0		/* GdkColor is 16-bit color */

typedef enum {
	GenericType,
	EntryType,
	ButtonType,
	ComboType
} wgttype_t;

typedef enum { Foreground, Background, HighlightFg, HighlightBg } which_text_t;

/* used by color selection */
typedef struct {
	GtkWidget *	cs;
	which_text_t	which;
} prefs_color_sel_t;

extern void prefs_update(void);
extern void prefs_wgtopt_list_add(GtkWidget *, wgttype_t, void *, char *);
extern void color_sel_ok_common(which_text_t which, char *buf);
extern void font_sel_ok_common(char *newfont);
extern void prefs_wgtopt_list_free(void);
extern void appgtk_rc_update(gpointer data);

#ifdef USE_GNOME
extern void prefs_font_sel_cb(GnomeFontPicker *gfp, char *, gpointer cbdata);
extern void prefs_text_color_cb(GtkWidget *wgt, guint r, guint g,
				guint b, guint a, gpointer cbdata);
#else
extern void prefs_font_sel_cb(GtkWidget *wgt, gpointer cbdata);
extern void prefs_text_color_cb(GtkWidget *wgt, gpointer cbdata);
#endif

#ifdef USE_SOURCE_CTRL
typedef struct scc_cmds_s {
	char *pref;	/* prefs name (e.g., "scc_ccase") */
	char *cmd;	/* the command itself */
} scc_cmds_t;

/*
 * Commonly used commands for various source code control systems.
 */
typedef struct scc_info_s {
	char *scc_desc_name;	/* desc name (e.g., "Clear Case") */
	scc_cmds_t scc_cmds[SCC_NUM_CMDS];
} scc_info_t;

extern scc_info_t scc_tbl[SCC_NUM_TYPES];
#endif	/* USE_SOURCE_CTRL */

extern char *		appgtkrc;
extern GtkWidget *	prefs_win;
#ifdef GTK_HAVE_FEATURES_1_1_0
extern GtkWidget *	prefs_txt;	/* preferences text window */
extern void		fonts_colors_sens_cb(GtkWidget *, gpointer cbdata);
#endif



#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __PREFS_PRIVATE_H__ */
