/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __galeon_h
#define __galeon_h

#ifdef __cplusplus
extern "C" {
#endif

/**
 * Configuration includes
 */	
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/**
 * Create a version int from components
 */
#define VERSION4(a,b,c,d) ((a << 24) + (b << 16) + (c << 8) + d)
#define VERSION3(a,b,c) VERSION4(a,b,c,0)
#define VERSION2(a,b) VERSION3(a,b,0)

/**
 * Split version int into components
 */
#define VERSIONA(v) (v >> 24)
#define VERSIONB(v) ((v >> 16) & 0xFF)
#define VERSIONC(v) ((v >> 8) & 0xFF)
#define VERSIOND(v) (v  & 0xFF)
#define VERSIONPLUS(v) (VERSIOND(v) ? "+" : "")

/**
 * Convenience macros for printing versions
 */
#define VERSIONFMT "%i.%i.%i%s"
#define VERSIONFMTARGS(ver) VERSIONA(ver), VERSIONB(ver), VERSIONC(ver), VERSIONPLUS(ver)

/**
 * Runtime detected mozilla version
 */
extern int mozilla_version; 

/**
 * Galeon global includes 
 */
#include "galeon_types.h"

/*
 * Configuration strings and their defaults... 
 */
#define CONF_GENERAL_HOMEPAGE         "/galeon/General/startpage=www.gnome.org"
#define CONF_GENERAL_HOMEPAGE_TYPE    "/galeon/General/startpage_type=0"
#define CONF_GENERAL_FIRSTPAGE_TYPE   "/galeon/General/firstpage_type=0"
#define CONF_GENERAL_NEWPAGE_TYPE     "/galeon/General/newpage_type=0"
#define CONF_GENERAL_BOOKMARK_TITLE   "/galeon/General/bookmark_title=0"
#define CONF_GENERAL_LINKS_AUTOSHOW   "/galeon/General/links_autoshow=1"
#define CONF_GENERAL_AUTOSHOW_TIME    "/galeon/General/autoshow_time=2"
#define CONF_GENERAL_ALLOW_POPUPS     "/galeon/General/allow_popups=TRUE"
#define CONF_GENERAL_FAVICONS_ENABLED "/galeon/General/favicons_enabled=TRUE" 
#define CONF_GENERAL_SHOW_SPINNER     "/galeon/General/show_spinner=TRUE"

#define CONF_COMPLETION_AUTOCOMP_ENABLE \
                                      "/galeon/completion/autocompletion=TRUE"
#define CONF_COMPLETION_SORT          "/galeon/completion/sorting_type=0"
	
#define CONF_APPEARANCE_URL_LOCATION  "/galeon/Appearance/url_location=1"
#define CONF_APPEARANCE_WINWIDTH      "/galeon/Appearance/winwidth=640"
#define CONF_APPEARANCE_WINHEIGHT     "/galeon/Appearance/winheight=575"
#define CONF_APPEARANCE_WINDOWS_TITLE "/galeon/Appearance/windows_title=%s - Galeon"
#define CONF_APPEARANCE_USE_OWN_COLORS \
                                      "/galeon/Appearance/use_own_colors=FALSE"
#define CONF_APPEARANCE_USE_OWN_FONTS \
                                      "/galeon/Appearance/use_own_fonts=FALSE"
#define CONF_APPEARANCE_TABBED        "/galeon/Appearance/tabbed=FALSE"
#define CONF_APPEARANCE_TABBED_POPUPS "/galeon/Appearance/tabbed_popups=FALSE"
#define CONF_APPEARANCE_TABBED_AUTOJUMP \
                                      "/galeon/Appearance/tabbed_autojump=FALSE"
#define CONF_APPEARANCE_TABBED_INSERT_NEW_TABS \
                                      "/galeon/Appearance/tabbed_insert_new_tabs=FALSE"
#define CONF_APPEARANCE_TABBED_POSITION \
                                      "/galeon/Appearance/tabbed_position=2"
#define CONF_APPEARANCE_TABBED_ALWAYS_SHOW \
                                      "/galeon/Appearance/tabbed_always_show=FALSE"
#define CONF_APPEARANCE_TABBED_CLOSEBUTTON \
                                      "/galeon/Appearance/tabbed_closebutton=TRUE"
#define CONF_APPEARANCE_TABBED_PREFIX "/galeon/Appearance/tabbed_prefix=TRUE"
#define CONF_APPEARANCE_TABBED_SEPARATOR \
	                              "/galeon/Appearance/tabbed_separator=TRUE"
#define CONF_APPEARANCE_TABBED_VOWEL  "/galeon/Appearance/tabbed_vowel=FALSE"
#define CONF_APPEARANCE_NAUTILUS_ICONS \
                                      "/galeon/Appearance/nautilus_icons=FALSE"
#define CONF_APPEARANCE_TABBED_SHORTEN_STYLE \
                                      "/galeon/Appearance/tabbed_shorten_style=0"
#define CONF_APPEARANCE_TABBED_SHORTEN_CHARS \
                                      "/galeon/Appearance/tabbed_shorten=30"
#define CONF_APPEARANCE_TABBED_SHORTEN_POINTS \
                                      "/galeon/Appearance/tabbed_shorten_points=80"
#define CONF_MIME                     "/galeon/mime/"
#define CONF_HANDLERS_MIME_ENABLE     "/galeon/handlers/mime_enable=FALSE"
#define CONF_ADVANCED_IMAGE_LOADING_TYPE \
                                      "/galeon/Advanced/image_loading_type=0"
#define CONF_ADVANCED_ANIMATE_TYPE    "/galeon/Advanced/animate_type=0"
#define CONF_ADVANCED_STATUSBAR_REWRITE \
	                              "/galeon/Advanced/statusbar_rewrite=TRUE"
#define CONF_HANDLERS_USE_EXTERNAL_SOURCE_VIEWER \
                                       "/galeon/Handlers/use_external_source_viewer=FALSE"
#define CONF_HANDLERS_EXTERNAL_SOURCE_VIEWER \
                                       "/galeon/Handlers/external_source_viewer=gnome-edit"
#define CONF_HANDLER_VIEW_SOURCE_COLORS \
				       "/galeon/Handlers/enable_syntax_highlighting"
#define CONF_DOWNLOADING_FTP_PROGRAM "/galeon/Downloading/ftp_program=0" /* use gtm */
#define CONF_DOWNLOADING_FTP_COMMAND "/galeon/Downloading/ftp_command=darxget %s"
#define CONF_ADVANCED_JAVASCRIPT_ENABLED \
                                        "/galeon/Advanced/javascript_enabled=1"
#define CONF_ADVANCED_JAVA_ENABLED      "/galeon/Advanced/java_enabled=1" 
#define CONF_ADVANCED_PROXY_ENABLED     "/galeon/Advanced/proxy_enabled=FALSE"
#define CONF_AUTOBOOKMARKS_ENABLED      "/galeon/AutoBookmarks/enabled=TRUE" 
#define CONF_AUTOBOOKMARKS_COUNT        "/galeon/AutoBookmarks/count=15" 
#define CONF_AUTOBOOKMARKS_SHORTEN      "/galeon/AutoBookmarks/shorten=25" 
#define CONF_ADVANCED_COOKIES_BEHAVIOR  "/galeon/Advanced/cookie_behavior=0"
#define CONF_ADVANCED_CRASH_BEHAVIOUR   "/galeon/Advanced/crash_behaviour=0"
#define CONF_DIR_OPEN                   "/galeon/Directories/open=~/"
#define CONF_MOUSE_LINKS_DRAG           "/galeon/Mouse/links_drag=FALSE"
#define CONF_HISTORY_EXPIRE             "/galeon/History/expire=100"
#define CONF_HISTORY_SORT_ORDER         "/galeon/History/sort_order=0"
#define CONF_HISTORY_SORT_COLUMN        "/galeon/History/sort_column=2"
#define CONF_HISTORY_SEARCH_TEXT        "/galeon/History/search_text="
#define CONF_HISTORY_SEARCH_TIME        "/galeon/History/search_time=0"
#define CONF_HISTORY_HOST_GROUP         "/galeon/History/host_group=1"
#define CONF_STATE_BOOKMARKS_DOCK_WIDTH "/galeon/State/bookmarks_dock_width=-1"
#define CONF_STATE_HISTORY_DOCK_WIDTH   "/galeon/State/history_dock_width=-1"

/* the virtual URL of "My Portal" feature */
#define MYPORTAL_URL       "about:myportal"
	
/* bookmark file locations - relative to home dir */
#define NETSCAPE_BOOKMARKS "/.netscape/bookmarks.html"
#define MOZILLA_PREFS_DIR  "/.mozilla/"
	
/**
 * Globals: FIXME!
 */

/* Has xpcom been initialised? */
extern gboolean pushed_startup;

/* types of drag and drop for links */
extern const gint url_drag_types_num_items;
extern const gint drop_types_num_items;

/** the global list of MimeItems */
extern GList *mime_types; /* FIXME: can this be made local?  MattA */
			  /* No: philipl :-) */

/** The root of the bookmarks tree */
extern BookmarkItem *bookmarks_root;

/** The root of the temporary bookmark tree */
extern BookmarkItem *default_bookmarks_root;

/** The AutoBookmarks folder */
extern BookmarkItem *autobookmarks_root;

/** Do we need to save the bookmarks */
extern gboolean bookmarks_dirty;

/** The bookmarks editors list */
extern GList *bookmarks_editors;

/** The global list of all GaleonWindow structures */
extern GList *all_windows;

/** The global list of all GaleonEmbed structures */
extern GList *all_embeds;

/** Styles for coloured text */
extern GtkStyle *red_text_style;
extern GtkStyle *yellow_text_style;
extern GtkStyle *green_text_style;
extern GtkStyle *blue_text_style;

/* global character set hash and sorted title list*/
extern GHashTable *charsets;
extern GList *sorted_charset_titles;

/* are we in server mode? */
extern gboolean galeon_server_mode;

/* last save image directory */
extern gchar *save_dir;

/**
 * The standard pixmaps for bookmarks / sites
 */
extern PixmapData *folder_pixmap_data;
extern PixmapData *folder_open_pixmap_data;
extern PixmapData *site_pixmap_data;

#define DEFAULT_CHROME GTK_MOZ_EMBED_FLAG_ALLCHROME

extern const gint bookmarks_dnd_targets_num_items;

/*
 * Miscellaneous function prototypes. Most large modules have a header
 * of their own.
 */

/* netscape.c */
gint netscape_import_bookmarks (GString *filename);
gint netscape_export_bookmarks (gchar *filename, BookmarkItem *root);
gboolean netscape_import_prefs (void);

/* xbel */
gboolean xbel_export_bookmarks (const gchar *filename, BookmarkItem *root);

/* gtm.c */
gboolean gtm_add_url (const gchar *url, gchar *dir, gboolean disable_proxy,
		      gboolean disable_auto_dl);

/* portal.c */
void portal_render_into_embed (GaleonEmbed *embed);

/* mozilla_prefs.c */
void mozilla_prefs_import_language (void);

/* autobookmarks.c */
void autobookmarks_generate (void);

/* cookies.c */
GtkWidget *cookies_show_manager (void);
GtkWidget *cookies_show_page (const CookiePage page);

/* menu_callbacks.c */
void window_menu_encoding_activate_cb (GtkWidget *menuitem,
				       GaleonWindow *window);
void window_menu_bookmark_activate_cb  (GtkWidget *menuitem, 
					gpointer user_data);

/* newuser.c */
gboolean newuser_check(void);

/* panel.c */
void panel_main (void);

#ifdef __cplusplus
}
#endif

#endif /* __galeon_h */
