#!/bin/sh

# libmove sourcelib targetlib
#
# This allows you to move a new shared library into place,
# even on a running system.
libmove() {
  LIBSOURCE=$1
  LIBTARGET=$2
  LIBFOO="`dirname $LIBTARGET`/libfoo.so.0.0.0"
  # link duplicate of target lib so we can safely copy over it:
  if [ -r $LIBTARGET ]; then
    cp -a $LIBTARGET $LIBFOO
    if [ -x /sbin/ldconfig ]; then
      ldconfig -l $LIBFOO
    fi
  fi
  mv $LIBSOURCE $LIBTARGET
  if [ -x /sbin/ldconfig ]; then
    ldconfig -l $LIBTARGET
  fi
  rm -f $LIBFOO
}

( cd lib/incoming
  for file in * ; do
    libmove $file ../$file
  done )
#### Now, get rid of the temporary directory:
rm -rf lib/incoming

( cd usr/lib ; rm -rf libdb2.so )
( cd usr/lib ; ln -sf ../../lib/libdb2.so.3 libdb2.so )
( cd usr/lib ; rm -rf libndbm.so )
( cd usr/lib ; ln -sf ../../lib/libdb2.so.3 libndbm.so )
( cd usr/lib ; rm -rf libndbm.a )
( cd usr/lib ; ln -sf libdb2.a libndbm.a )
