# Invite the new admin to register their machine with the Linux Counter:
if [ ! -f var/spool/mail/root ]; then
 mv var/spool/mail/root.new var/spool/mail/root
else
 cat var/spool/mail/root.new >> var/spool/mail/root
 rm var/spool/mail/root.new
fi
# These links have historically been part of the Linux libc package, but they
# aren't created by glibc2.  We'll make sure they're made here rather than
# add them to the glibc2 package:
( cd usr/include ; rm -rf linux )
( cd usr/include ; ln -sf /usr/src/linux/include/linux linux )
( cd usr/include ; rm -rf asm )
( cd usr/include ; ln -sf /usr/src/linux/include/asm asm )
###########################################################################
# A_M_X_B: A Magic X11 Bullet, by volkerdi@slackware.com
#
# The purpose of this addition is to transform the directory structure of the
# X11R6 installation on a Slackware Linux machine from the old structure to
# the new structure.  The old structure uses a directory /var/X11R6/lib to
# replace /usr/X11R6/lib/X11.  The new structure puts most of this stuff in
# /etc/X11.  Under the old structure, /etc/X11 is a symlink.  Anyway, the
# purpose of this "grand reorganization" is to fall in line with the way
# XFree86 installs itself by default on Linux systems, as the default layout
# is now Linux FHS compliant.
# If etc/X11 is a link, make it a directory:
if [ -L etc/X11 ]; then
  rm -f etc/X11
fi
mkdir -p etc/X11
chmod 755 etc/X11
# If usr/X11R6/lib/X11 is a symlink, fix that:
if [ -L usr/X11R6/lib/X11 ]; then
  rm -f usr/X11R6/lib/X11
fi
mkdir -p usr/X11R6/lib/X11
chmod 755 usr/X11R6/lib/X11
# If var/X11R6/lib is a directory, make it a symlink:
if [ ! -L var/X11R6/lib ]; then
  # If there's stuff in here, move it:
  if [ -d var/X11R6/lib ]; then
    cp -a var/X11R6/lib/* usr/X11R6/lib/X11
  fi
  rm -rf var/X11R6/lib
  ln -sf ../../usr/X11R6/lib/X11 var/X11R6/lib
fi
# OK, now it's time to move some of the subdirectories in /usr/X11R6/lib/X11:
for dir in app-defaults fs lbxproxy proxymngr rstart twm xdm xinit xkb xserver xsm ; do
  mkdir -p etc/X11/$dir
  chmod 755 etc/X11/$dir
  if [ ! -L usr/X11R6/lib/X11/$dir ]; then
    if [ -d usr/X11R6/lib/X11/$dir ]; then
      cp -a usr/X11R6/lib/X11/$dir etc/X11
    fi
    rm -rf usr/X11R6/lib/X11/$dir
    # Don't ask me why there's this '/./' in there... that's how XFree86 does it.
    ln -sf ../../../.././etc/X11/$dir usr/X11R6/lib/X11/$dir
  fi
done 
# This will save you down the road:
if [ -r var/log/scripts/xbin ]; then
  if fgrep "( cd usr/X11R6/lib ; rm -rf X11 )" var/log/scripts/xbin 1> /dev/null ; then
    cat var/log/scripts/xbin | grep -v "( cd usr/X11R6/lib ; rm -rf X11 )" \
      | grep -v "( cd usr/X11R6/lib ; ln -sf  /var/X11R6/lib X11 )" \
      | grep -v "( cd var/X11R6/lib ; rm -rf fonts )" \
      | grep -v "( cd var/X11R6/lib ; ln -sf  /usr/X11R6/lib/fonts fonts )" \
      | grep -v "( cd etc ; rm -rf X11 )" \
      | grep -v "( cd etc ; ln -sf  /var/X11R6/lib X11 )" > var/log/scripts/xbin-new
    mv var/log/scripts/xbin-new var/log/scripts/xbin
  fi
fi
# If the fonts directory is still in the old location, copy it:
if [ ! -L usr/X11R6/lib/fonts ]; then
  if [ -d usr/X11R6/lib/fonts ]; then
    if [ -L usr/X11R6/lib/X11/fonts ]; then
      rm -f usr/X11R6/lib/X11/fonts
    fi
    mkdir -p usr/X11R6/lib/X11/fonts
    chmod 755 usr/X11R6/lib/X11/fonts
    cp -a usr/X11R6/lib/fonts/* usr/X11R6/lib/X11/fonts
  fi
fi
# Here's another evil trick I learned from the conspiracy:
if [ "true" = "false" ]; then
( cd usr/X11R6/lib ; rm -rf X11 )
( cd usr/X11R6/lib ; ln -sf /var/X11R6/lib X11 )
( cd usr/X11R6/lib/X11 ; rm -rf fonts )
( cd usr/X11R6/lib/X11 ; ln -sf ../fonts fonts )
fi
# Hope you enjoyed a_m_x_b!  I know I did.  -- Pat
##########################################################################################
# These links are used by XFree86:
( cd usr/bin ; rm -rf X11 )
( cd usr/bin ; ln -sf /usr/X11R6/bin X11 )
( cd usr/lib ; rm -rf X11 )
( cd usr/lib ; ln -sf /usr/X11R6/lib/X11 X11 )
( cd usr/include ; rm -rf X11 )
( cd usr/include ; ln -sf /usr/X11R6/include/X11 X11 )
( cd usr ; rm -rf X11 )
( cd usr ; ln -sf X11R6 X11 )
( cd var/X11R6 ; rm -rf lib )
( cd var/X11R6 ; ln -sf ../../usr/X11R6/lib/X11 lib )
( cd usr/X11R6/lib ; rm -rf fonts )
( cd usr/X11R6/lib ; ln -sf X11/fonts fonts )
# Other symlinks:
( cd usr/X11R6/man ; rm -rf cat1 )
( cd usr/X11R6/man ; ln -sf /var/man/cat1 cat1 )
( cd usr/X11R6/man ; rm -rf cat2 )
( cd usr/X11R6/man ; ln -sf /var/man/cat2 cat2 )
( cd usr/X11R6/man ; rm -rf cat3 )
( cd usr/X11R6/man ; ln -sf /var/man/cat3 cat3 )
( cd usr/X11R6/man ; rm -rf cat4 )
( cd usr/X11R6/man ; ln -sf /var/man/cat4 cat4 )
( cd usr/X11R6/man ; rm -rf cat5 )
( cd usr/X11R6/man ; ln -sf /var/man/cat5 cat5 )
( cd usr/X11R6/man ; rm -rf cat6 )
( cd usr/X11R6/man ; ln -sf /var/man/cat6 cat6 )
( cd usr/X11R6/man ; rm -rf cat7 )
( cd usr/X11R6/man ; ln -sf /var/man/cat7 cat7 )
( cd usr/X11R6/man ; rm -rf cat8 )
( cd usr/X11R6/man ; ln -sf /var/man/cat8 cat8 )
( cd usr/X11R6/man ; rm -rf cat9 )
( cd usr/X11R6/man ; ln -sf /var/man/cat9 cat9 )
( cd usr/X11R6/man ; rm -rf catn )
( cd usr/X11R6/man ; ln -sf /var/man/catn catn )
# Do that symlink thing:
( cd usr/man ; rm -rf cat1 )
( cd usr/man ; ln -sf /var/man/cat1 cat1 )
( cd usr/man ; rm -rf cat2 )
( cd usr/man ; ln -sf /var/man/cat2 cat2 )
( cd usr/man ; rm -rf cat3 )
( cd usr/man ; ln -sf /var/man/cat3 cat3 )
( cd usr/man ; rm -rf cat4 )
( cd usr/man ; ln -sf /var/man/cat4 cat4 )
( cd usr/man ; rm -rf cat5 )
( cd usr/man ; ln -sf /var/man/cat5 cat5 )
( cd usr/man ; rm -rf cat6 )
( cd usr/man ; ln -sf /var/man/cat6 cat6 )
( cd usr/man ; rm -rf cat7 )
( cd usr/man ; ln -sf /var/man/cat7 cat7 )
( cd usr/man ; rm -rf cat8 )
( cd usr/man ; ln -sf /var/man/cat8 cat8 )
( cd usr/man ; rm -rf cat9 )
( cd usr/man ; ln -sf /var/man/cat9 cat9 )
( cd usr/man ; rm -rf catn )
( cd usr/man ; ln -sf /var/man/catn catn )
( cd usr ; rm -rf adm )
( cd usr ; ln -sf /var/adm adm )
( cd usr ; rm -rf spool )
( cd usr ; ln -sf /var/spool spool )
( cd usr ; rm -rf tmp )
( cd usr ; ln -sf /var/tmp tmp )
( cd var ; rm -rf rwho )
( cd var ; ln -sf /var/spool/rwho rwho )
( cd var ; rm -rf adm )
( cd var ; ln -sf log adm )
( cd bin ; rm -rf sh )
( cd bin ; ln -sf bash sh )
( cd var ; rm -rf mail )
( cd var ; ln -sf spool/mail mail )
( cd usr/share ; rm -rf man )
( cd usr/share ; ln -sf ../man man )
( cd usr/share ; rm -rf doc )
( cd usr/share ; ln -sf ../doc doc )
