#ifndef NOATUN_H
#define NOATUN_H

#include <kapp.h>

class PlayList;
class Player;
class LibraryLoader;
class KPopupMenu;
class NoatunPreferences;
class Downloader;
class Effects;
class EffectView;
class Equalizer;
class EqualizerView;

namespace Arts { class Dispatcher; }

class NoatunApp : public KApplication
{
Q_OBJECT
friend class PlayList;
friend class KCrash;

public:
	NoatunApp();
	~NoatunApp();

	PlayList *playList() const { return playlist();}
	PlayList *playlist() const;
	Player *player() const { return mPlayer; }
	NoatunPreferences *preferencesBox() const { return mPref; }
	QString shellGlob();

	LibraryLoader *libraryLoader() const { return mLibraryLoader; }
	Downloader *downloader() const { return mDownloader; }
	static QImage readPNG(const QString &filename);
	Effects *effects() const;
	::Equalizer *equalizer() const { return mEqualizer; }
	EqualizerView *equalizerView() const { return mEqualizerView; }

	QCString version() const;

	virtual void commitData(QSessionManager &);
	virtual void saveState(QSessionManager &);
	
public: //options
	bool autoPlay() const;
	bool loopList() const;
	bool oneInstance() const;
	QString saveDirectory() const;
	bool clearOnOpen() const;
	bool hackUpPlaylist() const;

	void setOneInstance(bool);
	void setLoopList(bool);
	void setAutoPlay(bool);
	void setSaveDirectory(const QString &);
	void setRememberPositions(bool);
	void setClearOnOpen(bool);
	void setHackUpPlaylist(bool);

	// context menu for UserInterface modules to use and enjoy
	KPopupMenu *contextMenu() const;
	KPopupMenu *createContextMenu(QWidget *p);

	/**
	 * Adds an item to the plugin menu.
	 *
	 * @return the ID associated with the menu item, for use in @ref contextMenuRemove()
	 **/
	int pluginMenuAdd(const QString &text, const QObject *receiver, const char *member);

	/**
	 * Removes an item previously added to the plugin menu.
	 **/
	void pluginMenuRemove(int id);

	KPopupMenu *pluginMenu(void);
public slots:
	// slots for the contextMenu
	void preferences();
	void quit();
	void fileOpen();
	void effectView();
	void equalizerView();
	
	/**
	 * Show the context menu at point
	 **/
	void showContextMenu(const QPoint &);
	/**
	 * show the context menu at the mouse's current position
	 **/
	void showContextMenu();

private:
	static void cleverKCrashHack(int);
	void loadPlugins();

private:
	Player *mPlayer;
	LibraryLoader *mLibraryLoader;
	KPopupMenu *mContextMenu, *mPluginMenu;
	Arts::Dispatcher *mArtsDispatcher;
	Downloader *mDownloader;
	Effects *mEffects;
	EffectView *mEffectView;
	NoatunPreferences *mPref;
	::Equalizer *mEqualizer;
	EqualizerView *mEqualizerView;
};

#define napp (static_cast<NoatunApp*>(kapp))

// version info for the plugins
// this is MAJOR.MINOR.PATCHLEVEL
// and you developers better ignore patchlevel :)
#define VERSION_MAJOR 1
#define VERSION_MINOR 0
#define VERSION_PATCHLEVEL 1

#endif
