/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIURL.idl
 */

#ifndef __gen_nsIURL_h__
#define __gen_nsIURL_h__


#ifndef __gen_nsIURI_h__
#include "nsIURI.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif

/* starting interface:    nsIURL */
#define NS_IURL_IID_STR "d6116970-8034-11d3-9399-00104ba0fd40"

#define NS_IURL_IID \
  {0xd6116970, 0x8034, 0x11d3, \
    { 0x93, 0x99, 0x00, 0x10, 0x4b, 0xa0, 0xfd, 0x40 }}

/**
 * Protocol writers can obtain a very basic (ok, degenerate) implementation
 * of nsIURI by calling the component manager with NS_SIMPLEURI_CID. The
 * implementation returned will only parse things of the form:
 *
 *    about:cache
 *    \   / \   /
 *     ---   ---
 *      |     |
 *   Scheme  Path
 *
 * where the path is everything after the colon. Note that this is probably 
 * only useful for cases like about: or javascript: URIs. 
 *
 * *** What you most likely will want is NS_STANDARDURL_CID which is much more 
 * full featured. Look at nsIURL.idl for more details.
 *
 * NOTE: CIDs are declared in nsNetCID.h
 */
/**
 * The nsIURL interface provides convenience methods that further
 * break down the path portion of nsIURI:
 *
 * http://directory/fileBaseName.fileExtension?query
 * http://directory/fileBaseName.fileExtension#ref
 * http://directory/fileBaseName.fileExtension;param
 *       \          \                       /
 *        \          -----------------------
 *         \                   |          /
 *          \               fileName     /
 *           ----------------------------
 *                       |
 *                   filePath
 *
 * @status UNDER_REVIEW
 */
class NS_NO_VTABLE nsIURL : public nsIURI {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IURL_IID)

  /**
     * Returns a path including the directory and file portions of a
     * URL. E.g. The filePath of "http://foo/bar.html#baz" is
     * "/foo/bar.html". 
     */
  /* attribute string filePath; */
  NS_IMETHOD GetFilePath(char * *aFilePath) = 0;
  NS_IMETHOD SetFilePath(const char * aFilePath) = 0;

  /**
     * Returns the parameters specified after the ; in the URL. 
     *
     */
  /* attribute string param; */
  NS_IMETHOD GetParam(char * *aParam) = 0;
  NS_IMETHOD SetParam(const char * aParam) = 0;

  /**
     * Returns the query portion (the part after the "?") of the URL.
     * If there isn't one, an empty string is returned.
     */
  /* attribute string query; */
  NS_IMETHOD GetQuery(char * *aQuery) = 0;
  NS_IMETHOD SetQuery(const char * aQuery) = 0;

  /**
     * Returns the reference portion (the part after the "#") of the URL.
     * If there isn't one, an empty string is returned.
     */
  /* attribute string ref; */
  NS_IMETHOD GetRef(char * *aRef) = 0;
  NS_IMETHOD SetRef(const char * aRef) = 0;

  /**
     * Returns the directory portion of a URL. 
     * If the URL denotes a path to a directory and not a file,
     * e.g. http://foo/bar/, then the Directory attribute accesses
     * the complete /foo/bar/ portion, and the FileName is the 
     * empty string. If the trailing slash is omitted, then the
     * Directory is /foo/ and the file is bar (i.e. this is a 
     * syntactic, not a semantic breakdown of the Path).
     * And hence dont rely on this for something to be a definitely 
     * be a file. But you can get just the leading directory portion 
     * for sure.
     */
  /* attribute string directory; */
  NS_IMETHOD GetDirectory(char * *aDirectory) = 0;
  NS_IMETHOD SetDirectory(const char * aDirectory) = 0;

  /**
     * Returns the file name portion of a URL.
     * If the URL denotes a path to a directory and not a file,
     * e.g. http://foo/bar/, then the Directory attribute accesses
     * the complete /foo/bar/ portion, and the FileName is the 
     * empty string. Note that this is purely based on searching 
     * for the last trailing slash. And hence dont rely on this to 
     * be a definite file. 
     */
  /* attribute string fileName; */
  NS_IMETHOD GetFileName(char * *aFileName) = 0;
  NS_IMETHOD SetFileName(const char * aFileName) = 0;

  /* attribute string fileBaseName; */
  NS_IMETHOD GetFileBaseName(char * *aFileBaseName) = 0;
  NS_IMETHOD SetFileBaseName(const char * aFileBaseName) = 0;

  /**
     * Returns the file extension portion of a filename in a url.
     * If a file extension does not exist, the empty string is returned.
     */
  /* attribute string fileExtension; */
  NS_IMETHOD GetFileExtension(char * *aFileExtension) = 0;
  NS_IMETHOD SetFileExtension(const char * aFileExtension) = 0;

  /**
     * Returns the query portion (the part after the "?") of the URL
     * without unescaping the string.
     * If there isn't one, an empty string is returned.
     */
  /* readonly attribute string escapedQuery; */
  NS_IMETHOD GetEscapedQuery(char * *aEscapedQuery) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIURL \
  NS_IMETHOD GetFilePath(char * *aFilePath); \
  NS_IMETHOD SetFilePath(const char * aFilePath); \
  NS_IMETHOD GetParam(char * *aParam); \
  NS_IMETHOD SetParam(const char * aParam); \
  NS_IMETHOD GetQuery(char * *aQuery); \
  NS_IMETHOD SetQuery(const char * aQuery); \
  NS_IMETHOD GetRef(char * *aRef); \
  NS_IMETHOD SetRef(const char * aRef); \
  NS_IMETHOD GetDirectory(char * *aDirectory); \
  NS_IMETHOD SetDirectory(const char * aDirectory); \
  NS_IMETHOD GetFileName(char * *aFileName); \
  NS_IMETHOD SetFileName(const char * aFileName); \
  NS_IMETHOD GetFileBaseName(char * *aFileBaseName); \
  NS_IMETHOD SetFileBaseName(const char * aFileBaseName); \
  NS_IMETHOD GetFileExtension(char * *aFileExtension); \
  NS_IMETHOD SetFileExtension(const char * aFileExtension); \
  NS_IMETHOD GetEscapedQuery(char * *aEscapedQuery); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIURL(_to) \
  NS_IMETHOD GetFilePath(char * *aFilePath) { return _to ## GetFilePath(aFilePath); } \
  NS_IMETHOD SetFilePath(const char * aFilePath) { return _to ## SetFilePath(aFilePath); } \
  NS_IMETHOD GetParam(char * *aParam) { return _to ## GetParam(aParam); } \
  NS_IMETHOD SetParam(const char * aParam) { return _to ## SetParam(aParam); } \
  NS_IMETHOD GetQuery(char * *aQuery) { return _to ## GetQuery(aQuery); } \
  NS_IMETHOD SetQuery(const char * aQuery) { return _to ## SetQuery(aQuery); } \
  NS_IMETHOD GetRef(char * *aRef) { return _to ## GetRef(aRef); } \
  NS_IMETHOD SetRef(const char * aRef) { return _to ## SetRef(aRef); } \
  NS_IMETHOD GetDirectory(char * *aDirectory) { return _to ## GetDirectory(aDirectory); } \
  NS_IMETHOD SetDirectory(const char * aDirectory) { return _to ## SetDirectory(aDirectory); } \
  NS_IMETHOD GetFileName(char * *aFileName) { return _to ## GetFileName(aFileName); } \
  NS_IMETHOD SetFileName(const char * aFileName) { return _to ## SetFileName(aFileName); } \
  NS_IMETHOD GetFileBaseName(char * *aFileBaseName) { return _to ## GetFileBaseName(aFileBaseName); } \
  NS_IMETHOD SetFileBaseName(const char * aFileBaseName) { return _to ## SetFileBaseName(aFileBaseName); } \
  NS_IMETHOD GetFileExtension(char * *aFileExtension) { return _to ## GetFileExtension(aFileExtension); } \
  NS_IMETHOD SetFileExtension(const char * aFileExtension) { return _to ## SetFileExtension(aFileExtension); } \
  NS_IMETHOD GetEscapedQuery(char * *aEscapedQuery) { return _to ## GetEscapedQuery(aEscapedQuery); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIURL(_to) \
  NS_IMETHOD GetFilePath(char * *aFilePath) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetFilePath(aFilePath); } \
  NS_IMETHOD SetFilePath(const char * aFilePath) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetFilePath(aFilePath); } \
  NS_IMETHOD GetParam(char * *aParam) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetParam(aParam); } \
  NS_IMETHOD SetParam(const char * aParam) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetParam(aParam); } \
  NS_IMETHOD GetQuery(char * *aQuery) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetQuery(aQuery); } \
  NS_IMETHOD SetQuery(const char * aQuery) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetQuery(aQuery); } \
  NS_IMETHOD GetRef(char * *aRef) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetRef(aRef); } \
  NS_IMETHOD SetRef(const char * aRef) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetRef(aRef); } \
  NS_IMETHOD GetDirectory(char * *aDirectory) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetDirectory(aDirectory); } \
  NS_IMETHOD SetDirectory(const char * aDirectory) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetDirectory(aDirectory); } \
  NS_IMETHOD GetFileName(char * *aFileName) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetFileName(aFileName); } \
  NS_IMETHOD SetFileName(const char * aFileName) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetFileName(aFileName); } \
  NS_IMETHOD GetFileBaseName(char * *aFileBaseName) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetFileBaseName(aFileBaseName); } \
  NS_IMETHOD SetFileBaseName(const char * aFileBaseName) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetFileBaseName(aFileBaseName); } \
  NS_IMETHOD GetFileExtension(char * *aFileExtension) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetFileExtension(aFileExtension); } \
  NS_IMETHOD SetFileExtension(const char * aFileExtension) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->SetFileExtension(aFileExtension); } \
  NS_IMETHOD GetEscapedQuery(char * *aEscapedQuery) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##->GetEscapedQuery(aEscapedQuery); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsURL : public nsIURL
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIURL

  nsURL();
  virtual ~nsURL();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsURL, nsIURL)

nsURL::nsURL()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsURL::~nsURL()
{
  /* destructor code */
}

/* attribute string filePath; */
NS_IMETHODIMP nsURL::GetFilePath(char * *aFilePath)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsURL::SetFilePath(const char * aFilePath)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string param; */
NS_IMETHODIMP nsURL::GetParam(char * *aParam)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsURL::SetParam(const char * aParam)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string query; */
NS_IMETHODIMP nsURL::GetQuery(char * *aQuery)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsURL::SetQuery(const char * aQuery)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string ref; */
NS_IMETHODIMP nsURL::GetRef(char * *aRef)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsURL::SetRef(const char * aRef)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string directory; */
NS_IMETHODIMP nsURL::GetDirectory(char * *aDirectory)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsURL::SetDirectory(const char * aDirectory)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string fileName; */
NS_IMETHODIMP nsURL::GetFileName(char * *aFileName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsURL::SetFileName(const char * aFileName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string fileBaseName; */
NS_IMETHODIMP nsURL::GetFileBaseName(char * *aFileBaseName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsURL::SetFileBaseName(const char * aFileBaseName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string fileExtension; */
NS_IMETHODIMP nsURL::GetFileExtension(char * *aFileExtension)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsURL::SetFileExtension(const char * aFileExtension)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute string escapedQuery; */
NS_IMETHODIMP nsURL::GetEscapedQuery(char * *aEscapedQuery)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsIStandardURL */
#define NS_ISTANDARDURL_IID_STR "8793370a-311f-11d4-9876-00c04fa0cf4a"

#define NS_ISTANDARDURL_IID \
  {0x8793370a, 0x311f, 0x11d4, \
    { 0x98, 0x76, 0x00, 0xc0, 0x4f, 0xa0, 0xcf, 0x4a }}

/**
 * Protocol writers can obtain a default nsIURL implementation by calling the
 * component manager with NS_STANDARDURL_CID. The implementation returned will 
 * only implement the set of accessors specified by nsIURL. After obtaining the
 * instance from the component manager, the Init routine must be called on it
 * to initialize it from the user's URL spec. 
 */
class NS_NO_VTABLE nsIStandardURL : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_ISTANDARDURL_IID)

  enum { URLTYPE_STANDARD = 1U };

  enum { URLTYPE_AUTHORITY = 2U };

  enum { URLTYPE_NO_AUTHORITY = 3U };

  /* void init (in unsigned long urlType, in long defaultPort, in string initialSpec, in nsIURI initialBaseURI); */
  NS_IMETHOD Init(PRUint32 urlType, PRInt32 defaultPort, const char *initialSpec, nsIURI *initialBaseURI) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSISTANDARDURL \
  NS_IMETHOD Init(PRUint32 urlType, PRInt32 defaultPort, const char *initialSpec, nsIURI *initialBaseURI); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSISTANDARDURL(_to) \
  NS_IMETHOD Init(PRUint32 urlType, PRInt32 defaultPort, const char *initialSpec, nsIURI *initialBaseURI) { return _to ## Init(urlType, defaultPort, initialSpec, initialBaseURI); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSISTANDARDURL(_to) \
  NS_IMETHOD Init(PRUint32 urlType, PRInt32 defaultPort, const char *initialSpec, nsIURI *initialBaseURI) { return !_to ## ? NS_ERROR_NULL_POINTER : _to ##-> Init(urlType, defaultPort, initialSpec, initialBaseURI); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsStandardURL : public nsIStandardURL
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSISTANDARDURL

  nsStandardURL();
  virtual ~nsStandardURL();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsStandardURL, nsIStandardURL)

nsStandardURL::nsStandardURL()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsStandardURL::~nsStandardURL()
{
  /* destructor code */
}

/* void init (in unsigned long urlType, in long defaultPort, in string initialSpec, in nsIURI initialBaseURI); */
NS_IMETHODIMP nsStandardURL::Init(PRUint32 urlType, PRInt32 defaultPort, const char *initialSpec, nsIURI *initialBaseURI)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIURL_h__ */
