#! /bin/sh
#
# Install.man  for  man-pages-ja-0.4  1998-11-30
#

remove_old()
{
	for i in $1 $1.gz $1.z $1.bz2 $1.Z
	do
		if [ -f $i -o -L $i ]; then
			rm -f $i || exit 1
		fi
	done
}

setup_man()
{
	chown $2 $1
	chgrp $3 $1
	chmod $4 $1
	if [ $5 -eq 0 -a "$6" = "y" ]; then
		[ "$VERBOSE" = "y" ] && echo -n "gzip.. "
		gzip --fast --name $1
	elif [ "$7" = "y" ]; then	
		[ "$VERBOSE" = "y" ] && echo -n "bzip2.. "
		bzip2 -9 $1
	elif [ "$8" = "y" ]; then	
		[ "$VERBOSE" = "y" ] && echo -n "compress.. "
		compress $1
	fi
}

###  read config options  ###################
. ./config.man

###  check libc version #####################
if [ -f /lib/libc.so.6 ]; then
	LIBC=glibc2
else
	LIBC=libc5
fi

###  man-page name  #########################
NAME=`basename $1`
[ "$VERBOSE" = "y" ] && echo -n "$NAME :	"

###  man-page section  ######################
SEC=`dirname $1 | sed s/man//`

###  check so link ##########################
#SOLINK=`grep -c "^.so " $1`
SOLINK=0

#
# Source Man-Page
#
if [ "$JMAN" = "y" ]; then
	DIR=$JMANDIR/man$SEC
	MAN=$DIR/$NAME

###  make directory #########################
	[ -d $DIR ] || mkdir -p $DIR || exit 1

###  remove old man-pages  ##################
	remove_old $MAN

###  install source man-pages  ##############
	[ "$VERBOSE" = "y" ] && echo -n "copy.. "
	cp $1 $MAN || exit 1
	setup_man $MAN $JMANOWN $JMANGRP $JMANPERM $SOLINK $MANGZIP $MANBZIP2 $MANCOMP
fi


#
# Formatted Man-Page
#
if [ "$JCAT" = "y" ]; then
	DIR=$JCATDIR/cat$SEC
	CAT=$DIR/$NAME
	GROFF_TMAC_PATH=/usr/share/groff/tmac:./man-ja/tmac
	export GROFF_TMAC_PATH

###  make directory #########################
	[ -d $DIR ] || mkdir -p $DIR || exit 1

###  remove old man-pages  ##################
	remove_old $CAT

###  install formatted man-pages  ###########
	[ "$VERBOSE" = "y" ] && echo -n "format .... "
	./man-ja/$LIBC/man -P /bin/cat -C ./script/man.jconf $1 > $CAT || exit 1
	setup_man $CAT $JCATOWN $JCATGRP $JCATPERM $SOLINK $CATGZIP $CATBZIP2 $CATCOMP
fi

#
# done.
#
[ "$VERBOSE" = "y" ] && echo "done. "
exit 0
