/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.PrintStream;
import sun.misc.REException;
import sun.misc.RegexpNode;
import sun.misc.RegexpTarget;

public class RegexpPool {
    private RegexpNode prefixMachine = new RegexpNode();
    private RegexpNode suffixMachine = new RegexpNode();
    private static final int BIG = Integer.MAX_VALUE;
    private int lastDepth = Integer.MAX_VALUE;

    public void add(String string, Object object) throws REException {
        this.add(string, object, false);
    }

    public void replace(String string, Object object) {
        try {
            this.add(string, object, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object delete(String string) {
        RegexpNode regexpNode;
        Object object = null;
        RegexpNode regexpNode2 = regexpNode = this.prefixMachine;
        int n = string.length() - 1;
        boolean bl = true;
        if (!string.startsWith("*") || !string.endsWith("*")) {
            ++n;
        }
        if (n <= 0) {
            return null;
        }
        int n2 = 0;
        while (regexpNode != null) {
            if (!(regexpNode.result == null || regexpNode.depth >= Integer.MAX_VALUE || regexpNode.exact && n2 != n)) {
                regexpNode2 = regexpNode;
            }
            if (n2 >= n) break;
            regexpNode = regexpNode.find(string.charAt(n2));
            ++n2;
        }
        regexpNode = this.suffixMachine;
        n2 = n;
        while (--n2 >= 0 && regexpNode != null) {
            if (regexpNode.result != null && regexpNode.depth < Integer.MAX_VALUE) {
                bl = false;
                regexpNode2 = regexpNode;
            }
            regexpNode = regexpNode.find(string.charAt(n2));
        }
        if (bl) {
            if (string.equals(regexpNode2.re)) {
                RegexpPool.p("Deleting " + regexpNode2.re);
                object = regexpNode2.result;
                regexpNode2.result = null;
            }
        } else if (string.equals(regexpNode2.re)) {
            object = regexpNode2.result;
            regexpNode2.result = null;
        }
        return object;
    }

    public Object match(String string) {
        return this.matchAfter(string, Integer.MAX_VALUE);
    }

    public Object matchNext(String string) {
        return this.matchAfter(string, this.lastDepth);
    }

    private void add(String string, Object object, boolean bl) throws REException {
        RegexpNode regexpNode;
        int n = string.length();
        if (string.charAt(0) == '*') {
            regexpNode = this.suffixMachine;
            while (n > 1) {
                regexpNode = regexpNode.add(string.charAt(--n));
            }
        } else {
            boolean bl2 = false;
            if (string.charAt(n - 1) == '*') {
                --n;
            } else {
                bl2 = true;
            }
            regexpNode = this.prefixMachine;
            int n2 = 0;
            while (n2 < n) {
                regexpNode = regexpNode.add(string.charAt(n2));
                ++n2;
            }
            regexpNode.exact = bl2;
        }
        if (regexpNode.result != null && !bl) {
            throw new REException(string + " is a duplicate");
        }
        regexpNode.re = string;
        regexpNode.result = object;
    }

    private Object matchAfter(String string, int n) {
        RegexpNode regexpNode;
        RegexpNode regexpNode2 = regexpNode = this.prefixMachine;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        if (n4 <= 0) {
            return null;
        }
        int n5 = 0;
        while (regexpNode != null) {
            if (!(regexpNode.result == null || regexpNode.depth >= n || regexpNode.exact && n5 != n4)) {
                this.lastDepth = regexpNode.depth;
                regexpNode2 = regexpNode;
                n2 = n5;
                n3 = n4;
            }
            if (n5 >= n4) break;
            regexpNode = regexpNode.find(string.charAt(n5));
            ++n5;
        }
        regexpNode = this.suffixMachine;
        n5 = n4;
        while (--n5 >= 0 && regexpNode != null) {
            if (regexpNode.result != null && regexpNode.depth < n) {
                this.lastDepth = regexpNode.depth;
                regexpNode2 = regexpNode;
                n2 = 0;
                n3 = n5 + 1;
            }
            regexpNode = regexpNode.find(string.charAt(n5));
        }
        Object object = regexpNode2.result;
        if (object != null && object instanceof RegexpTarget) {
            object = ((RegexpTarget)object).found(string.substring(n2, n3));
        }
        return object;
    }

    public void reset() {
        this.lastDepth = Integer.MAX_VALUE;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 5) {
            RegexpPool.p("need 5 params");
            System.exit(1);
        }
        RegexpPool regexpPool = new RegexpPool();
        try {
            int n = 1;
            while (n < stringArray.length) {
                regexpPool.add(stringArray[n], stringArray[n]);
                ++n;
            }
            RegexpPool.p("Trying to delete " + stringArray[3]);
            regexpPool.delete(stringArray[3]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        RegexpPool.p((String)regexpPool.match(stringArray[0]));
    }

    public void print(PrintStream printStream) {
        printStream.print("Regexp pool:\n");
        if (this.suffixMachine.firstchild != null) {
            printStream.print(" Suffix machine: ");
            this.suffixMachine.firstchild.print(printStream);
            printStream.print("\n");
        }
        if (this.prefixMachine.firstchild != null) {
            printStream.print(" Prefix machine: ");
            this.prefixMachine.firstchild.print(printStream);
            printStream.print("\n");
        }
    }

    private static void p(String string) {
    }
}

