/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.InvocationEvent;
import sun.awt.GlobalCursorManager;
import sun.awt.SunToolkit;

public abstract class GlobalCursorManager {
    private static GlobalCursorManager manager;
    private static final CursorEvent curEvent;
    private static long lastUpdateMillis;
    private static final Object lastUpdateLock;
    private static final Object treeLock;

    public static void updateCursorImmediately() {
        CursorEvent cursorEvent = curEvent;
        synchronized (cursorEvent) {
            CursorEvent.pending = false;
        }
        GlobalCursorManager.getInstance()._updateCursor(false);
    }

    public static void updateCursorImmediately(InputEvent inputEvent) {
        boolean bl;
        Object object = lastUpdateLock;
        synchronized (object) {
            bl = inputEvent.getWhen() >= lastUpdateMillis;
        }
        if (bl) {
            GlobalCursorManager.getInstance()._updateCursor(true);
        }
    }

    public static void updateCursorLater(Component component) {
        curEvent.postSelfIfNotPending(component);
    }

    private static GlobalCursorManager getInstance() {
        if (manager == null) {
            manager = ((SunToolkit)Toolkit.getDefaultToolkit()).getGlobalCursorManager();
        }
        return manager;
    }

    protected GlobalCursorManager() {
    }

    protected abstract void setCursor(Component var1, Cursor var2, boolean var3);

    protected abstract void getCursorPos(Point var1);

    protected abstract Component findComponentAt(Container var1, int var2, int var3);

    protected abstract Point getLocationOnScreen(Component var1);

    protected abstract Component findHeavyweightUnderCursor(boolean var1);

    private void _updateCursor(boolean bl) {
        Object object = lastUpdateLock;
        synchronized (object) {
            lastUpdateMillis = System.currentTimeMillis();
        }
        Point point = null;
        Point point2 = null;
        try {
            Component component = this.findHeavyweightUnderCursor(bl);
            if (component == null) {
                return;
            }
            if (component instanceof Window) {
                point2 = component.getLocation();
            } else if (component instanceof Container) {
                point2 = this.getLocationOnScreen(component);
            }
            if (point2 != null) {
                point = new Point();
                this.getCursorPos(point);
                Component component2 = this.findComponentAt((Container)component, point.x - point2.x, point.y - point2.y);
                if (component2 != null) {
                    component = component2;
                }
            }
            this.setCursor(component, component.getCursor(), bl);
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
    }

    static /* synthetic */ GlobalCursorManager access$000() {
        return GlobalCursorManager.getInstance();
    }

    static /* synthetic */ void access$100(GlobalCursorManager globalCursorManager, boolean bl) {
        globalCursorManager._updateCursor(bl);
    }

    static {
        curEvent = new CursorEvent();
        lastUpdateLock = new Object();
        treeLock = new Container().getTreeLock();
    }

    static class CursorEvent
    extends InvocationEvent {
        static boolean pending = false;

        public CursorEvent() {
            super((Object)Toolkit.getDefaultToolkit(), new Runnable(){

                public void run() {
                    boolean bl = false;
                    1 var2_2 = this;
                    synchronized (var2_2) {
                        if (CursorEvent.pending) {
                            CursorEvent.pending = false;
                            bl = true;
                        }
                    }
                    if (bl) {
                        GlobalCursorManager.access$100(GlobalCursorManager.access$000(), false);
                    }
                }
            });
        }

        public void postSelfIfNotPending(Component component) {
            boolean bl = false;
            CursorEvent cursorEvent = this;
            synchronized (cursorEvent) {
                if (!pending) {
                    bl = true;
                    pending = true;
                }
            }
            if (bl) {
                SunToolkit.postEvent(SunToolkit.targetToAppContext(component), this);
            }
        }
    }
}

