/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoundedRangeModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.plaf.basic.BasicArrowButton;

public class BasicScrollBarUI
extends ScrollBarUI
implements LayoutManager,
SwingConstants {
    private static final int POSITIVE_SCROLL = 1;
    private static final int NEGATIVE_SCROLL = -1;
    private static final int MIN_SCROLL = 2;
    private static final int MAX_SCROLL = 3;
    protected Dimension minimumThumbSize;
    protected Dimension maximumThumbSize;
    protected Color thumbHighlightColor;
    protected Color thumbLightShadowColor;
    protected Color thumbDarkShadowColor;
    protected Color thumbColor;
    protected Color trackColor;
    protected Color trackHighlightColor;
    protected JScrollBar scrollbar;
    protected JButton incrButton;
    protected JButton decrButton;
    protected boolean isDragging;
    protected TrackListener trackListener;
    protected ArrowButtonListener buttonListener;
    protected ModelListener modelListener;
    protected Rectangle thumbRect;
    protected Rectangle trackRect;
    protected int trackHighlight;
    protected static final int NO_HIGHLIGHT = 0;
    protected static final int DECREASE_HIGHLIGHT = 1;
    protected static final int INCREASE_HIGHLIGHT = 2;
    protected ScrollListener scrollListener;
    protected PropertyChangeListener propertyChangeListener;
    protected Timer scrollTimer;
    private static final int scrollSpeedThrottle = 60;
    private boolean supportsAbsolutePositioning;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicScrollBarUI();
    }

    protected void configureScrollBarColors() {
        this.thumbHighlightColor = UIManager.getColor("ScrollBar.thumbHighlight");
        this.thumbLightShadowColor = UIManager.getColor("ScrollBar.thumbLightShadow");
        this.thumbDarkShadowColor = UIManager.getColor("ScrollBar.thumbDarkShadow");
        this.thumbColor = UIManager.getColor("ScrollBar.thumb");
        this.trackColor = UIManager.getColor("ScrollBar.track");
        this.trackHighlightColor = UIManager.getColor("ScrollBar.trackHighlight");
    }

    public void installUI(JComponent jComponent) {
        this.scrollbar = (JScrollBar)jComponent;
        this.thumbRect = new Rectangle(0, 0, 0, 0);
        this.trackRect = new Rectangle(0, 0, 0, 0);
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.scrollbar = (JScrollBar)jComponent;
        this.uninstallDefaults();
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        jComponent.remove(this.incrButton);
        jComponent.remove(this.decrButton);
        jComponent.setLayout(null);
        this.thumbRect = null;
        this.scrollbar = null;
        this.incrButton = null;
        this.decrButton = null;
    }

    protected void installDefaults() {
        this.minimumThumbSize = (Dimension)UIManager.get("ScrollBar.minimumThumbSize");
        this.maximumThumbSize = (Dimension)UIManager.get("ScrollBar.maximumThumbSize");
        Boolean bl = (Boolean)UIManager.get("ScrollBar.allowsAbsolutePositioning");
        this.supportsAbsolutePositioning = bl != null ? bl : false;
        this.trackHighlight = 0;
        switch (this.scrollbar.getOrientation()) {
            case 1: {
                this.incrButton = this.createIncreaseButton(5);
                this.decrButton = this.createDecreaseButton(1);
                break;
            }
            case 0: {
                this.incrButton = this.createIncreaseButton(3);
                this.decrButton = this.createDecreaseButton(7);
            }
        }
        this.scrollbar.setLayout(this);
        this.scrollbar.add(this.incrButton);
        this.scrollbar.add(this.decrButton);
        this.scrollbar.setEnabled(this.scrollbar.isEnabled());
        this.scrollbar.setOpaque(true);
        this.configureScrollBarColors();
        LookAndFeel.installBorder(this.scrollbar, "ScrollBar.border");
    }

    protected void installComponents() {
    }

    protected void uninstallComponents() {
    }

    protected void installListeners() {
        this.trackListener = this.createTrackListener();
        this.buttonListener = this.createArrowButtonListener();
        this.modelListener = this.createModelListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.scrollbar.addMouseListener(this.trackListener);
        this.scrollbar.addMouseMotionListener(this.trackListener);
        this.scrollbar.getModel().addChangeListener(this.modelListener);
        this.scrollbar.addPropertyChangeListener(this.propertyChangeListener);
        if (this.incrButton != null) {
            this.incrButton.addMouseListener(this.buttonListener);
        }
        if (this.decrButton != null) {
            this.decrButton.addMouseListener(this.buttonListener);
        }
        this.scrollListener = this.createScrollListener();
        this.scrollTimer = new Timer(60, this.scrollListener);
        this.scrollTimer.setInitialDelay(300);
    }

    protected void installKeyboardActions() {
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.scrollbar, actionMap);
        InputMap inputMap = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.scrollbar, 0, inputMap);
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.scrollbar, 0, null);
        SwingUtilities.replaceUIActionMap(this.scrollbar, null);
    }

    private InputMap getInputMap(int n) {
        if (n == 0) {
            return (InputMap)UIManager.get("ScrollBar.focusInputMap");
        }
        return null;
    }

    private ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("ScrollBar.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.put("ScrollBar.actionMap", actionMap);
        }
        return actionMap;
    }

    private ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("positiveUnitIncrement", new SharedActionScroller(1, false));
        actionMapUIResource.put("positiveBlockIncrement", new SharedActionScroller(1, true));
        actionMapUIResource.put("negativeUnitIncrement", new SharedActionScroller(-1, false));
        actionMapUIResource.put("negativeBlockIncrement", new SharedActionScroller(-1, true));
        actionMapUIResource.put("minScroll", new SharedActionScroller(2, true));
        actionMapUIResource.put("maxScroll", new SharedActionScroller(3, true));
        return actionMapUIResource;
    }

    protected void uninstallListeners() {
        this.scrollTimer.stop();
        this.scrollTimer = null;
        if (this.decrButton != null) {
            this.decrButton.removeMouseListener(this.buttonListener);
        }
        if (this.incrButton != null) {
            this.incrButton.removeMouseListener(this.buttonListener);
        }
        this.scrollbar.getModel().removeChangeListener(this.modelListener);
        this.scrollbar.removeMouseListener(this.trackListener);
        this.scrollbar.removeMouseMotionListener(this.trackListener);
        this.scrollbar.removePropertyChangeListener(this.propertyChangeListener);
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.scrollbar);
    }

    protected TrackListener createTrackListener() {
        return new TrackListener();
    }

    protected ArrowButtonListener createArrowButtonListener() {
        return new ArrowButtonListener();
    }

    protected ModelListener createModelListener() {
        return new ModelListener();
    }

    protected ScrollListener createScrollListener() {
        return new ScrollListener();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.paintTrack(graphics, jComponent, this.getTrackBounds());
        this.paintThumb(graphics, jComponent, this.getThumbBounds());
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.scrollbar.getOrientation() == 1 ? new Dimension(16, 48) : new Dimension(48, 16);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected JButton createDecreaseButton(int n) {
        return new BasicArrowButton(n);
    }

    protected JButton createIncreaseButton(int n) {
        return new BasicArrowButton(n);
    }

    protected void paintDecreaseHighlight(Graphics graphics) {
        Insets insets = this.scrollbar.getInsets();
        Rectangle rectangle = this.getThumbBounds();
        graphics.setColor(this.trackHighlightColor);
        if (this.scrollbar.getOrientation() == 1) {
            int n = insets.left;
            int n2 = this.decrButton.getY() + this.decrButton.getHeight();
            int n3 = this.scrollbar.getWidth() - (insets.left + insets.right);
            int n4 = rectangle.y - n2;
            graphics.fillRect(n, n2, n3, n4);
        } else {
            int n = this.decrButton.getX() + this.decrButton.getHeight();
            int n5 = insets.top;
            int n6 = rectangle.x - n;
            int n7 = this.scrollbar.getHeight() - (insets.top + insets.bottom);
            graphics.fillRect(n, n5, n6, n7);
        }
    }

    protected void paintIncreaseHighlight(Graphics graphics) {
        Insets insets = this.scrollbar.getInsets();
        Rectangle rectangle = this.getThumbBounds();
        graphics.setColor(this.trackHighlightColor);
        if (this.scrollbar.getOrientation() == 1) {
            int n = insets.left;
            int n2 = rectangle.y + rectangle.height;
            int n3 = this.scrollbar.getWidth() - (insets.left + insets.right);
            int n4 = this.incrButton.getY() - n2;
            graphics.fillRect(n, n2, n3, n4);
        } else {
            int n = rectangle.x + rectangle.width;
            int n5 = insets.top;
            int n6 = this.incrButton.getX() - n;
            int n7 = this.scrollbar.getHeight() - (insets.top + insets.bottom);
            graphics.fillRect(n, n5, n6, n7);
        }
    }

    protected void paintTrack(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        graphics.setColor(this.trackColor);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this.trackHighlight == 1) {
            this.paintDecreaseHighlight(graphics);
        } else if (this.trackHighlight == 2) {
            this.paintIncreaseHighlight(graphics);
        }
    }

    protected void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        if (rectangle.isEmpty() || !this.scrollbar.isEnabled()) {
            return;
        }
        int n = rectangle.width;
        int n2 = rectangle.height;
        graphics.translate(rectangle.x, rectangle.y);
        graphics.setColor(this.thumbDarkShadowColor);
        graphics.drawRect(0, 0, n - 1, n2 - 1);
        graphics.setColor(this.thumbColor);
        graphics.fillRect(0, 0, n - 1, n2 - 1);
        graphics.setColor(this.thumbHighlightColor);
        graphics.drawLine(1, 1, 1, n2 - 2);
        graphics.drawLine(2, 1, n - 3, 1);
        graphics.setColor(this.thumbLightShadowColor);
        graphics.drawLine(2, n2 - 2, n - 2, n2 - 2);
        graphics.drawLine(n - 2, 1, n - 2, n2 - 3);
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    protected Dimension getMinimumThumbSize() {
        return this.minimumThumbSize;
    }

    protected Dimension getMaximumThumbSize() {
        return this.maximumThumbSize;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.getPreferredSize((JComponent)container);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.getMinimumSize((JComponent)container);
    }

    protected void layoutVScrollbar(JScrollBar jScrollBar) {
        int n;
        Dimension dimension = jScrollBar.getSize();
        Insets insets = jScrollBar.getInsets();
        int n2 = dimension.width - (insets.left + insets.right);
        int n3 = insets.left;
        int n4 = this.decrButton.getPreferredSize().height;
        int n5 = insets.top;
        int n6 = this.incrButton.getPreferredSize().height;
        int n7 = dimension.height - (insets.bottom + n6);
        int n8 = insets.top + insets.bottom;
        int n9 = n4 + n6;
        float f = dimension.height - (n8 + n9);
        float f2 = jScrollBar.getMinimum();
        float f3 = jScrollBar.getVisibleAmount();
        float f4 = (float)jScrollBar.getMaximum() - f2;
        float f5 = jScrollBar.getValue();
        int n10 = f4 <= 0.0f ? this.getMaximumThumbSize().height : (int)(f * (f3 / f4));
        n10 = Math.max(n10, this.getMinimumThumbSize().height);
        n10 = Math.min(n10, this.getMaximumThumbSize().height);
        int n11 = n7 - n10;
        if (jScrollBar.getValue() < jScrollBar.getMaximum() - jScrollBar.getVisibleAmount()) {
            float f6 = f - (float)n10;
            n11 = (int)(0.5f + f6 * ((f5 - f2) / (f4 - f3)));
            n11 += n5 + n4;
        }
        if ((n = dimension.height - n8) < n9) {
            n6 = n4 = n / 2;
            n7 = dimension.height - (insets.bottom + n6);
        }
        this.decrButton.setBounds(n3, n5, n2, n4);
        this.incrButton.setBounds(n3, n7, n2, n6);
        int n12 = n5 + n4;
        int n13 = n7 - n12;
        this.trackRect.setBounds(n3, n12, n2, n13);
        if (n10 >= (int)f) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (n11 + n10 > n7) {
                n11 = n7 - n10;
            }
            if (n11 < n5 + n4) {
                n11 = n5 + n4 + 1;
            }
            this.setThumbBounds(n3, n11, n2, n10);
        }
    }

    protected void layoutHScrollbar(JScrollBar jScrollBar) {
        int n;
        Dimension dimension = jScrollBar.getSize();
        Insets insets = jScrollBar.getInsets();
        int n2 = dimension.height - (insets.top + insets.bottom);
        int n3 = insets.top;
        int n4 = this.decrButton.getPreferredSize().width;
        int n5 = insets.left;
        int n6 = this.incrButton.getPreferredSize().width;
        int n7 = dimension.width - (insets.right + n6);
        int n8 = insets.left + insets.right;
        int n9 = n4 + n6;
        float f = dimension.width - (n8 + n9);
        float f2 = jScrollBar.getMinimum();
        float f3 = jScrollBar.getVisibleAmount();
        float f4 = (float)jScrollBar.getMaximum() - f2;
        float f5 = jScrollBar.getValue();
        int n10 = f4 <= 0.0f ? this.getMaximumThumbSize().width : (int)(f * (f3 / f4));
        n10 = Math.max(n10, this.getMinimumThumbSize().width);
        n10 = Math.min(n10, this.getMaximumThumbSize().width);
        int n11 = n7 - n10;
        if (jScrollBar.getValue() < jScrollBar.getMaximum() - jScrollBar.getVisibleAmount()) {
            float f6 = f - (float)n10;
            n11 = (int)(0.5f + f6 * ((f5 - f2) / (f4 - f3)));
            n11 += n5 + n4;
        }
        if ((n = dimension.width - n8) < n9) {
            n6 = n4 = n / 2;
            n7 = dimension.width - (insets.right + n6);
        }
        this.decrButton.setBounds(n5, n3, n4, n2);
        this.incrButton.setBounds(n7, n3, n6, n2);
        int n12 = n5 + n4;
        int n13 = n7 - n12;
        this.trackRect.setBounds(n12, n3, n13, n2);
        if (n10 >= (int)f) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (n11 + n10 > n7) {
                n11 = n7 - n10;
            }
            if (n11 < n5 + n4) {
                n11 = n5 + n4 + 1;
            }
            this.setThumbBounds(n11, n3, n10, n2);
        }
    }

    public void layoutContainer(Container container) {
        if (this.isDragging) {
            return;
        }
        JScrollBar jScrollBar = (JScrollBar)container;
        switch (jScrollBar.getOrientation()) {
            case 1: {
                this.layoutVScrollbar(jScrollBar);
                break;
            }
            case 0: {
                this.layoutHScrollbar(jScrollBar);
            }
        }
    }

    protected void setThumbBounds(int n, int n2, int n3, int n4) {
        if (this.thumbRect.x == n && this.thumbRect.y == n2 && this.thumbRect.width == n3 && this.thumbRect.height == n4) {
            return;
        }
        int n5 = Math.min(n, this.thumbRect.x);
        int n6 = Math.min(n2, this.thumbRect.y);
        int n7 = Math.max(n + n3, this.thumbRect.x + this.thumbRect.width);
        int n8 = Math.max(n2 + n4, this.thumbRect.y + this.thumbRect.height);
        this.thumbRect.setBounds(n, n2, n3, n4);
        this.scrollbar.repaint(n5, n6, n7 - n5, n8 - n6);
    }

    protected Rectangle getThumbBounds() {
        return this.thumbRect;
    }

    protected Rectangle getTrackBounds() {
        return this.trackRect;
    }

    protected void scrollByBlock(int n) {
        JScrollBar jScrollBar = this.scrollbar;
        synchronized (jScrollBar) {
            int n2 = this.scrollbar.getValue();
            int n3 = this.scrollbar.getBlockIncrement(n);
            int n4 = n3 * (n > 0 ? 1 : -1);
            this.scrollbar.setValue(n2 + n4);
            this.trackHighlight = n > 0 ? 2 : 1;
            Rectangle rectangle = this.getTrackBounds();
            this.scrollbar.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    protected void scrollByUnit(int n) {
        JScrollBar jScrollBar = this.scrollbar;
        synchronized (jScrollBar) {
            int n2 = n > 0 ? this.scrollbar.getUnitIncrement(n) : -this.scrollbar.getUnitIncrement(n);
            this.scrollbar.setValue(n2 + this.scrollbar.getValue());
        }
    }

    private boolean getSupportsAbsolutePositioning() {
        return this.supportsAbsolutePositioning;
    }

    private static class SharedActionScroller
    extends AbstractAction {
        private int dir;
        private boolean block;

        SharedActionScroller(int n, boolean bl) {
            this.dir = n;
            this.block = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JScrollBar jScrollBar = (JScrollBar)actionEvent.getSource();
            if (this.dir == -1 || this.dir == 1) {
                int n = this.block ? (this.dir == -1 ? -1 * jScrollBar.getBlockIncrement(-1) : jScrollBar.getBlockIncrement(1)) : (this.dir == -1 ? -1 * jScrollBar.getUnitIncrement(-1) : jScrollBar.getUnitIncrement(1));
                jScrollBar.setValue(jScrollBar.getValue() + n);
            } else if (this.dir == 2) {
                jScrollBar.setValue(jScrollBar.getMinimum());
            } else if (this.dir == 3) {
                jScrollBar.setValue(jScrollBar.getMaximum());
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("model".equals(string)) {
                BoundedRangeModel boundedRangeModel = (BoundedRangeModel)propertyChangeEvent.getOldValue();
                BoundedRangeModel boundedRangeModel2 = (BoundedRangeModel)propertyChangeEvent.getNewValue();
                boundedRangeModel.removeChangeListener(BasicScrollBarUI.this.modelListener);
                boundedRangeModel2.addChangeListener(BasicScrollBarUI.this.modelListener);
                BasicScrollBarUI.this.scrollbar.repaint();
                BasicScrollBarUI.this.scrollbar.revalidate();
            } else if ("orientation".equals(string)) {
                Integer n = (Integer)propertyChangeEvent.getNewValue();
                if (BasicScrollBarUI.this.incrButton instanceof BasicArrowButton) {
                    ((BasicArrowButton)BasicScrollBarUI.this.incrButton).setDirection(n == 0 ? 3 : 5);
                }
                if (BasicScrollBarUI.this.decrButton instanceof BasicArrowButton) {
                    ((BasicArrowButton)BasicScrollBarUI.this.decrButton).setDirection(n == 0 ? 7 : 1);
                }
            } else if ("componentOrientation".equals(string)) {
                ComponentOrientation componentOrientation = BasicScrollBarUI.this.scrollbar.getComponentOrientation();
                BasicScrollBarUI.this.incrButton.setComponentOrientation(componentOrientation);
                BasicScrollBarUI.this.decrButton.setComponentOrientation(componentOrientation);
            }
        }
    }

    protected class ScrollListener
    implements ActionListener {
        int direction = 1;
        boolean useBlockIncrement;

        public ScrollListener() {
            this.direction = 1;
            this.useBlockIncrement = false;
        }

        public ScrollListener(int n, boolean bl) {
            this.direction = n;
            this.useBlockIncrement = bl;
        }

        public void setDirection(int n) {
            this.direction = n;
        }

        public void setScrollByBlock(boolean bl) {
            this.useBlockIncrement = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.useBlockIncrement) {
                BasicScrollBarUI.this.scrollByBlock(this.direction);
                if (BasicScrollBarUI.this.scrollbar.getOrientation() == 1) {
                    if (this.direction > 0) {
                        if (BasicScrollBarUI.this.getThumbBounds().y + BasicScrollBarUI.this.getThumbBounds().height >= BasicScrollBarUI.this.trackListener.currentMouseY) {
                            ((Timer)actionEvent.getSource()).stop();
                        }
                    } else if (BasicScrollBarUI.this.getThumbBounds().y <= BasicScrollBarUI.this.trackListener.currentMouseY) {
                        ((Timer)actionEvent.getSource()).stop();
                    }
                } else if (this.direction > 0) {
                    if (BasicScrollBarUI.this.getThumbBounds().x + BasicScrollBarUI.this.getThumbBounds().width >= BasicScrollBarUI.this.trackListener.currentMouseX) {
                        ((Timer)actionEvent.getSource()).stop();
                    }
                } else if (BasicScrollBarUI.this.getThumbBounds().x <= BasicScrollBarUI.this.trackListener.currentMouseX) {
                    ((Timer)actionEvent.getSource()).stop();
                }
            } else {
                BasicScrollBarUI.this.scrollByUnit(this.direction);
            }
            if (this.direction > 0 && BasicScrollBarUI.this.scrollbar.getValue() + BasicScrollBarUI.this.scrollbar.getVisibleAmount() >= BasicScrollBarUI.this.scrollbar.getMaximum()) {
                ((Timer)actionEvent.getSource()).stop();
            } else if (this.direction < 0 && BasicScrollBarUI.this.scrollbar.getValue() <= BasicScrollBarUI.this.scrollbar.getMinimum()) {
                ((Timer)actionEvent.getSource()).stop();
            }
        }
    }

    protected class ArrowButtonListener
    extends MouseAdapter {
        boolean handledEvent;

        protected ArrowButtonListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!BasicScrollBarUI.this.scrollbar.isEnabled()) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            int n = mouseEvent.getSource() == BasicScrollBarUI.this.incrButton ? 1 : -1;
            BasicScrollBarUI.this.scrollByUnit(n);
            BasicScrollBarUI.this.scrollTimer.stop();
            BasicScrollBarUI.this.scrollListener.setDirection(n);
            BasicScrollBarUI.this.scrollListener.setScrollByBlock(false);
            BasicScrollBarUI.this.scrollTimer.start();
            this.handledEvent = true;
            if (!BasicScrollBarUI.this.scrollbar.hasFocus()) {
                BasicScrollBarUI.this.scrollbar.requestFocus();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            BasicScrollBarUI.this.scrollTimer.stop();
            this.handledEvent = false;
            BasicScrollBarUI.this.scrollbar.setValueIsAdjusting(false);
        }
    }

    protected class TrackListener
    extends MouseAdapter
    implements MouseMotionListener {
        protected transient int offset;
        protected transient int currentMouseX;
        protected transient int currentMouseY;

        protected TrackListener() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!BasicScrollBarUI.this.scrollbar.isEnabled()) {
                return;
            }
            if (BasicScrollBarUI.this.trackHighlight != 0) {
                Rectangle rectangle = BasicScrollBarUI.this.getTrackBounds();
                BasicScrollBarUI.this.scrollbar.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            BasicScrollBarUI.this.trackHighlight = 0;
            BasicScrollBarUI.this.isDragging = false;
            this.offset = 0;
            BasicScrollBarUI.this.scrollTimer.stop();
            BasicScrollBarUI.this.scrollbar.setValueIsAdjusting(false);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!BasicScrollBarUI.this.scrollbar.isEnabled()) {
                return;
            }
            if (!BasicScrollBarUI.this.scrollbar.hasFocus()) {
                BasicScrollBarUI.this.scrollbar.requestFocus();
            }
            BasicScrollBarUI.this.scrollbar.setValueIsAdjusting(true);
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            if (BasicScrollBarUI.this.getThumbBounds().contains(this.currentMouseX, this.currentMouseY)) {
                switch (BasicScrollBarUI.this.scrollbar.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - BasicScrollBarUI.this.getThumbBounds().y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - BasicScrollBarUI.this.getThumbBounds().x;
                    }
                }
                BasicScrollBarUI.this.isDragging = true;
                return;
            }
            if (BasicScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                switch (BasicScrollBarUI.this.scrollbar.getOrientation()) {
                    case 1: {
                        this.offset = BasicScrollBarUI.this.getThumbBounds().height / 2;
                        break;
                    }
                    case 0: {
                        this.offset = BasicScrollBarUI.this.getThumbBounds().width / 2;
                    }
                }
                BasicScrollBarUI.this.isDragging = true;
                this.setValueFrom(mouseEvent);
                return;
            }
            BasicScrollBarUI.this.isDragging = false;
            Dimension dimension = BasicScrollBarUI.this.scrollbar.getSize();
            int n = 1;
            switch (BasicScrollBarUI.this.scrollbar.getOrientation()) {
                case 1: {
                    if (BasicScrollBarUI.this.getThumbBounds().isEmpty()) {
                        int n2 = dimension.height / 2;
                        n = this.currentMouseY < n2 ? -1 : 1;
                        break;
                    }
                    int n3 = BasicScrollBarUI.this.getThumbBounds().y;
                    n = this.currentMouseY < n3 ? -1 : 1;
                    break;
                }
                case 0: {
                    int n4;
                    int n5;
                    n = BasicScrollBarUI.this.getThumbBounds().isEmpty() ? (this.currentMouseX < (n5 = dimension.width / 2) ? -1 : 1) : (this.currentMouseX < (n4 = BasicScrollBarUI.this.getThumbBounds().x) ? -1 : 1);
                }
            }
            BasicScrollBarUI.this.scrollByBlock(n);
            if (!BasicScrollBarUI.this.getThumbBounds().contains(this.currentMouseX, this.currentMouseY)) {
                BasicScrollBarUI.this.scrollTimer.stop();
                BasicScrollBarUI.this.scrollListener.setDirection(n);
                BasicScrollBarUI.this.scrollListener.setScrollByBlock(true);
                BasicScrollBarUI.this.scrollTimer.start();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.setValueFrom(mouseEvent);
        }

        private void setValueFrom(MouseEvent mouseEvent) {
            int n;
            int n2;
            int n3;
            if (!BasicScrollBarUI.this.scrollbar.isEnabled() || !BasicScrollBarUI.this.isDragging) {
                return;
            }
            BoundedRangeModel boundedRangeModel = BasicScrollBarUI.this.scrollbar.getModel();
            Rectangle rectangle = BasicScrollBarUI.this.getThumbBounds();
            if (BasicScrollBarUI.this.scrollbar.getOrientation() == 1) {
                n3 = BasicScrollBarUI.this.decrButton.getY() + BasicScrollBarUI.this.decrButton.getHeight();
                n2 = BasicScrollBarUI.this.incrButton.getY() - BasicScrollBarUI.this.getThumbBounds().height;
                n = Math.min(n2, Math.max(n3, mouseEvent.getY() - this.offset));
                BasicScrollBarUI.this.setThumbBounds(rectangle.x, n, rectangle.width, rectangle.height);
                float f = BasicScrollBarUI.this.getTrackBounds().height;
            } else {
                n3 = BasicScrollBarUI.this.decrButton.getX() + BasicScrollBarUI.this.decrButton.getWidth();
                n2 = BasicScrollBarUI.this.incrButton.getX() - BasicScrollBarUI.this.getThumbBounds().width;
                n = Math.min(n2, Math.max(n3, mouseEvent.getX() - this.offset));
                BasicScrollBarUI.this.setThumbBounds(n, rectangle.y, rectangle.width, rectangle.height);
                float f = BasicScrollBarUI.this.getTrackBounds().width;
            }
            if (n == n2) {
                BasicScrollBarUI.this.scrollbar.setValue(boundedRangeModel.getMaximum() - boundedRangeModel.getExtent());
            } else {
                float f = boundedRangeModel.getMaximum() - boundedRangeModel.getExtent();
                float f2 = f - (float)boundedRangeModel.getMinimum();
                float f3 = n - n3;
                float f4 = n2 - n3;
                int n4 = (int)(0.5 + (double)(f3 / f4 * f2));
                BasicScrollBarUI.this.scrollbar.setValue(n4 + boundedRangeModel.getMinimum());
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    protected class ModelListener
    implements ChangeListener {
        protected ModelListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            BasicScrollBarUI.this.layoutContainer(BasicScrollBarUI.this.scrollbar);
        }
    }
}

