/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.io;

import com.sun.corba.se.internal.io.ObjectStreamField;
import com.sun.corba.se.internal.io.ValueUtility;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import org.omg.CORBA.ValueMember;

public class ObjectStreamClass
implements Serializable {
    public static final long kDefaultUID = -1L;
    private static Object[] noArgsList = new Object[0];
    private static Class[] noTypesList = new Class[0];
    private static Hashtable translatedFields;
    private static ObjectStreamClassEntry[] descriptorFor;
    private String name;
    private ObjectStreamClass superclass;
    private boolean serializable;
    private boolean externalizable;
    private ObjectStreamField[] fields;
    private Class ofClass;
    boolean forProxyClass;
    private long suid = -1L;
    private String suidStr = null;
    private long actualSuid = -1L;
    private String actualSuidStr = null;
    int primBytes;
    int objFields;
    private Object lock = new Object();
    private boolean hasWriteObjectMethod;
    private boolean hasExternalizableBlockData;
    Method writeObjectMethod;
    Method readObjectMethod;
    private Method writeReplaceObjectMethod;
    private Method readResolveObjectMethod;
    private ObjectStreamClass localClassDesc;
    private static Class classSerializable;
    private static Class classExternalizable;
    private static final long serialVersionUID = -6120832682080437368L;
    public static final ObjectStreamField[] NO_FIELDS;
    private static Comparator compareClassByName;
    private static Comparator compareMemberByName;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$io$Externalizable;

    static final ObjectStreamClass lookup(Class clazz) {
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookupInternal(clazz);
        if (objectStreamClass.isSerializable() || objectStreamClass.isExternalizable()) {
            return objectStreamClass;
        }
        return null;
    }

    static ObjectStreamClass lookupInternal(Class clazz) {
        ObjectStreamClass objectStreamClass = null;
        ObjectStreamClassEntry[] objectStreamClassEntryArray = descriptorFor;
        synchronized (objectStreamClassEntryArray) {
            Class clazz2;
            objectStreamClass = ObjectStreamClass.findDescriptorFor(clazz);
            if (objectStreamClass != null) {
                ObjectStreamClass objectStreamClass2 = objectStreamClass;
                return objectStreamClass2;
            }
            boolean bl = classSerializable.isAssignableFrom(clazz);
            ObjectStreamClass objectStreamClass3 = null;
            if (bl && (clazz2 = clazz.getSuperclass()) != null) {
                objectStreamClass3 = ObjectStreamClass.lookup(clazz2);
            }
            boolean bl2 = false;
            if (bl) {
                boolean bl3 = bl2 = objectStreamClass3 != null && objectStreamClass3.isExternalizable() || classExternalizable.isAssignableFrom(clazz);
                if (bl2) {
                    bl = false;
                }
            }
            objectStreamClass = new ObjectStreamClass(clazz, objectStreamClass3, bl, bl2);
        }
        objectStreamClass.init();
        return objectStreamClass;
    }

    public final String getName() {
        return this.name;
    }

    public static final long getSerialVersionUID(Class clazz) {
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
        if (objectStreamClass != null) {
            return objectStreamClass.getSerialVersionUID();
        }
        return 0L;
    }

    public final long getSerialVersionUID() {
        return this.suid;
    }

    public final String getSerialVersionUIDStr() {
        if (this.suidStr == null) {
            this.suidStr = Long.toHexString(this.suid).toUpperCase();
        }
        return this.suidStr;
    }

    public static final long getActualSerialVersionUID(Class clazz) {
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
        if (objectStreamClass != null) {
            return objectStreamClass.getActualSerialVersionUID();
        }
        return 0L;
    }

    public final long getActualSerialVersionUID() {
        return this.actualSuid;
    }

    public final String getActualSerialVersionUIDStr() {
        if (this.actualSuidStr == null) {
            this.actualSuidStr = Long.toHexString(this.actualSuid).toUpperCase();
        }
        return this.actualSuidStr;
    }

    public final Class forClass() {
        return this.ofClass;
    }

    public ObjectStreamField[] getFields() {
        if (this.fields.length > 0) {
            ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[this.fields.length];
            System.arraycopy(this.fields, 0, objectStreamFieldArray, 0, this.fields.length);
            return objectStreamFieldArray;
        }
        return this.fields;
    }

    public boolean hasField(ValueMember valueMember) {
        int n = 0;
        while (n < this.fields.length) {
            try {
                if (this.fields[n].getName().equals(valueMember.name) && this.fields[n].getSignature().equals(ValueUtility.getSignature(valueMember))) {
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++n;
        }
        return false;
    }

    final ObjectStreamField[] getFieldsNoCopy() {
        return this.fields;
    }

    public final ObjectStreamField getField(String string) {
        int n = this.fields.length - 1;
        while (n >= 0) {
            if (string.equals(this.fields[n].getName())) {
                return this.fields[n];
            }
            --n;
        }
        return null;
    }

    public Serializable writeReplace(Serializable serializable) {
        if (this.writeReplaceObjectMethod != null) {
            try {
                return (Serializable)this.writeReplaceObjectMethod.invoke(serializable, noArgsList);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable.getMessage());
            }
        }
        return serializable;
    }

    public Object readResolve(Object object) {
        if (this.readResolveObjectMethod != null) {
            try {
                return this.readResolveObjectMethod.invoke(object, noArgsList);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable.getMessage());
            }
        }
        return object;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name);
        stringBuffer.append(": static final long serialVersionUID = ");
        stringBuffer.append(Long.toString(this.suid));
        stringBuffer.append("L;");
        return stringBuffer.toString();
    }

    private ObjectStreamClass(Class clazz, ObjectStreamClass objectStreamClass, boolean bl, boolean bl2) {
        this.ofClass = clazz;
        if (Proxy.isProxyClass(clazz)) {
            this.forProxyClass = true;
        }
        this.name = clazz.getName();
        this.superclass = objectStreamClass;
        this.serializable = bl;
        if (!this.forProxyClass) {
            this.externalizable = bl2;
        }
        ObjectStreamClass.insertDescriptorFor(this);
    }

    private void init() {
        Object object = this.lock;
        synchronized (object) {
            final Class clazz = this.ofClass;
            if (this.fields != null) {
                return;
            }
            if (!this.serializable || this.externalizable || this.forProxyClass || this.name.equals("java.lang.String")) {
                this.fields = NO_FIELDS;
            } else if (this.serializable) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Object object;
                        Field[] fieldArray;
                        try {
                            fieldArray = clazz.getDeclaredField("serialPersistentFields");
                            fieldArray.setAccessible(true);
                            object = (java.io.ObjectStreamField[])fieldArray.get(clazz);
                            int n = fieldArray.getModifiers();
                            if (Modifier.isPrivate(n) && Modifier.isStatic(n) && Modifier.isFinal(n)) {
                                ObjectStreamClass.access$002(ObjectStreamClass.this, (ObjectStreamField[])ObjectStreamClass.translateFields((Object[])fieldArray.get(clazz)));
                            }
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            ObjectStreamClass.access$002(ObjectStreamClass.this, null);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            ObjectStreamClass.access$002(ObjectStreamClass.this, null);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            ObjectStreamClass.access$002(ObjectStreamClass.this, null);
                        }
                        catch (ClassCastException classCastException) {
                            ObjectStreamClass.access$002(ObjectStreamClass.this, null);
                        }
                        if (ObjectStreamClass.this.fields == null) {
                            fieldArray = clazz.getDeclaredFields();
                            int n = 0;
                            ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[fieldArray.length];
                            int n2 = 0;
                            while (n2 < fieldArray.length) {
                                int n3 = fieldArray[n2].getModifiers();
                                if (!Modifier.isStatic(n3) && !Modifier.isTransient(n3)) {
                                    objectStreamFieldArray[n++] = new ObjectStreamField(fieldArray[n2]);
                                }
                                ++n2;
                            }
                            ObjectStreamClass.access$002(ObjectStreamClass.this, new ObjectStreamField[n]);
                            System.arraycopy(objectStreamFieldArray, 0, ObjectStreamClass.this.fields, 0, n);
                        } else {
                            int n = ObjectStreamClass.this.fields.length - 1;
                            while (n >= 0) {
                                try {
                                    object = clazz.getDeclaredField(ObjectStreamClass.this.fields[n].getName());
                                    if (ObjectStreamClass.this.fields[n].getType() == ((Field)object).getType()) {
                                        ObjectStreamClass.this.fields[n].setField((Field)object);
                                    }
                                }
                                catch (NoSuchFieldException noSuchFieldException) {
                                    // empty catch block
                                }
                                --n;
                            }
                        }
                        return null;
                    }
                });
                if (this.fields.length > 1) {
                    Arrays.sort(this.fields);
                }
                this.computeFieldInfo();
            }
            if (this.isNonSerializable()) {
                this.suid = 0L;
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){
                    static /* synthetic */ Class class$java$io$ObjectOutputStream;
                    static /* synthetic */ Class class$java$io$ObjectInputStream;

                    public Object run() {
                        int n;
                        Class[] classArray;
                        if (ObjectStreamClass.this.forProxyClass) {
                            ObjectStreamClass.this.suid = 0L;
                        } else {
                            try {
                                classArray = clazz.getDeclaredField("serialVersionUID");
                                n = classArray.getModifiers();
                                if (Modifier.isStatic(n) && Modifier.isFinal(n)) {
                                    classArray.setAccessible(true);
                                    ObjectStreamClass.this.suid = classArray.getLong(clazz);
                                } else {
                                    ObjectStreamClass.this.suid = ObjectStreamClass._computeSerialVersionUID(clazz);
                                }
                            }
                            catch (NoSuchFieldException noSuchFieldException) {
                                ObjectStreamClass.this.suid = ObjectStreamClass._computeSerialVersionUID(clazz);
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                ObjectStreamClass.this.suid = ObjectStreamClass._computeSerialVersionUID(clazz);
                            }
                        }
                        try {
                            ObjectStreamClass.this.writeReplaceObjectMethod = clazz.getDeclaredMethod("writeReplace", noTypesList);
                            if (Modifier.isStatic(ObjectStreamClass.this.writeReplaceObjectMethod.getModifiers())) {
                                ObjectStreamClass.this.writeReplaceObjectMethod = null;
                            } else {
                                ObjectStreamClass.this.writeReplaceObjectMethod.setAccessible(true);
                            }
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                        try {
                            ObjectStreamClass.this.readResolveObjectMethod = clazz.getDeclaredMethod("readResolve", noTypesList);
                            if (Modifier.isStatic(ObjectStreamClass.this.readResolveObjectMethod.getModifiers())) {
                                ObjectStreamClass.this.readResolveObjectMethod = null;
                            } else {
                                ObjectStreamClass.this.readResolveObjectMethod.setAccessible(true);
                            }
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                        if (ObjectStreamClass.this.serializable && !ObjectStreamClass.this.forProxyClass) {
                            try {
                                classArray = new Class[]{class$java$io$ObjectOutputStream == null ? (class$java$io$ObjectOutputStream = 2.class$("java.io.ObjectOutputStream")) : class$java$io$ObjectOutputStream};
                                ObjectStreamClass.this.writeObjectMethod = clazz.getDeclaredMethod("writeObject", classArray);
                                ObjectStreamClass.this.hasWriteObjectMethod = true;
                                n = ObjectStreamClass.this.writeObjectMethod.getModifiers();
                                if (!Modifier.isPrivate(n) || Modifier.isStatic(n)) {
                                    ObjectStreamClass.this.writeObjectMethod = null;
                                    ObjectStreamClass.this.hasWriteObjectMethod = false;
                                }
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                // empty catch block
                            }
                            try {
                                classArray = new Class[]{class$java$io$ObjectInputStream == null ? (class$java$io$ObjectInputStream = 2.class$("java.io.ObjectInputStream")) : class$java$io$ObjectInputStream};
                                ObjectStreamClass.this.readObjectMethod = clazz.getDeclaredMethod("readObject", classArray);
                                n = ObjectStreamClass.this.readObjectMethod.getModifiers();
                                if (!Modifier.isPrivate(n) || Modifier.isStatic(n)) {
                                    ObjectStreamClass.this.readObjectMethod = null;
                                }
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                // empty catch block
                            }
                        }
                        return null;
                    }

                    static /* synthetic */ Class class$(String string) {
                        try {
                            return Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                });
            }
            this.actualSuid = ObjectStreamClass.computeStructuralUID(this, clazz);
        }
    }

    ObjectStreamClass(String string, long l) {
        this.name = string;
        this.suid = l;
        this.superclass = null;
    }

    private static Object[] translateFields(Object[] objectArray) throws NoSuchFieldException {
        try {
            java.io.ObjectStreamField[] objectStreamFieldArray = (java.io.ObjectStreamField[])objectArray;
            Object[] objectArray2 = null;
            if (translatedFields == null) {
                translatedFields = new Hashtable();
            }
            if ((objectArray2 = (Object[])translatedFields.get(objectStreamFieldArray)) != null) {
                return objectArray2;
            }
            Class clazz = Class.forName("com.sun.corba.se.internal.io.ObjectStreamField");
            objectArray2 = (Object[])Array.newInstance(clazz, objectArray.length);
            Object[] objectArray3 = new Object[2];
            Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ObjectStreamClass.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Class == null ? (class$java$lang$Class = ObjectStreamClass.class$("java.lang.Class")) : class$java$lang$Class};
            Constructor constructor = clazz.getDeclaredConstructor(classArray);
            int n = objectStreamFieldArray.length - 1;
            while (n >= 0) {
                objectArray3[0] = objectStreamFieldArray[n].getName();
                objectArray3[1] = objectStreamFieldArray[n].getType();
                objectArray2[n] = constructor.newInstance(objectArray3);
                --n;
            }
            translatedFields.put(objectStreamFieldArray, objectArray2);
            return objectArray2;
        }
        catch (Throwable throwable) {
            throw new NoSuchFieldException();
        }
    }

    final void setClass(Class clazz) throws InvalidClassException {
        if (clazz == null) {
            this.localClassDesc = null;
            this.ofClass = null;
            this.computeFieldInfo();
            return;
        }
        this.localClassDesc = ObjectStreamClass.lookupInternal(clazz);
        if (this.localClassDesc == null) {
            throw new InvalidClassException(clazz.getName(), "Local class not compatible");
        }
        if (this.suid != this.localClassDesc.suid) {
            boolean bl;
            boolean bl2 = this.isNonSerializable() || this.localClassDesc.isNonSerializable();
            boolean bl3 = bl = clazz.isArray() && !clazz.getName().equals(this.name);
            if (!bl && !bl2) {
                throw new InvalidClassException(clazz.getName(), "Local class not compatible: stream classdesc serialVersionUID=" + this.suid + " local class serialVersionUID=" + this.localClassDesc.suid);
            }
        }
        if (!ObjectStreamClass.compareClassNames(this.name, clazz.getName(), '.')) {
            throw new InvalidClassException(clazz.getName(), "Incompatible local class name. Expected class name compatible with " + this.name);
        }
        if (this.serializable != this.localClassDesc.serializable || this.externalizable != this.localClassDesc.externalizable || !this.serializable && !this.externalizable) {
            throw new InvalidClassException(clazz.getName(), "Serialization incompatible with Externalization");
        }
        ObjectStreamField[] objectStreamFieldArray = this.localClassDesc.fields;
        ObjectStreamField[] objectStreamFieldArray2 = this.fields;
        int n = 0;
        int n2 = 0;
        while (n2 < objectStreamFieldArray2.length) {
            int n3 = n;
            while (n3 < objectStreamFieldArray.length) {
                if (objectStreamFieldArray2[n2].getName().equals(objectStreamFieldArray[n3].getName())) {
                    if (objectStreamFieldArray2[n2].isPrimitive() && !objectStreamFieldArray2[n2].typeEquals(objectStreamFieldArray[n3])) {
                        throw new InvalidClassException(clazz.getName(), "The type of field " + objectStreamFieldArray2[n2].getName() + " of class " + this.name + " is incompatible.");
                    }
                    n = n3;
                    objectStreamFieldArray2[n2].setField(objectStreamFieldArray[n].getField());
                    break;
                }
                ++n3;
            }
            ++n2;
        }
        this.computeFieldInfo();
        this.ofClass = clazz;
        this.readObjectMethod = this.localClassDesc.readObjectMethod;
        this.readResolveObjectMethod = this.localClassDesc.readResolveObjectMethod;
    }

    static boolean compareClassNames(String string, String string2, char c) {
        int n;
        int n2 = string.lastIndexOf(c);
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = string2.lastIndexOf(c)) < 0) {
            n = 0;
        }
        return string.regionMatches(false, n2, string2, n, string.length() - n2);
    }

    final boolean typeEquals(ObjectStreamClass objectStreamClass) {
        return this.suid == objectStreamClass.suid && ObjectStreamClass.compareClassNames(this.name, objectStreamClass.name, '.');
    }

    final void setSuperclass(ObjectStreamClass objectStreamClass) {
        this.superclass = objectStreamClass;
    }

    final ObjectStreamClass getSuperclass() {
        return this.superclass;
    }

    final boolean hasWriteObject() {
        return this.hasWriteObjectMethod;
    }

    final boolean isCustomMarshaled() {
        return this.hasWriteObject() || this.isExternalizable();
    }

    boolean hasExternalizableBlockDataMode() {
        return this.hasExternalizableBlockData;
    }

    final ObjectStreamClass localClassDescriptor() {
        return this.localClassDesc;
    }

    boolean isSerializable() {
        return this.serializable;
    }

    boolean isExternalizable() {
        return this.externalizable;
    }

    boolean isNonSerializable() {
        return !this.externalizable && !this.serializable;
    }

    private void computeFieldInfo() {
        this.primBytes = 0;
        this.objFields = 0;
        int n = 0;
        while (n < this.fields.length) {
            switch (this.fields[n].getTypeCode()) {
                case 'B': 
                case 'Z': {
                    ++this.primBytes;
                    break;
                }
                case 'C': 
                case 'S': {
                    this.primBytes += 2;
                    break;
                }
                case 'F': 
                case 'I': {
                    this.primBytes += 4;
                    break;
                }
                case 'D': 
                case 'J': {
                    this.primBytes += 8;
                    break;
                }
                case 'L': 
                case '[': {
                    ++this.objFields;
                }
            }
            ++n;
        }
    }

    private static long _computeSerialVersionUID(Class clazz) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        long l = 0L;
        try {
            Object object;
            Object object2;
            int n;
            MethodSignature[] methodSignatureArray;
            int n2;
            Object[] objectArray;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DigestOutputStream digestOutputStream = new DigestOutputStream(byteArrayOutputStream, messageDigest);
            DataOutputStream dataOutputStream = new DataOutputStream(digestOutputStream);
            dataOutputStream.writeUTF(clazz.getName());
            int n3 = clazz.getModifiers();
            Member[] memberArray = clazz.getDeclaredMethods();
            if (((n3 &= 0x611) & 0x200) != 0) {
                n3 &= 0xFFFFFBFF;
                if (memberArray.length > 0) {
                    n3 |= 0x400;
                }
            }
            dataOutputStream.writeInt(n3);
            if (!clazz.isArray()) {
                objectArray = clazz.getInterfaces();
                Arrays.sort(objectArray, compareClassByName);
                n2 = 0;
                while (n2 < objectArray.length) {
                    dataOutputStream.writeUTF(((Class)objectArray[n2]).getName());
                    ++n2;
                }
            }
            objectArray = clazz.getDeclaredFields();
            Arrays.sort(objectArray, compareMemberByName);
            n2 = 0;
            while (n2 < objectArray.length) {
                methodSignatureArray = objectArray[n2];
                n = methodSignatureArray.getModifiers();
                if (!Modifier.isPrivate(n) || !Modifier.isTransient(n) && !Modifier.isStatic(n)) {
                    dataOutputStream.writeUTF(methodSignatureArray.getName());
                    dataOutputStream.writeInt(n);
                    dataOutputStream.writeUTF(ObjectStreamClass.getSignature(methodSignatureArray.getType()));
                }
                ++n2;
            }
            if (ObjectStreamClass.hasStaticInitializer(clazz)) {
                dataOutputStream.writeUTF("<clinit>");
                dataOutputStream.writeInt(8);
                dataOutputStream.writeUTF("()V");
            }
            methodSignatureArray = MethodSignature.removePrivateAndSort(clazz.getDeclaredConstructors());
            n = 0;
            while (n < methodSignatureArray.length) {
                object2 = methodSignatureArray[n];
                String string = "<init>";
                object = object2.signature;
                object = ((String)object).replace('/', '.');
                dataOutputStream.writeUTF(string);
                dataOutputStream.writeInt(object2.member.getModifiers());
                dataOutputStream.writeUTF((String)object);
                ++n;
            }
            object2 = MethodSignature.removePrivateAndSort(memberArray);
            int n4 = 0;
            while (n4 < ((MethodSignature[])object2).length) {
                object = object2[n4];
                String string = ((MethodSignature)object).signature;
                string = string.replace('/', '.');
                dataOutputStream.writeUTF(((MethodSignature)object).member.getName());
                dataOutputStream.writeInt(((MethodSignature)object).member.getModifiers());
                dataOutputStream.writeUTF(string);
                ++n4;
            }
            dataOutputStream.flush();
            object = messageDigest.digest();
            int n5 = 0;
            while (n5 < Math.min(8, ((Object)object).length)) {
                l += (long)(object[n5] & 0xFF) << n5 * 8;
                ++n5;
            }
        }
        catch (IOException iOException) {
            l = -1L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException(noSuchAlgorithmException.getMessage());
        }
        return l;
    }

    private static long computeStructuralUID(ObjectStreamClass objectStreamClass, Class clazz) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        long l = 0L;
        try {
            int n;
            Object object;
            if (!(class$java$io$Serializable == null ? (class$java$io$Serializable = ObjectStreamClass.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clazz) || clazz.isInterface()) {
                return 0L;
            }
            if ((class$java$io$Externalizable == null ? (class$java$io$Externalizable = ObjectStreamClass.class$("java.io.Externalizable")) : class$java$io$Externalizable).isAssignableFrom(clazz)) {
                return 1L;
            }
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DigestOutputStream digestOutputStream = new DigestOutputStream(byteArrayOutputStream, messageDigest);
            DataOutputStream dataOutputStream = new DataOutputStream(digestOutputStream);
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 != null) {
                dataOutputStream.writeLong(ObjectStreamClass.computeStructuralUID(ObjectStreamClass.lookup(clazz2), clazz2));
            }
            if (objectStreamClass.hasWriteObject()) {
                dataOutputStream.writeInt(2);
            } else {
                dataOutputStream.writeInt(1);
            }
            ObjectStreamField[] objectStreamFieldArray = objectStreamClass.getFields();
            int n2 = 0;
            int n3 = 0;
            while (n3 < objectStreamFieldArray.length) {
                if (objectStreamFieldArray[n3].getField() != null) {
                    ++n2;
                }
                ++n3;
            }
            Object[] objectArray = new Field[n2];
            int n4 = 0;
            int n5 = 0;
            while (n4 < objectStreamFieldArray.length) {
                if (objectStreamFieldArray[n4].getField() != null) {
                    objectArray[n5++] = objectStreamFieldArray[n4].getField();
                }
                ++n4;
            }
            if (objectArray.length > 1) {
                Arrays.sort(objectArray, compareMemberByName);
            }
            int n6 = 0;
            while (n6 < objectArray.length) {
                object = objectArray[n6];
                n = ((Field)object).getModifiers();
                dataOutputStream.writeUTF(((Field)object).getName());
                dataOutputStream.writeUTF(ObjectStreamClass.getSignature(((Field)object).getType()));
                ++n6;
            }
            dataOutputStream.flush();
            object = messageDigest.digest();
            n = 0;
            while (n < Math.min(8, ((Object)object).length)) {
                l += (long)(object[n] & 0xFF) << n * 8;
                ++n;
            }
        }
        catch (IOException iOException) {
            l = -1L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException(noSuchAlgorithmException.getMessage());
        }
        return l;
    }

    static String getSignature(Class clazz) {
        String string = null;
        if (clazz.isArray()) {
            Class clazz2 = clazz;
            int n = 0;
            while (clazz2.isArray()) {
                ++n;
                clazz2 = clazz2.getComponentType();
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append("[");
                ++n2;
            }
            stringBuffer.append(ObjectStreamClass.getSignature(clazz2));
            string = stringBuffer.toString();
        } else if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                string = "I";
            } else if (clazz == Byte.TYPE) {
                string = "B";
            } else if (clazz == Long.TYPE) {
                string = "J";
            } else if (clazz == Float.TYPE) {
                string = "F";
            } else if (clazz == Double.TYPE) {
                string = "D";
            } else if (clazz == Short.TYPE) {
                string = "S";
            } else if (clazz == Character.TYPE) {
                string = "C";
            } else if (clazz == Boolean.TYPE) {
                string = "Z";
            } else if (clazz == Void.TYPE) {
                string = "V";
            }
        } else {
            string = "L" + clazz.getName().replace('.', '/') + ";";
        }
        return string;
    }

    static String getSignature(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        Class[] classArray = method.getParameterTypes();
        int n = 0;
        while (n < classArray.length) {
            stringBuffer.append(ObjectStreamClass.getSignature(classArray[n]));
            ++n;
        }
        stringBuffer.append(")");
        stringBuffer.append(ObjectStreamClass.getSignature(method.getReturnType()));
        return stringBuffer.toString();
    }

    static String getSignature(Constructor constructor) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        Class[] classArray = constructor.getParameterTypes();
        int n = 0;
        while (n < classArray.length) {
            stringBuffer.append(ObjectStreamClass.getSignature(classArray[n]));
            ++n;
        }
        stringBuffer.append(")V");
        return stringBuffer.toString();
    }

    private static ObjectStreamClass findDescriptorFor(Class clazz) {
        ObjectStreamClassEntry objectStreamClassEntry;
        int n = clazz.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % descriptorFor.length;
        while ((objectStreamClassEntry = descriptorFor[n2]) != null && objectStreamClassEntry.get() == null) {
            ObjectStreamClass.descriptorFor[n2] = objectStreamClassEntry.next;
        }
        ObjectStreamClassEntry objectStreamClassEntry2 = objectStreamClassEntry;
        while (objectStreamClassEntry != null) {
            ObjectStreamClass objectStreamClass = (ObjectStreamClass)objectStreamClassEntry.get();
            if (objectStreamClass == null) {
                objectStreamClassEntry2.next = objectStreamClassEntry.next;
            } else {
                if (objectStreamClass.ofClass == clazz) {
                    return objectStreamClass;
                }
                objectStreamClassEntry2 = objectStreamClassEntry;
            }
            objectStreamClassEntry = objectStreamClassEntry.next;
        }
        return null;
    }

    private static void insertDescriptorFor(ObjectStreamClass objectStreamClass) {
        if (ObjectStreamClass.findDescriptorFor(objectStreamClass.ofClass) != null) {
            return;
        }
        int n = objectStreamClass.ofClass.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % descriptorFor.length;
        ObjectStreamClassEntry objectStreamClassEntry = new ObjectStreamClassEntry(objectStreamClass);
        objectStreamClassEntry.next = descriptorFor[n2];
        ObjectStreamClass.descriptorFor[n2] = objectStreamClassEntry;
    }

    private static Field[] getDeclaredFields(final Class clazz) {
        return (Field[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getDeclaredFields();
            }
        });
    }

    private static native boolean hasStaticInitializer(Class var0);

    static /* synthetic */ ObjectStreamField[] access$002(ObjectStreamClass objectStreamClass, ObjectStreamField[] objectStreamFieldArray) {
        objectStreamClass.fields = objectStreamFieldArray;
        return objectStreamFieldArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            Class.forName("com.sun.corba.se.internal.io.LibraryManager").getDeclaredMethod("load", null).invoke(null, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        descriptorFor = new ObjectStreamClassEntry[61];
        classSerializable = null;
        classExternalizable = null;
        try {
            classSerializable = Class.forName("java.io.Serializable");
            classExternalizable = Class.forName("java.io.Externalizable");
        }
        catch (Throwable throwable) {
            System.err.println("Could not load java.io.Serializable or java.io.Externalizable.");
        }
        NO_FIELDS = new ObjectStreamField[0];
        compareClassByName = new CompareClassByName();
        compareMemberByName = new CompareMemberByName();
    }

    private static class MethodSignature
    implements Comparator {
        Member member;
        String signature;

        static MethodSignature[] removePrivateAndSort(Member[] memberArray) {
            int n = 0;
            int n2 = 0;
            while (n2 < memberArray.length) {
                if (!Modifier.isPrivate(memberArray[n2].getModifiers())) {
                    ++n;
                }
                ++n2;
            }
            Object[] objectArray = new MethodSignature[n];
            int n3 = 0;
            int n4 = 0;
            while (n4 < memberArray.length) {
                if (!Modifier.isPrivate(memberArray[n4].getModifiers())) {
                    objectArray[n3] = new MethodSignature(memberArray[n4]);
                    ++n3;
                }
                ++n4;
            }
            if (n3 > 0) {
                Arrays.sort(objectArray, objectArray[0]);
            }
            return objectArray;
        }

        public int compare(Object object, Object object2) {
            int n;
            if (object == object2) {
                return 0;
            }
            MethodSignature methodSignature = (MethodSignature)object;
            MethodSignature methodSignature2 = (MethodSignature)object2;
            if (this.isConstructor()) {
                n = methodSignature.signature.compareTo(methodSignature2.signature);
            } else {
                n = methodSignature.member.getName().compareTo(methodSignature2.member.getName());
                if (n == 0) {
                    n = methodSignature.signature.compareTo(methodSignature2.signature);
                }
            }
            return n;
        }

        private final boolean isConstructor() {
            return this.member instanceof Constructor;
        }

        private MethodSignature(Member member) {
            this.member = member;
            this.signature = this.isConstructor() ? ObjectStreamClass.getSignature((Constructor)member) : ObjectStreamClass.getSignature((Method)member);
        }
    }

    private static class CompareMemberByName
    implements Comparator {
        private CompareMemberByName() {
        }

        public int compare(Object object, Object object2) {
            String string = ((Member)object).getName();
            String string2 = ((Member)object2).getName();
            if (object instanceof Method) {
                string = string + ObjectStreamClass.getSignature((Method)object);
                string2 = string2 + ObjectStreamClass.getSignature((Method)object2);
            } else if (object instanceof Constructor) {
                string = string + ObjectStreamClass.getSignature((Constructor)object);
                string2 = string2 + ObjectStreamClass.getSignature((Constructor)object2);
            }
            return string.compareTo(string2);
        }
    }

    private static class CompareClassByName
    implements Comparator {
        private CompareClassByName() {
        }

        public int compare(Object object, Object object2) {
            Class clazz = (Class)object;
            Class clazz2 = (Class)object2;
            return clazz.getName().compareTo(clazz2.getName());
        }
    }

    private static class ObjectStreamClassEntry {
        ObjectStreamClassEntry next;
        private ObjectStreamClass c;

        ObjectStreamClassEntry(ObjectStreamClass objectStreamClass) {
            this.c = objectStreamClass;
        }

        public Object get() {
            return this.c;
        }
    }
}

