/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.converter.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import sun.plugin.converter.ResourceHandler;
import sun.plugin.converter.engine.ConverterProgressEvent;
import sun.plugin.converter.engine.ConverterProgressListener;
import sun.plugin.converter.engine.PluginConverter;

public class ProgressGUI
extends JFrame
implements ActionListener,
ConverterProgressListener {
    private static final int WIDTH = 350;
    private static final int HEIGHT = 235;
    private JButton cancelBttn;
    private JLabel processingLbl;
    private JLabel folderLbl;
    private JLabel fileLbl;
    private JLabel totalFilesLbl;
    private JLabel totalAppletsLbl;
    private JLabel totalErrorsLbl;
    private JLabel processing2Lbl;
    private JLabel folder2Lbl;
    private JLabel file2Lbl;
    private JLabel totalFiles2Lbl;
    private JLabel totalApplets2Lbl;
    private JLabel totalErrors2Lbl;
    private PluginConverter converter;

    public ProgressGUI(PluginConverter pluginConverter) {
        super(ResourceHandler.getMessage("progress_dialog.caption"));
        this.converter = pluginConverter;
        this.setResizable(true);
        this.majorLayout();
    }

    public void setVisible(boolean bl) {
        if (bl) {
            Dimension dimension = this.getToolkit().getScreenSize();
            ((Component)this).setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        }
        super.setVisible(bl);
        if (bl) {
            this.converter.startConversion();
            this.converter.addConverterProgressListener(this);
        }
    }

    public void majorLayout() {
        this.processingLbl = new JLabel(ResourceHandler.getMessage("progress_dialog.processing"));
        this.processing2Lbl = new JLabel();
        this.folderLbl = new JLabel(ResourceHandler.getMessage("progress_dialog.folder"));
        this.folder2Lbl = new JLabel();
        this.fileLbl = new JLabel(ResourceHandler.getMessage("progress_dialog.file"));
        this.file2Lbl = new JLabel();
        this.totalFilesLbl = new JLabel(ResourceHandler.getMessage("progress_dialog.totalfile"));
        this.totalFiles2Lbl = new JLabel();
        this.totalAppletsLbl = new JLabel(ResourceHandler.getMessage("progress_dialog.totalapplet"));
        this.totalApplets2Lbl = new JLabel();
        this.totalErrorsLbl = new JLabel(ResourceHandler.getMessage("progress_dialog.totalerror"));
        this.totalErrors2Lbl = new JLabel();
        this.cancelBttn = new JButton(ResourceHandler.getMessage("button.cancel"));
        this.addListeners();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        gridBagLayout.setConstraints(this.processingLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        gridBagLayout.setConstraints(this.processing2Lbl, new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 0, 10), 0, 0));
        gridBagLayout.setConstraints(this.folderLbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        gridBagLayout.setConstraints(this.folder2Lbl, new GridBagConstraints(1, 1, 0, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 0, 10), 0, 0));
        gridBagLayout.setConstraints(this.fileLbl, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        gridBagLayout.setConstraints(this.file2Lbl, new GridBagConstraints(1, 2, 0, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 10), 0, 0));
        gridBagLayout.setConstraints(this.totalFilesLbl, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        gridBagLayout.setConstraints(this.totalFiles2Lbl, new GridBagConstraints(2, 3, 0, 1, 1.0, 0.0, 17, 0, new Insets(10, 0, 0, 10), 0, 0));
        gridBagLayout.setConstraints(this.totalAppletsLbl, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        gridBagLayout.setConstraints(this.totalApplets2Lbl, new GridBagConstraints(2, 4, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 10), 0, 0));
        gridBagLayout.setConstraints(this.totalErrorsLbl, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        gridBagLayout.setConstraints(this.totalErrors2Lbl, new GridBagConstraints(2, 5, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 10), 0, 0));
        gridBagLayout.setConstraints(this.cancelBttn, new GridBagConstraints(0, 6, 0, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 10, 10), 0, 0));
        this.getContentPane().add(this.processingLbl);
        this.getContentPane().add(this.processing2Lbl);
        this.getContentPane().add(this.folderLbl);
        this.getContentPane().add(this.folder2Lbl);
        this.getContentPane().add(this.fileLbl);
        this.getContentPane().add(this.file2Lbl);
        this.getContentPane().add(this.totalFilesLbl);
        this.getContentPane().add(this.totalFiles2Lbl);
        this.getContentPane().add(this.totalAppletsLbl);
        this.getContentPane().add(this.totalApplets2Lbl);
        this.getContentPane().add(this.totalErrorsLbl);
        this.getContentPane().add(this.totalErrors2Lbl);
        this.getContentPane().add(this.cancelBttn);
        ((Component)this).setSize(350, 235);
    }

    private void addListeners() {
        this.cancelBttn.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ProgressGUI.this.close();
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Component component = (Component)actionEvent.getSource();
        if (component == this.cancelBttn) {
            this.close();
        }
    }

    protected void close() {
        this.converter.stopConversion();
        this.setVisible(false);
        this.dispose();
    }

    public void converterProgressUpdate(ConverterProgressEvent converterProgressEvent) {
        this.processing2Lbl.setText(converterProgressEvent.getStatusText());
        this.folder2Lbl.setText(converterProgressEvent.getSourcePath());
        this.file2Lbl.setText(converterProgressEvent.getCurrentFile());
        this.totalFiles2Lbl.setText(String.valueOf(converterProgressEvent.getFilesProcessed()));
        this.totalApplets2Lbl.setText(String.valueOf(converterProgressEvent.getAppletsFound()));
        this.totalErrors2Lbl.setText(String.valueOf(converterProgressEvent.getErrorsFound()));
        this.pack();
        if (converterProgressEvent.getStatus() == -14) {
            this.folder2Lbl.setText("");
            this.file2Lbl.setText("");
            this.cancelBttn.setText(ResourceHandler.getMessage("button.done"));
        } else if (converterProgressEvent.getStatus() == -15) {
            // empty if block
        }
    }
}

