/*
 * Decompiled with CFR 0.152.
 */
import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

class ImageCanvas
extends Canvas {
    BufferedImage image;

    public void setImage(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)fileInputStream);
            this.image = jPEGImageDecoder.decodeAsBufferedImage();
            fileInputStream.close();
        }
        catch (IOException iOException) {
            this.image = null;
            System.err.println("Could not load image file: " + string);
        }
        catch (ImageFormatException imageFormatException) {
            this.image = null;
            System.err.println("Bad image format: " + string);
        }
        if (this.image != null) {
            this.setSize(this.image.getWidth(), this.image.getHeight());
            this.resizeParent();
        }
        this.repaint();
    }

    public void resizeParent() {
        Container container = this.getParent();
        if (container instanceof ScrollPane) {
            ((Component)container).validate();
        }
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.image != null) {
            graphics2D.drawImage((Image)this.image, 0, 0, this);
        } else {
            graphics2D.setPaint(graphics2D.getBackground());
            graphics2D.fill(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
        }
    }
}

