/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.debug;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import sun.tools.agent.AgentConstants;
import sun.tools.debug.AgentIn;
import sun.tools.debug.DebuggerCallback;
import sun.tools.debug.LocalVariable;
import sun.tools.debug.NoSessionException;
import sun.tools.debug.RemoteArray;
import sun.tools.debug.RemoteBoolean;
import sun.tools.debug.RemoteByte;
import sun.tools.debug.RemoteChar;
import sun.tools.debug.RemoteClass;
import sun.tools.debug.RemoteDouble;
import sun.tools.debug.RemoteField;
import sun.tools.debug.RemoteFloat;
import sun.tools.debug.RemoteInt;
import sun.tools.debug.RemoteLong;
import sun.tools.debug.RemoteObject;
import sun.tools.debug.RemoteShort;
import sun.tools.debug.RemoteStackFrame;
import sun.tools.debug.RemoteString;
import sun.tools.debug.RemoteThread;
import sun.tools.debug.RemoteThreadGroup;
import sun.tools.debug.RemoteValue;

class RemoteAgent
implements AgentConstants {
    private Socket socket;
    private DataInputStream in;
    private DataOutputStream out;
    private Hashtable objects = new Hashtable();
    private DebuggerCallback client;
    private AgentIn debugIn = null;
    private Thread debugInThread = null;
    private RemoteClass classObject;
    RemoteClass classClass;
    RemoteClass classString;
    boolean closeRemoteInterpreter = false;
    private RemoteThreadGroup systemThreadGroup;
    private boolean verbose = false;
    private boolean closing = false;
    private boolean closed = false;

    private int readPassword(String string) {
        int n;
        int n2 = 0;
        int n3 = "23456789abcdefghijkmnpqrstuvwxyz".length();
        int n4 = 0;
        while (n4 < string.length()) {
            n = "23456789abcdefghijkmnpqrstuvwxyz".indexOf(string.charAt(n4));
            if (n == -1) {
                return 0;
            }
            n2 = n2 * n3 + n;
            ++n4;
        }
        n = 0;
        int n5 = 0;
        while (n5 < 8) {
            int n6 = n2 & 6 << n5 * 3;
            n |= n6 >> n5 + 1;
            ++n5;
        }
        return n;
    }

    private void initSession(boolean bl) throws Exception {
        int n = this.in.readInt();
        if (n != 3) {
            System.err.println("Version mismatch between debugger and remote agent.");
            System.exit(1);
        }
        this.classObject = (RemoteClass)this.readValue(this.in);
        this.classClass = (RemoteClass)this.readValue(this.in);
        this.classString = (RemoteClass)this.readValue(this.in);
        this.message("loading classes ...");
        int n2 = this.in.readInt();
        int n3 = 0;
        while (n3 < n2) {
            RemoteClass remoteClass = (RemoteClass)this.readValue(this.in);
            ++n3;
        }
        this.systemThreadGroup = (RemoteThreadGroup)this.readValue(this.in);
        this.setVerbose(bl);
        this.closed = false;
        this.closing = false;
    }

    private void displayNativeOutput(final BufferedReader bufferedReader) {
        Thread thread = new Thread("output reader"){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    while (true) {
                        String string;
                        if ((string = bufferedReader.readLine()) == null) {
                            return;
                        }
                        try {
                            RemoteAgent.this.printToClientConsole(string + "\n");
                        }
                        catch (Exception exception) {
                            System.out.println(string);
                        }
                    }
                }
                catch (IOException iOException) {
                    RemoteAgent.this.error("Failed reading output of child java interpreter.");
                }
            }
        };
        thread.setPriority(9);
        thread.start();
    }

    static boolean hasWhitespace(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (Character.isWhitespace(string.charAt(n2))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static String processClasspath(String string) {
        String string2 = System.getProperty("env.class.path");
        if (string2 != null && string.indexOf("-classpath ") == -1) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(" -classpath ");
            if (RemoteAgent.hasWhitespace(string2)) {
                string2 = '\"' + string2 + '\"';
            }
            stringBuffer.append(string2);
            return stringBuffer.toString();
        }
        return string;
    }

    private static String processBootClasspath(String string) {
        String string2 = System.getProperty("application.home");
        if (string2 == null) {
            return string;
        }
        if (RemoteAgent.hasWhitespace(string2)) {
            string2 = '\"' + string2 + '\"';
        }
        String string3 = string2 + File.separator + "lib" + File.separator + "tools.jar";
        StringBuffer stringBuffer = new StringBuffer(string);
        String string4 = new String("-Xbootclasspath/a");
        String string5 = null;
        int n = string.indexOf("-Xbootclasspath");
        if (n != -1) {
            int n2 = string.indexOf(58, n);
            if (n2 != -1) {
                int n3 = n2 + 1;
                int n4 = string.indexOf(32, n3);
                if (n4 == -1) {
                    n4 = string.length();
                }
                string4 = string.substring(n, n2);
                string5 = string.substring(n3, n4);
                stringBuffer = new StringBuffer(string.substring(0, n) + string.substring(n4));
            } else {
                return string;
            }
        }
        stringBuffer.append(" ");
        stringBuffer.append(string4);
        stringBuffer.append(":");
        stringBuffer.append(string3);
        if (string5 != null) {
            stringBuffer.append(File.pathSeparator + string5);
        }
        stringBuffer.append(" ");
        return stringBuffer.toString();
    }

    RemoteAgent(String string, String string2, String string3, DebuggerCallback debuggerCallback, boolean bl) throws Exception {
        Object object;
        this.verbose = bl;
        if (string.equals("127.0.0.1") && string2 == null) {
            object = File.separator;
            string3 = RemoteAgent.processClasspath(string3);
            string3 = RemoteAgent.processBootClasspath(string3);
            String string4 = System.getProperty("java.home") + (String)object + "bin" + (String)object + "java";
            if (RemoteAgent.hasWhitespace(string4)) {
                string4 = '\"' + string4 + '\"';
            }
            String string5 = new String(string4 + " -classic -Xdebug -Djava.compiler=NONE " + string3 + " sun.tools.agent.EmptyApp");
            this.message("starting child: " + string5);
            Process process = Runtime.getRuntime().exec(string5);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            String string6 = bufferedReader.readLine();
            if (string6 == null) {
                this.error("Failed to exec a child java interpreter with this command line: " + string5);
                System.exit(1);
            }
            string2 = string6.substring(string6.indexOf("=") + 1);
            this.message("password returned: " + string2);
            this.closeRemoteInterpreter = true;
            this.displayNativeOutput(bufferedReader);
            this.displayNativeOutput(bufferedReader2);
        }
        this.client = debuggerCallback;
        this.socket = new Socket(string, this.readPassword(string2));
        object = new DataInputStream(new BufferedInputStream(new Socket(string, this.getDebugPort()).getInputStream()));
        this.debugIn = new AgentIn(this, (DataInputStream)object, debuggerCallback, bl);
        this.debugInThread = new Thread((Runnable)this.debugIn, "Agent input");
        this.debugInThread.start();
        this.in = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
        this.out = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
        this.message("connected");
        this.initSession(bl);
    }

    int getDebugPort() {
        return this.socket.getPort();
    }

    InputStream getSourceFile(String string, String string2) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(59);
            this.out.writeUTF(string2);
            this.out.writeUTF(string);
            try {
                this.getReply(59);
            }
            catch (Exception exception) {
                InputStream inputStream = null;
                return inputStream;
            }
            int n = this.in.readInt();
            if (n == -1) {
                InputStream inputStream = null;
                return inputStream;
            }
            this.message("getSourceFile: allocating " + n + " bytes.");
            byte[] byArray = new byte[n];
            try {
                this.in.readFully(byArray);
            }
            catch (IOException iOException) {
                this.error("unable to read " + string2);
                InputStream inputStream = null;
                return inputStream;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            return byteArrayInputStream;
        }
    }

    String objectToString(int n) {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            try {
                this.out.write(60);
                this.out.writeInt(n);
                this.getReply(60);
                String string = this.in.readUTF();
                return string;
            }
            catch (Exception exception) {
                String string = "<communication error>";
                return string;
            }
        }
    }

    void close() {
        this.message("close(" + this.closeRemoteInterpreter + ")");
        this.closing = true;
        try {
            if (this.closeRemoteInterpreter) {
                this.debugIn.quit();
                DataOutputStream dataOutputStream = this.out;
                synchronized (dataOutputStream) {
                    this.out.write(58);
                    this.getReply(58);
                }
            } else {
                this.gc(new RemoteObject[0]);
                this.debugIn.quit();
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.closed = true;
    }

    void handleRemoteClose() {
        this.closing = true;
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.closed = true;
    }

    RemoteObject get(Integer n) {
        return (RemoteObject)this.objects.get(n);
    }

    private void put(Integer n, RemoteObject remoteObject) {
        this.objects.put(n, remoteObject);
    }

    RemoteValue readValue(DataInputStream dataInputStream) throws Exception {
        int n = dataInputStream.readInt();
        switch (n) {
            case 17: {
                RemoteObject remoteObject;
                int n2 = dataInputStream.readInt();
                if (n2 == 0) {
                    return null;
                }
                Integer n3 = new Integer(n2);
                RemoteClass remoteClass = (RemoteClass)this.get(n3);
                if (remoteClass == null) {
                    remoteClass = new RemoteClass(this, n2);
                    this.put(n3, remoteClass);
                }
                if ((remoteObject = this.get(n3 = new Integer(n2 = dataInputStream.readInt()))) == null) {
                    remoteObject = new RemoteObject(this, n2, remoteClass);
                    this.put(n3, remoteObject);
                }
                return remoteObject;
            }
            case 16: {
                int n4 = dataInputStream.readInt();
                Integer n5 = new Integer(n4);
                RemoteClass remoteClass = (RemoteClass)this.get(n5);
                if (remoteClass == null) {
                    remoteClass = new RemoteClass(this, n4);
                    this.put(n5, remoteClass);
                }
                return remoteClass;
            }
            case 19: {
                RemoteThread remoteThread;
                int n6 = dataInputStream.readInt();
                Integer n7 = new Integer(n6);
                RemoteClass remoteClass = (RemoteClass)this.get(n7);
                if (remoteClass == null) {
                    remoteClass = new RemoteClass(this, n6);
                    this.put(n7, remoteClass);
                }
                if ((remoteThread = (RemoteThread)this.get(n7 = new Integer(n6 = dataInputStream.readInt()))) == null) {
                    remoteThread = new RemoteThread(this, n6, remoteClass);
                    this.put(n7, remoteThread);
                }
                return remoteThread;
            }
            case 15: {
                RemoteThreadGroup remoteThreadGroup;
                int n8 = dataInputStream.readInt();
                Integer n9 = new Integer(n8);
                RemoteClass remoteClass = (RemoteClass)this.get(n9);
                if (remoteClass == null) {
                    remoteClass = new RemoteClass(this, n8);
                    this.put(n9, remoteClass);
                }
                if ((remoteThreadGroup = (RemoteThreadGroup)this.get(n9 = new Integer(n8 = dataInputStream.readInt()))) == null) {
                    remoteThreadGroup = new RemoteThreadGroup(this, n8, remoteClass);
                    this.put(n9, remoteThreadGroup);
                }
                return remoteThreadGroup;
            }
            case 18: {
                int n10 = dataInputStream.readInt();
                Integer n11 = new Integer(n10);
                RemoteString remoteString = (RemoteString)this.get(n11);
                if (remoteString == null) {
                    remoteString = new RemoteString(this, n10);
                    this.put(n11, remoteString);
                }
                return remoteString;
            }
            case 9: {
                int n12 = dataInputStream.readInt();
                if (n12 == 0) {
                    return null;
                }
                Integer n13 = new Integer(n12);
                RemoteClass remoteClass = (RemoteClass)this.get(n13);
                if (remoteClass == null) {
                    remoteClass = new RemoteClass(this, n12);
                    this.put(n13, remoteClass);
                }
                n12 = dataInputStream.readInt();
                n13 = new Integer(n12);
                int n14 = dataInputStream.readInt();
                RemoteArray remoteArray = (RemoteArray)this.get(n13);
                if (remoteArray == null) {
                    remoteArray = new RemoteArray(this, n12, remoteClass, n14);
                    this.put(n13, remoteArray);
                }
                return remoteArray;
            }
            case 0: {
                return new RemoteBoolean(dataInputStream.readBoolean());
            }
            case 1: {
                return new RemoteByte(dataInputStream.readByte());
            }
            case 2: {
                return new RemoteChar(dataInputStream.readChar());
            }
            case 3: {
                return new RemoteShort(dataInputStream.readShort());
            }
            case 4: {
                return new RemoteInt(dataInputStream.readInt());
            }
            case 5: {
                return new RemoteLong(dataInputStream.readLong());
            }
            case 6: {
                return new RemoteFloat(dataInputStream.readFloat());
            }
            case 7: {
                return new RemoteDouble(dataInputStream.readDouble());
            }
        }
        this.error("invalid type code: " + n);
        Thread.dumpStack();
        return null;
    }

    private void getReply(int n) throws Exception {
        if (this.closed) {
            throw new NoSessionException();
        }
        this.out.flush();
        while (true) {
            int n2 = 0;
            try {
                n2 = this.in.readInt();
            }
            catch (EOFException eOFException) {
                if (!this.closing) {
                    this.error("unexpected eof");
                }
                return;
            }
            catch (IOException iOException) {
                if (this.closing) {
                    return;
                }
                throw iOException;
            }
            if (n2 == -2) {
                Exception exception = new Exception(this.in.readUTF());
                throw exception;
            }
            if (n2 == n) break;
            this.error("unexpected reply: wanted " + n + ", got " + n2);
        }
    }

    RemoteClass[] listClasses() throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(49);
            this.getReply(49);
            int n = this.in.readInt();
            this.message("reading " + n + " classes...");
            RemoteClass[] remoteClassArray = new RemoteClass[n];
            int n2 = 0;
            while (n2 < n) {
                remoteClassArray[n2] = (RemoteClass)this.readValue(this.in);
                ++n2;
            }
            RemoteClass[] remoteClassArray2 = remoteClassArray;
            return remoteClassArray2;
        }
    }

    RemoteClass findClass(String string) throws Exception {
        RemoteClass[] remoteClassArray = this.listClasses();
        int n = 0;
        while (n < remoteClassArray.length) {
            String string2 = remoteClassArray[n].getName();
            if (string.equals(string2)) {
                return remoteClassArray[n];
            }
            int n2 = string2.lastIndexOf(".");
            if (n2 >= 0 && string2.length() > n2) {
                string2 = string2.substring(n2 + 1);
            }
            if (string.equals(string2)) {
                return remoteClassArray[n];
            }
            ++n;
        }
        return this.getClassByName(string);
    }

    RemoteThreadGroup[] listThreadGroups(RemoteThreadGroup remoteThreadGroup) throws Exception {
        RemoteThreadGroup[] remoteThreadGroupArray = null;
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(47);
            this.out.writeInt(remoteThreadGroup == null ? 0 : remoteThreadGroup.getId());
            this.getReply(47);
            int n = this.in.readInt();
            remoteThreadGroupArray = new RemoteThreadGroup[n];
            this.message("listThreadGroups: " + n + " groups");
            int n2 = 0;
            while (n2 < n) {
                remoteThreadGroupArray[n2] = (RemoteThreadGroup)this.readValue(this.in);
                ++n2;
            }
        }
        return remoteThreadGroupArray;
    }

    RemoteThread[] listThreads(RemoteThreadGroup remoteThreadGroup, boolean bl) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(25);
            this.out.writeInt(remoteThreadGroup == null ? this.systemThreadGroup.getId() : remoteThreadGroup.getId());
            this.out.writeBoolean(bl);
            this.getReply(25);
            int n = this.in.readInt();
            RemoteThread[] remoteThreadArray = new RemoteThread[n];
            int n2 = 0;
            while (n2 < n) {
                remoteThreadArray[n2] = (RemoteThread)this.readValue(this.in);
                ++n2;
            }
            RemoteThread[] remoteThreadArray2 = remoteThreadArray;
            return remoteThreadArray2;
        }
    }

    void suspendThread(int n) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(27);
            this.out.writeInt(n);
            this.getReply(27);
        }
    }

    void resumeThread(int n) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(28);
            this.out.writeInt(n);
            this.getReply(28);
        }
    }

    void resumeLastSuspendedThreads() throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(29);
            this.getReply(29);
        }
    }

    void suspendAllThreads() throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(30);
            this.getReply(30);
        }
    }

    RemoteStackFrame[] dumpStack(RemoteThread remoteThread) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            Object object;
            this.out.write(32);
            this.out.writeInt(remoteThread.getId());
            this.getReply(32);
            int n = this.in.readInt();
            RemoteStackFrame[] remoteStackFrameArray = new RemoteStackFrame[n];
            int n2 = 0;
            while (n2 < n) {
                object = (RemoteObject)this.readValue(this.in);
                remoteStackFrameArray[n2] = new RemoteStackFrame((RemoteObject)object, remoteThread, n2, this);
                remoteStackFrameArray[n2].className = this.in.readUTF();
                remoteStackFrameArray[n2].methodName = this.in.readUTF();
                remoteStackFrameArray[n2].methodSignature = this.in.readUTF();
                remoteStackFrameArray[n2].lineno = this.in.readInt();
                remoteStackFrameArray[n2].bci = this.in.readInt();
                remoteStackFrameArray[n2].setRemoteClass((RemoteClass)this.readValue(this.in));
                int n3 = this.in.readInt();
                remoteStackFrameArray[n2].localVariables = new LocalVariable[n3];
                int n4 = 0;
                while (n4 < n3) {
                    LocalVariable localVariable = new LocalVariable();
                    localVariable.slot = this.in.readInt();
                    localVariable.name = this.in.readUTF();
                    localVariable.signature = this.in.readUTF();
                    localVariable.methodArgument = this.in.readBoolean();
                    this.message("lvar " + n4 + ": slot=" + localVariable.slot + ", name=" + localVariable.name + ", sig=" + localVariable.signature + ", arg=" + localVariable.methodArgument);
                    remoteStackFrameArray[n2].localVariables[n4] = localVariable;
                    ++n4;
                }
                ++n2;
            }
            object = remoteStackFrameArray;
            return object;
        }
    }

    void stopThread(int n) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(56);
            this.out.writeInt(n);
            this.getReply(56);
        }
    }

    void stopThreadGroup(int n) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(57);
            this.out.writeInt(n);
            this.getReply(57);
        }
    }

    void getClassInfo(RemoteClass remoteClass) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(20);
            this.out.writeInt(remoteClass.id);
            this.getReply(20);
            remoteClass.name = this.in.readUTF();
            remoteClass.sourceName = this.in.readUTF();
            remoteClass.intf = this.in.readInt() != 0;
            remoteClass.superclass = (RemoteClass)this.readValue(this.in);
            remoteClass.loader = (RemoteObject)this.readValue(this.in);
            remoteClass.interfaces = new RemoteClass[this.in.readInt()];
            int n = 0;
            while (n < remoteClass.interfaces.length) {
                remoteClass.interfaces[n] = (RemoteClass)this.readValue(this.in);
                ++n;
            }
        }
    }

    RemoteClass getClassByName(String string) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(22);
            this.out.writeUTF(string);
            this.getReply(22);
            RemoteClass remoteClass = (RemoteClass)this.readValue(this.in);
            return remoteClass;
        }
    }

    void getThreadGroupInfo(RemoteThreadGroup remoteThreadGroup) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(48);
            this.out.writeInt(remoteThreadGroup.id);
            this.getReply(48);
            remoteThreadGroup.parent = (RemoteThreadGroup)this.readValue(this.in);
            remoteThreadGroup.name = this.in.readUTF();
            remoteThreadGroup.maxPriority = this.in.readInt();
            remoteThreadGroup.daemon = this.in.readBoolean();
        }
    }

    String getThreadName(int n) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(21);
            this.out.writeInt(n);
            this.getReply(21);
            String string = this.in.readUTF();
            return string;
        }
    }

    int getThreadStatus(int n) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(31);
            this.out.writeInt(n);
            this.getReply(31);
            int n2 = this.in.readInt();
            return n2;
        }
    }

    void gc(RemoteObject[] remoteObjectArray) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            RemoteObject remoteObject;
            Object object;
            this.out.write(23);
            int n = 0;
            int n2 = 0;
            while (n2 < remoteObjectArray.length) {
                if (remoteObjectArray[n2] != null) {
                    ++n;
                }
                ++n2;
            }
            this.out.writeInt(n);
            int n3 = 0;
            while (n3 < remoteObjectArray.length) {
                if (remoteObjectArray[n3] != null) {
                    this.out.writeInt(remoteObjectArray[n3].id);
                }
                ++n3;
            }
            this.getReply(23);
            this.out.write(24);
            this.getReply(24);
            Hashtable hashtable = this.objects;
            this.objects = new Hashtable();
            int n4 = this.in.readInt();
            while (n4 != 0) {
                object = new Integer(n4);
                remoteObject = (RemoteObject)hashtable.remove(object);
                this.objects.put(new Integer(n4), remoteObject);
                n4 = this.in.readInt();
            }
            object = hashtable.elements();
            while (object.hasMoreElements()) {
                remoteObject = (RemoteObject)object.nextElement();
                remoteObject.invalidate();
            }
        }
    }

    void trace(boolean bl) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(34);
            this.out.writeInt(3);
            this.out.writeInt(bl ? 1 : 0);
            this.getReply(34);
        }
    }

    void itrace(boolean bl) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(34);
            this.out.writeInt(4);
            this.out.writeInt(bl ? 1 : 0);
            this.getReply(34);
        }
    }

    int totalMemory() throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(34);
            this.out.writeInt(1);
            this.getReply(34);
            int n = this.in.readInt();
            return n;
        }
    }

    int freeMemory() throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(34);
            this.out.writeInt(2);
            this.getReply(34);
            int n = this.in.readInt();
            return n;
        }
    }

    RemoteThreadGroup run(int n, String[] stringArray) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(26);
            this.out.write(n);
            int n2 = 0;
            while (n2 < n) {
                this.out.writeUTF(stringArray[n2]);
                ++n2;
            }
            this.getReply(26);
            RemoteThreadGroup remoteThreadGroup = (RemoteThreadGroup)this.readValue(this.in);
            return remoteThreadGroup;
        }
    }

    RemoteField[] getFields(int n) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(35);
            this.out.writeInt(n);
            this.getReply(35);
            int n2 = this.in.readInt();
            RemoteField[] remoteFieldArray = new RemoteField[n2];
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this.in.readInt();
                String string = this.in.readUTF();
                String string2 = this.in.readUTF();
                short s = this.in.readShort();
                RemoteClass remoteClass = (RemoteClass)this.readValue(this.in);
                remoteFieldArray[n3] = new RemoteField(this, n4, string, string2, s, remoteClass);
                ++n3;
            }
            RemoteField[] remoteFieldArray2 = remoteFieldArray;
            return remoteFieldArray2;
        }
    }

    RemoteValue[] getElements(int n, int n2, int n3, int n4) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(40);
            this.out.writeInt(n);
            this.out.writeInt(n2);
            this.out.writeInt(n3);
            this.out.writeInt(n4);
            this.getReply(40);
            RemoteValue[] remoteValueArray = new RemoteValue[this.in.readInt()];
            int n5 = 0;
            while (n5 < remoteValueArray.length) {
                remoteValueArray[n5] = this.readValue(this.in);
                ++n5;
            }
            RemoteValue[] remoteValueArray2 = remoteValueArray;
            return remoteValueArray2;
        }
    }

    RemoteField[] getMethods(int n) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(36);
            this.out.writeInt(n);
            this.getReply(36);
            int n2 = this.in.readInt();
            this.message("getting (" + n2 + ") methods");
            RemoteField[] remoteFieldArray = new RemoteField[n2];
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this.in.readInt();
                String string = this.in.readUTF();
                String string2 = this.in.readUTF();
                short s = this.in.readShort();
                this.message("Method1 " + string + " - " + string2 + ", slot: " + n4);
                RemoteValue remoteValue = this.readValue(this.in);
                RemoteClass remoteClass = (RemoteClass)remoteValue;
                remoteFieldArray[n3] = new RemoteField(this, n4, string, string2, s, null);
                this.message("Method2 " + string + " - " + string2 + ", slot: " + n4 + ", vars: " + remoteFieldArray);
                ++n3;
            }
            RemoteField[] remoteFieldArray2 = remoteFieldArray;
            return remoteFieldArray2;
        }
    }

    int getMethodLineNumber(int n, int n2) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(72);
            this.out.writeInt(n);
            this.out.writeInt(n2);
            this.getReply(72);
            int n3 = this.in.readInt();
            return n3;
        }
    }

    RemoteValue getSlotValue(int n, int n2) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(39);
            this.out.writeInt(n);
            this.out.writeInt(n2);
            this.getReply(39);
            RemoteValue remoteValue = this.readValue(this.in);
            if (remoteValue != null && remoteValue.isObject() && remoteValue.getClass().getName().equals("java.lang.ArrayIndexOutOfBoundsException")) {
                throw new ArrayIndexOutOfBoundsException("invalid slot index " + n2);
            }
            RemoteValue remoteValue2 = remoteValue;
            return remoteValue2;
        }
    }

    RemoteValue getStackValue(int n, int n2, int n3, char c) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(50);
            this.out.writeInt(n);
            this.out.writeInt(n2);
            this.out.writeInt(n3);
            this.out.writeChar(c);
            this.getReply(50);
            RemoteValue remoteValue = this.readValue(this.in);
            return remoteValue;
        }
    }

    void setSlotValue(int n, int n2, int n3) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(68);
            this.out.writeInt(n);
            this.out.writeInt(n2);
            this.out.writeInt(4);
            this.out.writeInt(n3);
            this.getReply(68);
        }
    }

    void setSlotValue(int n, int n2, boolean bl) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(68);
            this.out.writeInt(n);
            this.out.writeInt(n2);
            this.out.writeInt(0);
            this.out.writeBoolean(bl);
            this.getReply(68);
        }
    }

    void setSlotValue(int n, int n2, char c) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(68);
            this.out.writeInt(n);
            this.out.writeInt(n2);
            this.out.writeInt(2);
            this.out.writeChar(c);
            this.getReply(68);
        }
    }

    void setSlotValue(int n, int n2, long l) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(68);
            this.out.writeInt(n);
            this.out.writeInt(n2);
            this.out.writeInt(5);
            this.out.writeLong(l);
            this.getReply(68);
        }
    }

    void setSlotValue(int n, int n2, float f) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(68);
            this.out.writeInt(n);
            this.out.writeInt(n2);
            this.out.writeInt(6);
            this.out.writeFloat(f);
            this.getReply(68);
        }
    }

    void setSlotValue(int n, int n2, double d) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(68);
            this.out.writeInt(n);
            this.out.writeInt(n2);
            this.out.writeInt(7);
            this.out.writeDouble(d);
            this.getReply(68);
        }
    }

    void setStackValue(int n, int n2, int n3, int n4) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(69);
            this.out.writeInt(n);
            this.out.writeInt(n2);
            this.out.writeInt(n3);
            this.out.writeInt(4);
            this.out.writeInt(n4);
            this.getReply(69);
        }
    }

    void setStackValue(int n, int n2, int n3, boolean bl) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(69);
            this.out.writeInt(n);
            this.out.writeInt(n2);
            this.out.writeInt(n3);
            this.out.writeInt(0);
            this.out.writeBoolean(bl);
            this.getReply(69);
        }
    }

    void setStackValue(int n, int n2, int n3, char c) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(69);
            this.out.writeInt(n);
            this.out.writeInt(n2);
            this.out.writeInt(n3);
            this.out.writeInt(4);
            this.out.writeInt(c);
            this.getReply(69);
        }
    }

    void setStackValue(int n, int n2, int n3, long l) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(69);
            this.out.writeInt(n);
            this.out.writeInt(n2);
            this.out.writeInt(n3);
            this.out.writeInt(5);
            this.out.writeLong(l);
            this.getReply(69);
        }
    }

    void setStackValue(int n, int n2, int n3, float f) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(69);
            this.out.writeInt(n);
            this.out.writeInt(n2);
            this.out.writeInt(n3);
            this.out.writeInt(7);
            this.out.writeDouble(f);
            this.getReply(69);
        }
    }

    void setStackValue(int n, int n2, int n3, double d) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(69);
            this.out.writeInt(n);
            this.out.writeInt(n2);
            this.out.writeInt(n3);
            this.out.writeInt(7);
            this.out.writeDouble(d);
            this.getReply(69);
        }
    }

    String setBreakpointLine(RemoteClass remoteClass, int n) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(41);
            this.out.writeInt(remoteClass.getId());
            this.out.writeInt(n);
            this.getReply(41);
            String string = this.in.readUTF();
            return string;
        }
    }

    String setBreakpointMethod(RemoteClass remoteClass, RemoteField remoteField) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(42);
            this.out.writeInt(remoteClass.getId());
            this.out.writeInt(remoteField.slot);
            this.getReply(42);
            String string = this.in.readUTF();
            return string;
        }
    }

    String[] listBreakpoints() throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(65);
            this.getReply(65);
            String[] stringArray = new String[this.in.readInt()];
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = this.in.readUTF();
                ++n;
            }
            String[] stringArray2 = stringArray;
            return stringArray2;
        }
    }

    String clearBreakpoint(RemoteClass remoteClass, int n) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.message("clearing bkpt at " + remoteClass.getName() + ", pc " + n);
            this.out.write(43);
            this.out.writeInt(remoteClass.getId());
            this.out.writeInt(n);
            this.getReply(43);
            String string = this.in.readUTF();
            return string;
        }
    }

    String clearBreakpointLine(RemoteClass remoteClass, int n) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.message("clearing bkpt at " + remoteClass.getName() + ":" + n);
            this.out.write(44);
            this.out.writeInt(remoteClass.getId());
            this.out.writeInt(n);
            this.getReply(44);
            String string = this.in.readUTF();
            return string;
        }
    }

    String clearBreakpointMethod(RemoteClass remoteClass, RemoteField remoteField) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.message("clearing bkpt at " + remoteClass.getName() + ":" + remoteField.getName());
            this.out.write(45);
            this.out.writeInt(remoteClass.getId());
            this.out.writeInt(remoteField.slot);
            this.getReply(45);
            String string = this.in.readUTF();
            return string;
        }
    }

    void catchExceptionClass(RemoteClass remoteClass) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(53);
            this.out.writeInt(remoteClass.getId());
            this.getReply(53);
        }
    }

    void ignoreExceptionClass(RemoteClass remoteClass) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(54);
            this.out.writeInt(remoteClass.getId());
            this.getReply(54);
        }
    }

    String[] getExceptionCatchList() throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            Object object;
            this.out.write(55);
            this.getReply(55);
            int n = this.in.readInt();
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                object = (RemoteClass)this.readValue(this.in);
                stringArray[n2] = ((RemoteClass)object).getName();
                ++n2;
            }
            object = stringArray;
            return object;
        }
    }

    String getSourcePath() throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(61);
            this.getReply(61);
            String string = this.in.readUTF();
            return string;
        }
    }

    void setSourcePath(String string) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(62);
            this.out.writeUTF(string);
            this.getReply(62);
        }
    }

    void stepThread(int n, boolean bl) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(63);
            this.out.writeInt(n);
            this.out.writeBoolean(bl);
            this.getReply(63);
        }
    }

    void stepNextThread(int n) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(64);
            this.out.writeInt(n);
            this.getReply(64);
        }
    }

    void stepOutThread(int n) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(73);
            this.out.writeInt(n);
            this.getReply(73);
        }
    }

    private void setVerbose(boolean bl) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(51);
            this.out.writeBoolean(bl);
            this.getReply(51);
        }
    }

    void objectFinalize(int n) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(70);
            this.out.writeInt(n);
            this.getReply(70);
        }
    }

    int[] getLineNumbers(RemoteClass remoteClass) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(71);
            this.out.writeInt(remoteClass.getId());
            this.getReply(71);
            int n = this.in.readInt();
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = this.in.readInt();
                ++n2;
            }
            int[] nArray2 = nArray;
            return nArray2;
        }
    }

    synchronized void printToClientConsole(String string) throws Exception {
        this.client.printToConsole(string);
    }

    void error(String string) {
        try {
            this.printToClientConsole("[Internal debugger error: " + string + "]\n");
        }
        catch (Exception exception) {
            System.out.println("[Internal debugger error: " + string + "]");
        }
        throw new InternalError();
    }

    void message(String string) {
        if (this.verbose) {
            try {
                this.printToClientConsole("[debugger: " + string + "]\n");
            }
            catch (Exception exception) {
                System.out.println("[debugger: " + string + "]");
            }
        }
    }

    void resetStacks() {
        Enumeration enumeration = this.objects.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (!(v instanceof RemoteThread)) continue;
            ((RemoteThread)v).resetStack();
        }
    }
}

