/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.agent;

import java.util.ArrayList;
import java.util.List;
import sun.tools.agent.AbsentInformationException;
import sun.tools.agent.CachedClass;
import sun.tools.agent.CachedMethod;
import sun.tools.agent.Location;

class StackFrame {
    private long frameID;
    private Class clazz;
    private long methodID;
    private int bci;
    private boolean isNative;
    private CachedMethod method;
    private Location location;
    List localVariables;

    StackFrame() {
    }

    static native int frameCount(Thread var0);

    static native void fillInFrameData(Thread var0, StackFrame[] var1);

    static StackFrame[] getStackFrames(Thread thread) {
        StackFrame[] stackFrameArray = new StackFrame[StackFrame.frameCount(thread)];
        int n = 0;
        while (n < stackFrameArray.length) {
            stackFrameArray[n] = new StackFrame();
            ++n;
        }
        StackFrame.fillInFrameData(thread, stackFrameArray);
        return stackFrameArray;
    }

    CachedMethod getMethod() {
        if (this.method == null) {
            this.method = CachedClass.getCachedClass(this.clazz).getMethod(this.methodID);
        }
        return this.method;
    }

    Location location() throws AbsentInformationException {
        if (this.location == null) {
            this.location = this.getMethod().bciToLocation(this.bci);
        }
        return this.location;
    }

    int getLinenumber() {
        try {
            Location location = this.location();
            if (location == null) {
                return -1;
            }
            return location.line;
        }
        catch (AbsentInformationException absentInformationException) {
            return -1;
        }
    }

    Class getRealClass() {
        return this.clazz;
    }

    String getClassName() {
        return this.clazz.getName();
    }

    String getMethodName() {
        return this.getMethod().getName();
    }

    String getMethodSignature() {
        return this.getMethod().getTypeSignature();
    }

    int getBCI() {
        return this.bci;
    }

    boolean isNative() {
        return this.isNative;
    }

    List getLocalVariables() {
        if (this.localVariables == null) {
            try {
                this.localVariables = this.getMethod().getVisibleLocalVariables(this.bci);
            }
            catch (AbsentInformationException absentInformationException) {
                this.localVariables = new ArrayList(0);
            }
        }
        return this.localVariables;
    }

    public String toString() {
        String string = this.clazz.getName();
        String string2 = this.getMethod().getName();
        if (this.isNative) {
            return string + "." + string2 + " (native method)";
        }
        try {
            this.location();
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        if (this.location == null || this.location.line == -1) {
            return string + "." + string2 + " (offset " + this.bci + ")";
        }
        int n = string.lastIndexOf(46);
        String string3 = n >= 0 ? string.substring(n + 1) : string;
        return string + "." + string2 + " (" + string3 + ":" + this.getLinenumber() + ")";
    }
}

