/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.agent;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sun.tools.agent.AbsentInformationException;
import sun.tools.agent.CachedClass;
import sun.tools.agent.CachedLocalVariable;
import sun.tools.agent.Location;

class CachedMethod {
    final long methodID;
    final CachedClass cachedClass;
    final String name;
    final String signature;
    private byte[] codeBytes;
    private int endBCI;
    private LineEntry[] lineArray;
    private List variableTable;
    private int argumentCount = -1;

    protected static native String getMethodName(Class var0, long var1);

    protected static native String getMethodSignature(Class var0, long var1);

    protected static native long getMethodID(Class var0, String var1, String var2);

    protected static native long getStaticMethodID(Class var0, String var1, String var2);

    protected static native byte[] getCode(Class var0, long var1);

    protected static native LineEntry[] getLineTable(Class var0, long var1) throws AbsentInformationException;

    protected static native long getEndLocation(Class var0, long var1);

    protected static native VariableEntry[] getVariableTable(Class var0, long var1) throws AbsentInformationException;

    protected static native Class getDeclaringClass(Class var0, long var1);

    protected static native int getModifiers(Class var0, long var1) throws AbsentInformationException;

    protected static native int getArgumentsSize(Class var0, long var1) throws AbsentInformationException;

    private CachedMethod(CachedClass cachedClass, long l, String string, String string2) {
        this.methodID = l;
        this.cachedClass = cachedClass;
        this.name = string;
        this.signature = string2;
    }

    private void fetchCode() {
        if (this.codeBytes == null) {
            this.codeBytes = CachedMethod.getCode(this.getRealClass(), this.methodID);
        }
    }

    private void fetchLineTable() throws AbsentInformationException {
        if (this.lineArray == null) {
            this.lineArray = CachedMethod.getLineTable(this.getRealClass(), this.methodID);
            this.endBCI = (int)CachedMethod.getEndLocation(this.getRealClass(), this.methodID);
        }
    }

    private void fetchVariableTable() throws AbsentInformationException {
        if (this.variableTable == null) {
            VariableEntry[] variableEntryArray = CachedMethod.getVariableTable(this.getRealClass(), this.methodID);
            this.variableTable = new ArrayList(variableEntryArray.length);
            int n = 0;
            while (n < variableEntryArray.length) {
                VariableEntry variableEntry = variableEntryArray[n];
                CachedLocalVariable cachedLocalVariable = new CachedLocalVariable(this, variableEntry.name, variableEntry.signature, (int)variableEntry.startLocation, variableEntry.scopeLength, variableEntry.slot);
                this.variableTable.add(cachedLocalVariable);
                ++n;
            }
        }
    }

    static CachedMethod getMethod(CachedClass cachedClass, long l) {
        CachedMethod cachedMethod = cachedClass.findMethod(l);
        if (cachedMethod == null) {
            String string = CachedMethod.getMethodName(cachedClass.getRealClass(), l);
            String string2 = CachedMethod.getMethodSignature(cachedClass.getRealClass(), l);
            cachedMethod = new CachedMethod(cachedClass, l, string, string2);
            cachedClass.cacheMethod(l, cachedMethod);
        }
        return cachedMethod;
    }

    protected static long getStaticOrInstanceMethodID(CachedClass cachedClass, String string, String string2) {
        long l;
        try {
            l = CachedMethod.getMethodID(cachedClass.getRealClass(), string, string2);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            l = CachedMethod.getStaticMethodID(cachedClass.getRealClass(), string, string2);
        }
        return l;
    }

    static CachedMethod getMethod(CachedClass cachedClass, String string, String string2) {
        long l = CachedMethod.getStaticOrInstanceMethodID(cachedClass, string, string2);
        return CachedMethod.getMethod(cachedClass, l);
    }

    public int byteAt(int n) throws AbsentInformationException {
        this.fetchCode();
        return this.codeBytes[n] & 0xFF;
    }

    public int shortAt(int n) throws AbsentInformationException {
        this.fetchCode();
        return (this.codeBytes[n] & 0xFF) << 8 | this.codeBytes[n + 1] & 0xFF;
    }

    public int intAt(int n) throws AbsentInformationException {
        this.fetchCode();
        return this.codeBytes[n] << 24 | (this.codeBytes[n + 1] & 0xFF) << 16 | (this.codeBytes[n + 2] & 0xFF) << 8 | this.codeBytes[n + 3] & 0xFF;
    }

    Location lineToLocation(int n) throws AbsentInformationException {
        this.fetchLineTable();
        Location location = null;
        int n2 = 0;
        while (n2 < this.lineArray.length) {
            LineEntry lineEntry = this.lineArray[n2];
            if (lineEntry.line == n) {
                int n3 = this.endBCI;
                if (n2 + 1 < this.lineArray.length) {
                    n3 = (int)this.lineArray[n2 + 1].startLocation - 1;
                }
                location = new Location(this, n, (int)lineEntry.startLocation, n3);
                break;
            }
            ++n2;
        }
        return location;
    }

    Location bciToLocation(int n) throws AbsentInformationException {
        this.fetchLineTable();
        if (n > this.endBCI) {
            return null;
        }
        int n2 = -1;
        int n3 = this.lineArray.length - 1;
        while (n3 >= 0) {
            LineEntry lineEntry = this.lineArray[n3];
            if ((long)n >= lineEntry.startLocation) {
                n2 = lineEntry.line;
                break;
            }
            --n3;
        }
        if (n2 == -1) {
            return null;
        }
        return new Location(this, n2, n, n + 1);
    }

    Location location() throws AbsentInformationException {
        this.fetchLineTable();
        LineEntry lineEntry = this.lineArray[0];
        int n = lineEntry.line;
        int n2 = 1;
        while (n2 < this.lineArray.length) {
            int n3 = this.lineArray[n2].line;
            if (n3 < n) {
                n = n3;
            }
            ++n2;
        }
        return new Location(this, n, (int)lineEntry.startLocation, this.endBCI);
    }

    int getLinenumber() throws AbsentInformationException {
        return this.location().line;
    }

    int[] getLinenumbers() throws AbsentInformationException {
        this.fetchLineTable();
        int[] nArray = new int[this.lineArray.length];
        int n = 0;
        while (n < this.lineArray.length) {
            nArray[n] = this.lineArray[n].line;
            ++n;
        }
        return nArray;
    }

    int getLinenumberCount() throws AbsentInformationException {
        this.fetchLineTable();
        return this.lineArray.length;
    }

    String getName() {
        return this.name;
    }

    Class getRealClass() {
        return this.cachedClass.getRealClass();
    }

    CachedClass getCachedClass() {
        return this.cachedClass;
    }

    public String getTypeSignature() {
        return this.signature;
    }

    CachedClass getDefiningClass() {
        Class clazz = CachedMethod.getDeclaringClass(this.getRealClass(), this.methodID);
        return CachedClass.getCachedClass(clazz);
    }

    int getModifiers() throws AbsentInformationException {
        return CachedMethod.getModifiers(this.getRealClass(), this.methodID);
    }

    List getVisibleLocalVariables(int n) throws AbsentInformationException {
        this.fetchVariableTable();
        ArrayList<CachedLocalVariable> arrayList = new ArrayList<CachedLocalVariable>();
        Iterator iterator = this.variableTable.iterator();
        while (iterator.hasNext()) {
            CachedLocalVariable cachedLocalVariable = (CachedLocalVariable)iterator.next();
            if (!cachedLocalVariable.isVisible(n)) continue;
            arrayList.add(cachedLocalVariable);
        }
        return arrayList;
    }

    int getArgumentCount() throws AbsentInformationException {
        if (this.argumentCount == -1) {
            this.fetchVariableTable();
            int n = CachedMethod.getArgumentsSize(this.getRealClass(), this.methodID);
            int n2 = 0;
            int n3 = 0;
            Iterator iterator = this.variableTable.iterator();
            while (iterator.hasNext() && n3 < n) {
                String string = ((CachedLocalVariable)iterator.next()).signature;
                ++n2;
                if (string.equals("J") || string.equals("D")) {
                    n3 += 2;
                    continue;
                }
                ++n3;
            }
            if (n3 != n) {
                throw new InternalError("Invalid Arguments in Local Variable Table");
            }
        }
        return this.argumentCount;
    }

    boolean isArgument(CachedLocalVariable cachedLocalVariable) throws AbsentInformationException {
        this.fetchVariableTable();
        int n = this.getArgumentCount();
        int n2 = 0;
        while (n2 < n) {
            CachedLocalVariable cachedLocalVariable2 = (CachedLocalVariable)this.variableTable.get(n2);
            if (cachedLocalVariable.name.equals(cachedLocalVariable2.name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String toString() {
        return this.cachedClass.toString() + "." + this.getName();
    }

    private static class VariableEntry {
        long startLocation;
        int scopeLength;
        String name;
        String signature;
        int slot;

        VariableEntry(long l, int n, String string, String string2, int n2) {
            this.startLocation = l;
            this.scopeLength = n;
            this.name = string;
            this.signature = string2;
            this.slot = n2;
        }
    }

    private static class LineEntry {
        long startLocation;
        int line;

        LineEntry(long l, int n) {
            this.startLocation = l;
            this.line = n;
        }
    }
}

