/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.tools.example.debug.tty.Env;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class ThreadInfo {
    private static List threads = Collections.synchronizedList(new ArrayList());
    private static boolean gotInitialThreads = false;
    static ThreadInfo current = null;
    private static ThreadGroupReference group = null;
    final ThreadReference thread;
    int currentFrameIndex = 0;

    private ThreadInfo(ThreadReference threadReference) {
        this.thread = threadReference;
        if (threadReference == null) {
            Env.fatalError("Internal error: null ThreadInfo created");
        }
    }

    private static void initThreads() {
        if (!gotInitialThreads) {
            Iterator iterator = Env.vm().allThreads().iterator();
            while (iterator.hasNext()) {
                ThreadReference threadReference = (ThreadReference)iterator.next();
                threads.add(new ThreadInfo(threadReference));
            }
            gotInitialThreads = true;
        }
    }

    static void addThread(ThreadReference threadReference) {
        List list = threads;
        synchronized (list) {
            ThreadInfo.initThreads();
            ThreadInfo threadInfo = new ThreadInfo(threadReference);
            if (ThreadInfo.getThread(threadReference) == null) {
                threads.add(threadInfo);
            }
        }
    }

    static void removeThread(ThreadReference threadReference) {
        if (threadReference.equals(current)) {
            String string;
            try {
                string = " \"" + threadReference.name() + "\"";
            }
            catch (Exception exception) {
                string = "";
            }
            ThreadInfo.setCurrentThread(null);
            Env.errorln("");
            Env.errorln("Current thread" + string + " died. Execution continuing...");
        }
        threads.remove(ThreadInfo.getThread(threadReference));
    }

    static List threads() {
        List list = threads;
        synchronized (list) {
            ThreadInfo.initThreads();
            ArrayList arrayList = new ArrayList(threads);
            return arrayList;
        }
    }

    static void invalidateAll() {
        current = null;
        group = null;
        List list = threads;
        synchronized (list) {
            Iterator iterator = ThreadInfo.threads().iterator();
            while (iterator.hasNext()) {
                ThreadInfo threadInfo = (ThreadInfo)iterator.next();
                threadInfo.invalidate();
            }
        }
    }

    static void setThreadGroup(ThreadGroupReference threadGroupReference) {
        group = threadGroupReference;
    }

    static void setCurrentThread(ThreadReference threadReference) {
        if (threadReference == null) {
            current = null;
        } else {
            ThreadInfo threadInfo;
            current = threadInfo = ThreadInfo.getThread(threadReference);
            current.invalidate();
        }
    }

    static ThreadGroupReference group() {
        if (group == null) {
            ThreadInfo.setThreadGroup((ThreadGroupReference)Env.vm().topLevelThreadGroups().get(0));
        }
        return group;
    }

    static ThreadInfo getThread(long l) {
        ThreadInfo threadInfo = null;
        List list = threads;
        synchronized (list) {
            Iterator iterator = ThreadInfo.threads().iterator();
            while (iterator.hasNext()) {
                ThreadInfo threadInfo2 = (ThreadInfo)iterator.next();
                if (threadInfo2.thread.uniqueID() != l) continue;
                threadInfo = threadInfo2;
                break;
            }
        }
        return threadInfo;
    }

    static ThreadInfo getThread(ThreadReference threadReference) {
        return ThreadInfo.getThread(threadReference.uniqueID());
    }

    static ThreadInfo getThread(String string) {
        ThreadInfo threadInfo = null;
        if (string.startsWith("t@")) {
            string = string.substring(2);
        }
        try {
            long l = Long.decode(string);
            threadInfo = ThreadInfo.getThread(l);
        }
        catch (NumberFormatException numberFormatException) {
            threadInfo = null;
        }
        return threadInfo;
    }

    List stack() throws IncompatibleThreadStateException {
        return this.thread.frames();
    }

    StackFrame getCurrentFrame() throws IncompatibleThreadStateException {
        if (this.thread.frameCount() == 0) {
            return null;
        }
        return this.thread.frame(this.currentFrameIndex);
    }

    void invalidate() {
        this.currentFrameIndex = 0;
    }

    private void assureSuspended() throws IncompatibleThreadStateException {
        if (!this.thread.isSuspended()) {
            throw new IncompatibleThreadStateException();
        }
    }

    void up(int n) throws IncompatibleThreadStateException {
        this.assureSuspended();
        if (this.currentFrameIndex + n >= this.thread.frameCount()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.currentFrameIndex += n;
    }

    void down(int n) throws IncompatibleThreadStateException {
        this.assureSuspended();
        if (this.currentFrameIndex - n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.currentFrameIndex -= n;
    }
}

