/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class RunWindow
extends JPanel
implements Runnable,
ActionListener {
    static JButton runB;
    static int delay;
    static int numRuns;
    static boolean exit;
    static JCheckBox zoomCB;
    static JCheckBox printCB;
    static boolean buffersFlag;
    static int bufBeg;
    static int bufEnd;
    private JTextField delayTextField;
    private JTextField runsTextField;
    private Thread thread;
    private JProgressBar pb;

    public RunWindow() {
        this.setLayout(new GridBagLayout());
        EmptyBorder emptyBorder = new EmptyBorder(5, 5, 5, 5);
        this.setBorder(new CompoundBorder(emptyBorder, new BevelBorder(1)));
        Font font = new Font("serif", 0, 10);
        runB = new JButton("Run");
        runB.setBackground(Color.green);
        runB.addActionListener(this);
        runB.setMinimumSize(new Dimension(70, 30));
        Java2Demo.addToGridBag(this, runB, 0, 0, 1, 1, 0.0, 0.0);
        this.pb = new JProgressBar();
        this.pb.setPreferredSize(new Dimension(100, 30));
        this.pb.setMinimum(0);
        Java2Demo.addToGridBag(this, this.pb, 1, 0, 2, 1, 1.0, 0.0);
        JPanel jPanel = new JPanel(new GridLayout(2, 2));
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel("Runs:");
        jLabel.setFont(font);
        jLabel.setForeground(Color.black);
        jPanel2.add(jLabel);
        this.runsTextField = new JTextField(String.valueOf(numRuns));
        jPanel2.add(this.runsTextField);
        this.runsTextField.setPreferredSize(new Dimension(30, 20));
        this.runsTextField.addActionListener(this);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jLabel = new JLabel("Delay:");
        jLabel.setFont(font);
        jLabel.setForeground(Color.black);
        jPanel2.add(jLabel);
        this.delayTextField = new JTextField(String.valueOf(delay));
        jPanel2.add(this.delayTextField);
        this.delayTextField.setPreferredSize(new Dimension(30, 20));
        this.delayTextField.addActionListener(this);
        jPanel.add(jPanel2);
        zoomCB.setHorizontalAlignment(0);
        zoomCB.setFont(font);
        printCB.setFont(font);
        jPanel.add(zoomCB);
        jPanel.add(printCB);
        printCB.addActionListener(this);
        Java2Demo.addToGridBag(this, jPanel, 0, 1, 3, 1, 1.0, 1.0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(printCB)) {
            Java2Demo.printCB.setSelected(printCB.isSelected());
        } else if (actionEvent.getSource().equals(this.delayTextField)) {
            delay = Integer.parseInt(this.delayTextField.getText().trim());
        } else if (actionEvent.getSource().equals(this.runsTextField)) {
            numRuns = Integer.parseInt(this.runsTextField.getText().trim());
        } else if (actionEvent.getActionCommand() == "Run") {
            runB.setText("Stop");
            runB.setBackground(Color.red);
            this.start();
        } else if (actionEvent.getActionCommand() == "Stop") {
            this.stop();
        }
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.setPriority(6);
        this.thread.setName("RunWindow");
        this.thread.start();
    }

    public synchronized void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.thread = null;
        this.notifyAll();
    }

    public void sleepPerTab() {
        int n = 0;
        while (n < delay + 1 && this.thread != null) {
            int n2 = 0;
            while (n2 < 10 && this.thread != null) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
            this.pb.setValue(this.pb.getValue() + 1);
            this.pb.repaint();
            ++n;
        }
    }

    private void printDemo(DemoGroup demoGroup) {
        if (!Java2Demo.controls.toolBarCB.isSelected()) {
            Java2Demo.controls.toolBarCB.setSelected(true);
            demoGroup.revalidate();
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        JPanel jPanel = demoGroup.getPanel();
        int n = 0;
        while (n < jPanel.getComponentCount()) {
            DemoPanel demoPanel = (DemoPanel)jPanel.getComponent(n);
            if (demoPanel.tools != null) {
                if (demoPanel.surface.animating != null && demoPanel.surface.animating.thread != null) {
                    demoPanel.tools.startStopB.doClick();
                    try {
                        Thread.sleep(999L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                demoPanel.tools.printB.doClick();
                try {
                    Thread.sleep(999L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n;
        }
    }

    public void run() {
        System.out.println("\nJava2D Demo RunWindow : " + numRuns + " Runs, " + delay + " second delay between tabs\n" + "java version: " + System.getProperty("java.version") + "\n" + System.getProperty("os.name") + " " + System.getProperty("os.version") + "\n");
        Runtime runtime = Runtime.getRuntime();
        int n = 0;
        while (n < numRuns && this.thread != null) {
            Date date = new Date();
            System.out.print("#" + n + " " + date.toString() + ", ");
            runtime.gc();
            float f = runtime.freeMemory();
            float f2 = runtime.totalMemory();
            System.out.println((f2 - f) / 1024.0f + "K used");
            int n2 = 0;
            while (n2 < Java2Demo.tabbedPane.getTabCount() && this.thread != null) {
                this.pb.setValue(0);
                this.pb.setMaximum(delay);
                DemoGroup demoGroup = null;
                if (n2 != 0) {
                    demoGroup = Java2Demo.group[n2 - 1];
                    demoGroup.invalidate();
                }
                Java2Demo.tabbedPane.setSelectedIndex(n2);
                if (n2 != 0 && (zoomCB.isSelected() || buffersFlag)) {
                    DemoPanel demoPanel = (DemoPanel)demoGroup.getPanel().getComponent(0);
                    if (demoGroup.tabbedPane == null && demoPanel.surface != null) {
                        demoGroup.mouseClicked(new MouseEvent(demoPanel.surface, 500, 0L, 0, 10, 10, 1, false));
                        try {
                            Thread.sleep(999L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    int n3 = 1;
                    while (n3 < demoGroup.tabbedPane.getTabCount() && this.thread != null) {
                        this.pb.setValue(0);
                        this.pb.setMaximum(delay);
                        demoGroup.tabbedPane.setSelectedIndex(n3);
                        JPanel jPanel = demoGroup.getPanel();
                        if (buffersFlag && jPanel.getComponentCount() == 1) {
                            demoPanel = (DemoPanel)jPanel.getComponent(0);
                            if (demoPanel.surface.animating != null) {
                                demoPanel.surface.animating.stop();
                            }
                            int n4 = bufBeg;
                            while (n4 <= bufEnd && this.thread != null) {
                                demoPanel.tools.cloneB.doClick();
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                int n5 = jPanel.getComponentCount();
                                DemoPanel demoPanel2 = (DemoPanel)jPanel.getComponent(n5 - 1);
                                if (demoPanel2.surface.animating != null) {
                                    demoPanel2.surface.animating.stop();
                                }
                                demoPanel2.tools.issueRepaint = true;
                                demoPanel2.tools.screenCombo.setSelectedIndex(n4);
                                demoPanel2.tools.issueRepaint = false;
                                ++n4;
                            }
                        }
                        if (printCB.isSelected()) {
                            this.printDemo(demoGroup);
                        }
                        this.sleepPerTab();
                        ++n3;
                    }
                } else if (n2 != 0 && printCB.isSelected()) {
                    this.printDemo(demoGroup);
                    this.sleepPerTab();
                } else {
                    this.sleepPerTab();
                }
                ++n2;
            }
            if (n + 1 == numRuns) {
                System.out.println("Finished.");
                if (exit && this.thread != null) {
                    System.out.println("System.exit(0).");
                    System.exit(0);
                }
            }
            ++n;
        }
        this.thread = null;
        runB.setText("Run");
        runB.setBackground(Color.green);
        this.pb.setValue(0);
    }

    static {
        delay = 10;
        numRuns = 20;
        zoomCB = new JCheckBox("Zoom");
        printCB = new JCheckBox("Print");
    }
}

