/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.rmi.transport.tcp.ConnectionMultiplexer;
import sun.rmi.transport.tcp.MultiplexConnectionInfo;

final class MultiplexInputStream
extends InputStream {
    private ConnectionMultiplexer manager;
    private MultiplexConnectionInfo info;
    private byte[] buffer;
    private int present = 0;
    private int pos = 0;
    private int requested = 0;
    private boolean disconnected = false;
    private Object lock = new Object();
    private int waterMark;
    private byte[] temp = new byte[1];

    MultiplexInputStream(ConnectionMultiplexer connectionMultiplexer, MultiplexConnectionInfo multiplexConnectionInfo, int n) {
        this.manager = connectionMultiplexer;
        this.info = multiplexConnectionInfo;
        this.buffer = new byte[n];
        this.waterMark = n / 2;
    }

    public synchronized int read() throws IOException {
        int n = this.read(this.temp, 0, 1);
        if (n != 1) {
            return -1;
        }
        return this.temp[0] & 0xFF;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 <= 0) {
            return 0;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.pos >= this.present) {
                this.present = 0;
                this.pos = 0;
            } else if (this.pos >= this.waterMark) {
                System.arraycopy(this.buffer, this.pos, this.buffer, 0, this.present - this.pos);
                this.present -= this.pos;
                this.pos = 0;
            }
            int n4 = this.buffer.length - this.present;
            n3 = Math.max(n4 - this.requested, 0);
        }
        if (n3 > 0) {
            this.manager.sendRequest(this.info, n3);
        }
        Object object2 = this.lock;
        synchronized (object2) {
            this.requested += n3;
            while (this.pos >= this.present && !this.disconnected) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.disconnected && this.pos >= this.present) {
                int n5 = -1;
                return n5;
            }
            int n6 = this.present - this.pos;
            if (n2 < n6) {
                System.arraycopy(this.buffer, this.pos, byArray, n, n2);
                this.pos += n2;
                int n7 = n2;
                return n7;
            }
            System.arraycopy(this.buffer, this.pos, byArray, n, n6);
            this.present = 0;
            this.pos = 0;
            int n8 = n6;
            return n8;
        }
    }

    public int available() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n = this.present - this.pos;
            return n;
        }
    }

    public void close() throws IOException {
        this.manager.sendClose(this.info);
    }

    void receive(int n, DataInputStream dataInputStream) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.pos > 0 && this.buffer.length - this.present < n) {
                System.arraycopy(this.buffer, this.pos, this.buffer, 0, this.present - this.pos);
                this.present -= this.pos;
                this.pos = 0;
            }
            if (this.buffer.length - this.present < n) {
                throw new IOException("Receive buffer overflow");
            }
            dataInputStream.readFully(this.buffer, this.present, n);
            this.present += n;
            this.requested -= n;
            this.lock.notifyAll();
        }
    }

    void disconnect() {
        Object object = this.lock;
        synchronized (object) {
            this.disconnected = true;
            this.lock.notifyAll();
        }
    }
}

