/*
 * Decompiled with CFR 0.152.
 */
package sun.net.nntp;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.net.TelnetInputStream;
import sun.net.TransferProtocolClient;
import sun.net.nntp.NewsgroupInfo;
import sun.net.nntp.NntpInputStream;
import sun.net.nntp.NntpProtocolException;
import sun.net.nntp.UnknownNewsgroupException;

public class NntpClient
extends TransferProtocolClient {
    public static final int NNTP_PORT = 119;
    String serverName;
    int serverPort;

    public NntpClient() {
    }

    public NntpClient(String string) throws IOException {
        this.openServer(string, 119);
    }

    public void openServer(String string, int n) throws IOException {
        this.serverName = string;
        this.serverPort = n;
        super.openServer(string, n);
        if (this.readServerResponse() >= 300) {
            throw new NntpProtocolException("Welcome message");
        }
    }

    public int askServer(String string) throws IOException {
        int n = 503;
        int n2 = 3;
        while (--n2 >= 0) {
            try {
                this.serverOutput.print(string);
                n = this.readServerResponse();
                if (n < 500) {
                    return n;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.serverOutput.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.openServer(this.serverName, this.serverPort);
        }
        return n;
    }

    InputStream makeStreamRequest(String string, int n) throws IOException {
        int n2 = this.askServer(string + "\r\n");
        if (n2 != n) {
            String string2 = null;
            try {
                int n3 = 0;
                while (n3 < 99) {
                    String string3 = (String)this.serverResponse.elementAt(n3);
                    string2 = string2 == null ? string3 : string2 + "\n" + string3;
                    ++n3;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string2 == null) {
                string2 = "Command " + string + " yielded " + n2 + "; expecting " + n;
            }
            throw new NntpProtocolException(string2);
        }
        switch (n2 / 100) {
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                throw new NntpProtocolException("More input to command expected");
            }
            case 4: {
                throw new NntpProtocolException("Server error - cmd OK");
            }
            case 5: {
                throw new NntpProtocolException("Error in command: " + string);
            }
        }
        return new NntpInputStream(new TelnetInputStream(this.serverInput, false));
    }

    String[] tokenize(String string) {
        Vector vector = new Vector();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    public NewsgroupInfo getGroup(String string) throws IOException {
        switch (this.askServer("group " + string + "\r\n")) {
            case 411: {
                throw new UnknownNewsgroupException(string);
            }
            default: {
                throw new NntpProtocolException("unexpected reply: " + this.getResponseString());
            }
            case 211: 
        }
        String[] stringArray = this.tokenize(this.getResponseString());
        int n = Integer.parseInt(stringArray[2]);
        int n2 = Integer.parseInt(stringArray[3]);
        return new NewsgroupInfo(string, n, n2);
    }

    public void setGroup(String string) throws IOException {
        if (this.askServer("group " + string + "\r\n") != 211) {
            throw new UnknownNewsgroupException(string);
        }
    }

    public InputStream getArticle(int n) throws IOException {
        return this.makeStreamRequest("article " + n, 220);
    }

    public InputStream getArticle(String string) throws IOException {
        if (string.charAt(0) != '<') {
            string = "<" + string + ">";
        }
        return this.makeStreamRequest("article " + string, 220);
    }

    public InputStream getHeader(int n) throws IOException {
        return this.makeStreamRequest("head " + n, 221);
    }

    public InputStream getHeader(String string) throws IOException {
        if (string.charAt(0) != '<') {
            string = "<" + string + ">";
        }
        return this.makeStreamRequest("head " + string, 221);
    }

    public PrintStream startPost() throws IOException {
        return this.askServer("post\r\n") == 340 ? this.serverOutput : null;
    }

    public boolean finishPost() throws IOException {
        return this.askServer(".\r\n") == 240;
    }
}

