/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image.codec;

import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGHuffmanTable;
import com.sun.image.codec.jpeg.JPEGQTable;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.util.Enumeration;
import java.util.Vector;

public class JPEGParam
implements JPEGEncodeParam,
Cloneable {
    private static int[] defComponents = new int[]{-1, 1, 3, 3, 4, 3, 4, 4, 4, 4, 4, 4};
    private static int[][] stdCompMapping = new int[][]{{0, 0, 0, 0}, {0}, {0, 0, 0}, {0, 1, 1}, {0, 0, 0, 0}, {0, 1, 1}, {0, 0, 0, 0}, {0, 1, 1, 0}, {0, 0, 0, 0}, {0, 1, 1, 0}, {0, 1, 1, 0}, {0, 1, 1, 0}};
    private static int[][] stdSubsample = new int[][]{{1, 1, 1, 1}, {1}, {1, 1, 1}, {1, 2, 2}, {1, 1, 1, 1}, {1, 2, 2}, {1, 1, 1, 1}, {1, 2, 2, 1}, {1, 1, 1, 1}, {1, 2, 2, 1}, {1, 2, 2, 1}, {1, 2, 2, 1}};
    private int width;
    private int height;
    private int encodedColorID;
    private int numComponents;
    private byte[][][] appMarkers;
    private byte[][] comMarker;
    private boolean imageInfoValid;
    private boolean tableInfoValid;
    private int[] horizontalSubsampling;
    private int[] verticalSubsampling;
    private JPEGQTable[] qTables;
    private int[] qTableMapping;
    private JPEGHuffmanTable[] dcHuffTables;
    private int[] dcHuffMapping;
    private JPEGHuffmanTable[] acHuffTables;
    private int[] acHuffMapping;
    private int restartInterval;
    private static final int app0Length = 14;

    public JPEGParam(int n) {
        this(n, defComponents[n]);
    }

    public JPEGParam(JPEGDecodeParam jPEGDecodeParam) {
        this(jPEGDecodeParam.getEncodedColorID(), jPEGDecodeParam.getNumComponents());
        this.copy(jPEGDecodeParam);
    }

    public JPEGParam(JPEGEncodeParam jPEGEncodeParam) {
        this(jPEGEncodeParam.getEncodedColorID(), jPEGEncodeParam.getNumComponents());
        this.copy(jPEGEncodeParam);
    }

    public JPEGParam(int n, int n2) {
        if (n != 0 && n2 != defComponents[n]) {
            throw new IllegalArgumentException("NumComponents not in sync with COLOR_ID");
        }
        this.qTables = new JPEGQTable[4];
        this.acHuffTables = new JPEGHuffmanTable[4];
        this.dcHuffTables = new JPEGHuffmanTable[4];
        int n3 = 0;
        while (n3 < 4) {
            this.qTables[n3] = null;
            this.dcHuffTables[n3] = null;
            this.acHuffTables[n3] = null;
            ++n3;
        }
        this.comMarker = null;
        this.appMarkers = new byte[16][][];
        this.numComponents = n2;
        this.setDefaults(n);
    }

    private void copy(JPEGDecodeParam jPEGDecodeParam) {
        if (this.getEncodedColorID() != jPEGDecodeParam.getEncodedColorID()) {
            throw new IllegalArgumentException("Argument to copy must match current COLOR_ID");
        }
        if (this.getNumComponents() != jPEGDecodeParam.getNumComponents()) {
            throw new IllegalArgumentException("Argument to copy must match in number of components");
        }
        this.setWidth(jPEGDecodeParam.getWidth());
        this.setHeight(jPEGDecodeParam.getHeight());
        int n = 224;
        while (n < 239) {
            this.setMarkerData(n, JPEGParam.copyArrays(jPEGDecodeParam.getMarkerData(n)));
            ++n;
        }
        this.setMarkerData(254, JPEGParam.copyArrays(jPEGDecodeParam.getMarkerData(254)));
        this.setTableInfoValid(jPEGDecodeParam.isTableInfoValid());
        this.setImageInfoValid(jPEGDecodeParam.isImageInfoValid());
        this.setRestartInterval(jPEGDecodeParam.getRestartInterval());
        int n2 = 0;
        while (n2 < 4) {
            this.setDCHuffmanTable(n2, jPEGDecodeParam.getDCHuffmanTable(n2));
            this.setACHuffmanTable(n2, jPEGDecodeParam.getACHuffmanTable(n2));
            this.setQTable(n2, jPEGDecodeParam.getQTable(n2));
            ++n2;
        }
        int n3 = 0;
        while (n3 < jPEGDecodeParam.getNumComponents()) {
            this.setDCHuffmanComponentMapping(n3, jPEGDecodeParam.getDCHuffmanComponentMapping(n3));
            this.setACHuffmanComponentMapping(n3, jPEGDecodeParam.getACHuffmanComponentMapping(n3));
            this.setQTableComponentMapping(n3, jPEGDecodeParam.getQTableComponentMapping(n3));
            this.setHorizontalSubsampling(n3, jPEGDecodeParam.getHorizontalSubsampling(n3));
            this.setVerticalSubsampling(n3, jPEGDecodeParam.getVerticalSubsampling(n3));
            ++n3;
        }
    }

    private void copy(JPEGEncodeParam jPEGEncodeParam) {
        this.copy((JPEGDecodeParam)jPEGEncodeParam);
    }

    protected void setDefaults(int n) {
        this.encodedColorID = n;
        this.restartInterval = 0;
        boolean bl = false;
        switch (this.numComponents) {
            case 1: {
                if (this.encodedColorID != 1 && this.encodedColorID != 0) break;
                bl = true;
                break;
            }
            case 3: {
                if (this.encodedColorID != 3) break;
                bl = true;
                break;
            }
            case 4: {
                if (this.encodedColorID != 4) break;
                bl = true;
                break;
            }
        }
        if (bl) {
            this.addMarkerData(224, JPEGParam.createDefaultAPP0Marker());
        }
        this.setTableInfoValid(true);
        this.setImageInfoValid(true);
        this.dcHuffTables[0] = JPEGHuffmanTable.StdDCLuminance;
        this.dcHuffTables[1] = JPEGHuffmanTable.StdDCChrominance;
        this.dcHuffMapping = new int[this.getNumComponents()];
        System.arraycopy(stdCompMapping[this.encodedColorID], 0, this.dcHuffMapping, 0, this.getNumComponents());
        this.acHuffTables[0] = JPEGHuffmanTable.StdACLuminance;
        this.acHuffTables[1] = JPEGHuffmanTable.StdACChrominance;
        this.acHuffMapping = new int[this.getNumComponents()];
        System.arraycopy(stdCompMapping[this.encodedColorID], 0, this.acHuffMapping, 0, this.getNumComponents());
        this.qTables[0] = JPEGQTable.StdLuminance.getScaledInstance(0.5f, true);
        this.qTables[1] = JPEGQTable.StdChrominance.getScaledInstance(0.5f, true);
        this.qTableMapping = new int[this.getNumComponents()];
        System.arraycopy(stdCompMapping[this.encodedColorID], 0, this.qTableMapping, 0, this.getNumComponents());
        this.horizontalSubsampling = new int[this.getNumComponents()];
        System.arraycopy(stdSubsample[this.encodedColorID], 0, this.horizontalSubsampling, 0, this.getNumComponents());
        this.verticalSubsampling = new int[this.getNumComponents()];
        System.arraycopy(stdSubsample[this.encodedColorID], 0, this.verticalSubsampling, 0, this.getNumComponents());
    }

    public Object clone() {
        JPEGParam jPEGParam = new JPEGParam(this.getEncodedColorID(), this.getNumComponents());
        jPEGParam.copy(this);
        return jPEGParam;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public int getHorizontalSubsampling(int n) {
        if (n < 0 || n >= this.getNumComponents()) {
            throw new IllegalArgumentException("Component must be between 0 and number of components");
        }
        return this.horizontalSubsampling[n];
    }

    public int getVerticalSubsampling(int n) {
        if (n < 0 || n >= this.getNumComponents()) {
            throw new IllegalArgumentException("Component must be between 0 and number of components");
        }
        return this.verticalSubsampling[n];
    }

    public void setHorizontalSubsampling(int n, int n2) {
        if (n < 0 || n >= this.getNumComponents()) {
            throw new IllegalArgumentException("Component must be between 0 and number of components: " + n);
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("SubSample factor must be positive: " + n2);
        }
        this.horizontalSubsampling[n] = n2;
    }

    public void setVerticalSubsampling(int n, int n2) {
        if (n < 0 || n >= this.getNumComponents()) {
            throw new IllegalArgumentException("Component must be between 0 and number of components");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("SubSample factor must be positive.");
        }
        this.verticalSubsampling[n] = n2;
    }

    public JPEGQTable getQTable(int n) {
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException("tableNum must be between 0 and 3.");
        }
        return this.qTables[n];
    }

    public JPEGQTable getQTableForComponent(int n) {
        if (n < 0 || n >= this.qTableMapping.length) {
            throw new IllegalArgumentException("Component must be between 0 and number of components");
        }
        return this.getQTable(this.qTableMapping[n]);
    }

    public JPEGHuffmanTable getDCHuffmanTable(int n) {
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException("tableNum must be 0-3.");
        }
        return this.dcHuffTables[n];
    }

    public JPEGHuffmanTable getDCHuffmanTableForComponent(int n) {
        if (n < 0 || n >= this.dcHuffMapping.length) {
            throw new IllegalArgumentException("Component must be between 0 and number of components");
        }
        return this.getDCHuffmanTable(this.dcHuffMapping[n]);
    }

    public JPEGHuffmanTable getACHuffmanTable(int n) {
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException("tableNum must be 0-3.");
        }
        return this.acHuffTables[n];
    }

    public JPEGHuffmanTable getACHuffmanTableForComponent(int n) {
        if (n < 0 || n >= this.acHuffMapping.length) {
            throw new IllegalArgumentException("Component must be between 0 and number of components");
        }
        return this.getACHuffmanTable(this.acHuffMapping[n]);
    }

    public void setQTable(int n, JPEGQTable jPEGQTable) {
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException("tableNum must be between 0 and 3.");
        }
        this.qTables[n] = jPEGQTable;
    }

    public void setDCHuffmanTable(int n, JPEGHuffmanTable jPEGHuffmanTable) {
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException("tableNum must be 0, 1, 2, or 3.");
        }
        this.dcHuffTables[n] = jPEGHuffmanTable;
    }

    public void setACHuffmanTable(int n, JPEGHuffmanTable jPEGHuffmanTable) {
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException("tableNum must be 0, 1, 2, or 3.");
        }
        this.acHuffTables[n] = jPEGHuffmanTable;
    }

    public int getDCHuffmanComponentMapping(int n) {
        if (n < 0 || n >= this.getNumComponents()) {
            throw new IllegalArgumentException("Requested Component doesn't exist.");
        }
        return this.dcHuffMapping[n];
    }

    public int getACHuffmanComponentMapping(int n) {
        if (n < 0 || n >= this.getNumComponents()) {
            throw new IllegalArgumentException("Requested Component doesn't exist.");
        }
        return this.acHuffMapping[n];
    }

    public int getQTableComponentMapping(int n) {
        if (n < 0 || n >= this.getNumComponents()) {
            throw new IllegalArgumentException("Requested Component doesn't exist.");
        }
        return this.qTableMapping[n];
    }

    public void setDCHuffmanComponentMapping(int n, int n2) {
        if (n < 0 || n >= this.getNumComponents()) {
            throw new IllegalArgumentException("Given Component doesn't exist.");
        }
        if (n2 < 0 || n2 >= 4) {
            throw new IllegalArgumentException("Tables must be 0, 1, 2, or 3.");
        }
        this.dcHuffMapping[n] = n2;
    }

    public void setACHuffmanComponentMapping(int n, int n2) {
        if (n < 0 || n >= this.getNumComponents()) {
            throw new IllegalArgumentException("Given Component doesn't exist.");
        }
        if (n2 < 0 || n2 >= 4) {
            throw new IllegalArgumentException("Tables must be 0, 1, 2, or 3.");
        }
        this.acHuffMapping[n] = n2;
    }

    public void setQTableComponentMapping(int n, int n2) {
        if (n < 0 || n >= this.getNumComponents()) {
            throw new IllegalArgumentException("Given Component doesn't exist.");
        }
        if (n2 < 0 || n2 >= 4) {
            throw new IllegalArgumentException("Tables must be 0, 1, 2, or 3.");
        }
        this.qTableMapping[n] = n2;
    }

    public boolean isImageInfoValid() {
        return this.imageInfoValid;
    }

    public void setImageInfoValid(boolean bl) {
        this.imageInfoValid = bl;
    }

    public boolean isTableInfoValid() {
        return this.tableInfoValid;
    }

    public void setTableInfoValid(boolean bl) {
        this.tableInfoValid = bl;
    }

    public boolean getMarker(int n) {
        byte[][] byArray = null;
        if (n == 254) {
            byArray = this.comMarker;
        } else if (n >= 224 && n <= 239) {
            byArray = this.appMarkers[n - 224];
        } else {
            throw new IllegalArgumentException("Invalid Marker ID:" + n);
        }
        if (byArray == null) {
            return false;
        }
        return byArray.length != 0;
    }

    public byte[][] getMarkerData(int n) {
        if (n == 254) {
            return this.comMarker;
        }
        if (n >= 224 && n <= 239) {
            return this.appMarkers[n - 224];
        }
        throw new IllegalArgumentException("Invalid Marker ID:" + n);
    }

    public void setMarkerData(int n, byte[][] byArray) {
        if (n == 254) {
            this.comMarker = byArray;
        } else if (n >= 224 && n <= 239) {
            this.appMarkers[n - 224] = byArray;
        } else {
            throw new IllegalArgumentException("Invalid Marker ID:" + n);
        }
    }

    public void addMarkerData(int n, byte[] byArray) {
        if (byArray == null) {
            return;
        }
        if (n == 254) {
            this.comMarker = JPEGParam.appendArray(this.comMarker, byArray);
        } else if (n >= 224 && n <= 239) {
            this.appMarkers[n - 224] = JPEGParam.appendArray(this.appMarkers[n - 224], byArray);
        } else {
            throw new IllegalArgumentException("Invalid Marker ID:" + n);
        }
    }

    public int getEncodedColorID() {
        return this.encodedColorID;
    }

    public int getNumComponents() {
        return this.numComponents;
    }

    public static int getNumComponents(int n) {
        if (n < 0 || n >= 12) {
            throw new IllegalArgumentException("Invalid JPEGColorID.");
        }
        return defComponents[n];
    }

    public int getRestartInterval() {
        return this.restartInterval;
    }

    public void setRestartInterval(int n) {
        this.restartInterval = n;
    }

    public int getDensityUnit() {
        if (!this.getMarker(224)) {
            throw new IllegalArgumentException("No APP0 marker present");
        }
        byte[] byArray = this.findAPP0();
        if (byArray == null) {
            throw new IllegalArgumentException("Can't understand APP0 marker that is present");
        }
        return byArray[7];
    }

    public int getXDensity() {
        if (!this.getMarker(224)) {
            throw new IllegalArgumentException("No APP0 marker present");
        }
        byte[] byArray = this.findAPP0();
        if (byArray == null) {
            throw new IllegalArgumentException("Can't understand APP0 marker that is present");
        }
        int n = byArray[8] << 8 | byArray[9] & 0xFF;
        return n;
    }

    public int getYDensity() {
        if (!this.getMarker(224)) {
            throw new IllegalArgumentException("No APP0 marker present");
        }
        byte[] byArray = this.findAPP0();
        if (byArray == null) {
            throw new IllegalArgumentException("Can't understand APP0 marker that is present");
        }
        int n = byArray[10] << 8 | byArray[11] & 0xFF;
        return n;
    }

    public void setDensityUnit(int n) {
        byte[] byArray = null;
        if (!this.getMarker(224)) {
            byArray = JPEGParam.createDefaultAPP0Marker();
            this.addMarkerData(224, byArray);
        } else {
            byArray = this.findAPP0();
            if (byArray == null) {
                throw new IllegalArgumentException("Can't understand APP0 marker that is present");
            }
        }
        byArray[7] = (byte)n;
    }

    public void setXDensity(int n) {
        byte[] byArray = null;
        if (!this.getMarker(224)) {
            byArray = JPEGParam.createDefaultAPP0Marker();
            this.addMarkerData(224, byArray);
        } else {
            byArray = this.findAPP0();
            if (byArray == null) {
                throw new IllegalArgumentException("Can't understand APP0 marker that is present");
            }
        }
        byArray[8] = (byte)(n >>> 8 & 0xFF);
        byArray[9] = (byte)(n & 0xFF);
    }

    public void setYDensity(int n) {
        byte[] byArray = null;
        if (!this.getMarker(224)) {
            byArray = JPEGParam.createDefaultAPP0Marker();
            this.addMarkerData(224, byArray);
        } else {
            byArray = this.findAPP0();
            if (byArray == null) {
                throw new IllegalArgumentException("Can't understand APP0 marker that is present");
            }
        }
        byArray[10] = (byte)(n >>> 8 & 0xFF);
        byArray[11] = (byte)(n & 0xFF);
    }

    public void setQuality(float f, boolean bl) {
        double d = f;
        if (d <= 0.01) {
            d = 0.01;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        d = d < 0.5 ? 0.5 / d : 2.0 - d * 2.0;
        this.qTableMapping = new int[this.getNumComponents()];
        System.arraycopy(stdCompMapping[this.encodedColorID], 0, this.qTableMapping, 0, this.getNumComponents());
        JPEGQTable jPEGQTable = JPEGQTable.StdLuminance;
        this.qTables[0] = jPEGQTable.getScaledInstance((float)d, bl);
        jPEGQTable = JPEGQTable.StdChrominance;
        this.qTables[1] = jPEGQTable.getScaledInstance((float)d, bl);
        this.qTables[2] = null;
        this.qTables[3] = null;
    }

    byte[] findAPP0() {
        byte[][] byArray = null;
        byArray = this.getMarkerData(224);
        if (byArray == null) {
            return null;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != null && JPEGParam.checkAPP0(byArray[n])) {
                return byArray[n];
            }
            ++n;
        }
        return null;
    }

    static boolean checkAPP0(byte[] byArray) {
        if (byArray.length < 14) {
            return false;
        }
        if (byArray[0] != 74 || byArray[1] != 70 || byArray[2] != 73 || byArray[3] != 70 || byArray[4] != 0) {
            return false;
        }
        return byArray[5] >= 1;
    }

    static byte[] createDefaultAPP0Marker() {
        byte[] byArray = new byte[]{74, 70, 73, 70, 0, 1, 1, 0, 0, 1, 0, 1, 0, 0};
        return byArray;
    }

    static byte[] copyArray(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    static byte[][] copyArrays(byte[][] byArray) {
        if (byArray == null) {
            return null;
        }
        byte[][] byArrayArray = new byte[byArray.length][];
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != null) {
                byArrayArray[n] = JPEGParam.copyArray(byArray[n]);
            }
            ++n;
        }
        return byArrayArray;
    }

    static byte[][] appendArray(byte[][] byArray, byte[] byArray2) {
        int n = 0;
        if (byArray != null) {
            n = byArray.length;
        }
        byte[][] byArrayArray = new byte[n + 1][];
        int n2 = 0;
        while (n2 < n) {
            byArrayArray[n2] = byArray[n2];
            ++n2;
        }
        if (byArray2 != null) {
            byArrayArray[n] = JPEGParam.copyArray(byArray2);
        }
        return byArrayArray;
    }

    static byte[][] buildArray(Vector vector) {
        if (vector == null) {
            return null;
        }
        int n = 0;
        byte[][] byArrayArray = new byte[vector.size()][];
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            byte[] byArray = (byte[])enumeration.nextElement();
            if (byArray == null) continue;
            byArrayArray[n++] = JPEGParam.copyArray(byArray);
        }
        return byArrayArray;
    }

    public static int getDefaultColorId(ColorModel colorModel) {
        boolean bl = colorModel.hasAlpha();
        ColorSpace colorSpace = colorModel.getColorSpace();
        ColorSpace colorSpace2 = null;
        switch (colorSpace.getType()) {
            case 6: {
                return 1;
            }
            case 5: {
                if (bl) {
                    return 7;
                }
                return 3;
            }
            case 3: {
                if (colorSpace2 == null) {
                    try {
                        colorSpace2 = ColorSpace.getInstance(1002);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if (colorSpace == colorSpace2) {
                    return bl ? 10 : 5;
                }
                return bl ? 7 : 3;
            }
            case 9: {
                return 4;
            }
        }
        return 0;
    }
}

