/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import sun.awt.image.BufferedImageDevice;
import sun.java2d.OutputManager;
import sun.java2d.loops.RasterOutputManager;

public class BufferedImageGraphicsConfig
extends GraphicsConfiguration {
    private static final int numconfigs = 12;
    private static BufferedImageGraphicsConfig[] configs = new BufferedImageGraphicsConfig[12];
    GraphicsDevice gd;
    ColorModel model;
    Raster raster;
    int width;
    int height;

    public static GraphicsConfiguration getConfig(BufferedImage bufferedImage) {
        BufferedImageGraphicsConfig bufferedImageGraphicsConfig;
        int n = bufferedImage.getType();
        if (n > 0 && n < 12 && (bufferedImageGraphicsConfig = configs[n]) != null) {
            return bufferedImageGraphicsConfig;
        }
        bufferedImageGraphicsConfig = new BufferedImageGraphicsConfig(bufferedImage, null);
        if (n > 0 && n < 12) {
            BufferedImageGraphicsConfig.configs[n] = bufferedImageGraphicsConfig;
        }
        return bufferedImageGraphicsConfig;
    }

    public static OutputManager getOutputManager(BufferedImage bufferedImage) {
        return RasterOutputManager.getManager();
    }

    public BufferedImageGraphicsConfig(BufferedImage bufferedImage, Component component) {
        if (component == null) {
            this.gd = new BufferedImageDevice(this);
        } else {
            Graphics2D graphics2D = (Graphics2D)component.getGraphics();
            this.gd = graphics2D.getDeviceConfiguration().getDevice();
        }
        this.model = bufferedImage.getColorModel();
        this.raster = bufferedImage.getRaster().createCompatibleWritableRaster(1, 1);
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
    }

    public GraphicsDevice getDevice() {
        return this.gd;
    }

    public BufferedImage createCompatibleImage(int n, int n2) {
        WritableRaster writableRaster = this.raster.createCompatibleWritableRaster(n, n2);
        return new BufferedImage(this.model, writableRaster, this.model.isAlphaPremultiplied(), null);
    }

    public BufferedImage createCompatibleImage(int n, int n2, int n3) {
        return this.createCompatibleImage(n, n2);
    }

    public ColorModel getColorModel() {
        return this.model;
    }

    public ColorModel getColorModel(int n) {
        if (this.model.getTransparency() == n) {
            return this.model;
        }
        return null;
    }

    public AffineTransform getDefaultTransform() {
        return new AffineTransform();
    }

    public AffineTransform getNormalizingTransform() {
        return new AffineTransform();
    }

    public Rectangle getBounds() {
        return new Rectangle(0, 0, this.width, this.height);
    }
}

