/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.AbstractActionPropertyChangeListener;
import javax.swing.Action;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JViewport;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.TextAction;

public class JTextField
extends JTextComponent
implements SwingConstants {
    private Action action;
    private PropertyChangeListener actionPropertyChangeListener;
    public static final String notifyAction = "notify-field-accept";
    private BoundedRangeModel visibility;
    private int horizontalAlignment = 10;
    private int columns;
    private int columnWidth;
    private String command;
    private static final Action[] defaultActions = new Action[]{new NotifyAction()};
    private static final String uiClassID = "TextFieldUI";
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public JTextField() {
        this(null, null, 0);
    }

    public JTextField(String string) {
        this(null, string, 0);
    }

    public JTextField(int n) {
        this(null, null, n);
    }

    public JTextField(String string, int n) {
        this(null, string, n);
    }

    public JTextField(Document document, String string, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("columns less than zero.");
        }
        this.visibility = new DefaultBoundedRangeModel();
        this.visibility.addChangeListener(new ScrollRepainter());
        this.columns = n;
        if (document == null) {
            document = this.createDefaultModel();
        }
        this.setDocument(document);
        if (string != null) {
            this.setText(string);
        }
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public boolean isValidateRoot() {
        Container container = this.getParent();
        return !(container instanceof JViewport);
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int n) {
        if (n == this.horizontalAlignment) {
            return;
        }
        int n2 = this.horizontalAlignment;
        if (n != 2 && n != 0 && n != 4 && n != 10 && n != 11) {
            throw new IllegalArgumentException("horizontalAlignment");
        }
        this.horizontalAlignment = n;
        this.firePropertyChange("horizontalAlignment", n2, this.horizontalAlignment);
        this.invalidate();
        this.repaint();
    }

    protected Document createDefaultModel() {
        return new PlainDocument();
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int n) {
        int n2 = this.columns;
        if (n < 0) {
            throw new IllegalArgumentException("columns less than zero.");
        }
        if (n != n2) {
            this.columns = n;
            this.invalidate();
        }
    }

    protected int getColumnWidth() {
        if (this.columnWidth == 0) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            this.columnWidth = fontMetrics.charWidth('m');
        }
        return this.columnWidth;
    }

    public Dimension getPreferredSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Dimension dimension = super.getPreferredSize();
            if (this.columns != 0) {
                dimension.width = this.columns * this.getColumnWidth();
            }
            Dimension dimension2 = dimension;
            return dimension2;
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.columnWidth = 0;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.listenerList.add(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = JTextField.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        if (actionListener != null && this.getAction() == actionListener) {
            this.setAction(null);
        } else {
            this.listenerList.remove(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = JTextField.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, actionListener);
        }
    }

    protected void fireActionPerformed() {
        Object[] objectArray = this.listenerList.getListenerList();
        ActionEvent actionEvent = new ActionEvent(this, 1001, this.command != null ? this.command : this.getText());
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$awt$event$ActionListener == null ? JTextField.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) {
                ((ActionListener)objectArray[n + 1]).actionPerformed(actionEvent);
            }
            n -= 2;
        }
    }

    public void setActionCommand(String string) {
        this.command = string;
    }

    public void setAction(Action action) {
        Action action2 = this.getAction();
        if (this.action == null || !this.action.equals(action)) {
            this.action = action;
            if (action2 != null) {
                this.removeActionListener(action2);
                action2.removePropertyChangeListener(this.actionPropertyChangeListener);
                this.actionPropertyChangeListener = null;
            }
            this.configurePropertiesFromAction(this.action);
            if (this.action != null) {
                if (!this.isListener(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = JTextField.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, this.action)) {
                    this.addActionListener(this.action);
                }
                this.actionPropertyChangeListener = this.createActionPropertyChangeListener(this.action);
                this.action.addPropertyChangeListener(this.actionPropertyChangeListener);
            }
            this.firePropertyChange("action", action2, this.action);
            this.revalidate();
            this.repaint();
        }
    }

    private boolean isListener(Class clazz, ActionListener actionListener) {
        boolean bl = false;
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == clazz && objectArray[n + 1] == actionListener) {
                bl = true;
            }
            n -= 2;
        }
        return bl;
    }

    public Action getAction() {
        return this.action;
    }

    protected void configurePropertiesFromAction(Action action) {
        this.setEnabled(action != null ? action.isEnabled() : true);
        this.setToolTipText(action != null ? (String)action.getValue("ShortDescription") : null);
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
        return new AbstractActionPropertyChangeListener(this, action){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                JTextField jTextField = (JTextField)this.getTarget();
                if (jTextField == null) {
                    Action action = (Action)propertyChangeEvent.getSource();
                    action.removePropertyChangeListener(this);
                } else if (propertyChangeEvent.getPropertyName().equals("ShortDescription")) {
                    String string2 = (String)propertyChangeEvent.getNewValue();
                    jTextField.setToolTipText(string2);
                } else if (string.equals("enabled")) {
                    Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                    jTextField.setEnabled(bl);
                    jTextField.repaint();
                }
            }
        };
    }

    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), defaultActions);
    }

    public void postActionEvent() {
        this.fireActionPerformed();
    }

    public BoundedRangeModel getHorizontalVisibility() {
        return this.visibility;
    }

    public int getScrollOffset() {
        return this.visibility.getValue();
    }

    public void setScrollOffset(int n) {
        this.visibility.setValue(n);
    }

    public void scrollRectToVisible(Rectangle rectangle) {
        int n = rectangle.x + this.visibility.getValue();
        if (n < this.visibility.getValue()) {
            this.visibility.setValue(n - 2);
        } else if (n > this.visibility.getValue() + this.visibility.getExtent()) {
            this.visibility.setValue(n - this.visibility.getExtent() + 2);
        }
    }

    boolean hasActionListener() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$awt$event$ActionListener == null ? JTextField.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) {
                return true;
            }
            n -= 2;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    protected String paramString() {
        String string = this.horizontalAlignment == 2 ? "LEFT" : (this.horizontalAlignment == 0 ? "CENTER" : (this.horizontalAlignment == 4 ? "RIGHT" : (this.horizontalAlignment == 10 ? "LEADING" : (this.horizontalAlignment == 11 ? "TRAILING" : ""))));
        String string2 = this.command != null ? this.command : "";
        return super.paramString() + ",columns=" + this.columns + ",columnWidth=" + this.columnWidth + ",command=" + string2 + ",horizontalAlignment=" + string;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTextField();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class AccessibleJTextField
    extends JTextComponent.AccessibleJTextComponent {
        protected AccessibleJTextField() {
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.SINGLE_LINE);
            return accessibleStateSet;
        }
    }

    class ScrollRepainter
    implements ChangeListener {
        ScrollRepainter() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JTextField.this.repaint();
        }
    }

    static class NotifyAction
    extends TextAction {
        NotifyAction() {
            super(JTextField.notifyAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getFocusedComponent();
            if (jTextComponent instanceof JTextField) {
                JTextField jTextField = (JTextField)jTextComponent;
                jTextField.postActionEvent();
            }
        }

        public boolean isEnabled() {
            JTextComponent jTextComponent = this.getFocusedComponent();
            if (jTextComponent instanceof JTextField) {
                return ((JTextField)jTextComponent).hasActionListener();
            }
            return false;
        }
    }
}

