/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Vector
extends AbstractList
implements List,
Cloneable,
Serializable {
    protected int capacityIncrement;
    protected int elementCount;
    protected Object[] elementData;
    private static final long serialVersionUID = -2767605614048989439L;

    private /* synthetic */ void finit$() {
        this.capacityIncrement = 0;
        this.elementCount = 0;
    }

    public Vector() {
        this(10);
    }

    public Vector(Collection c) {
        this.finit$();
        int csize = c.size();
        this.elementData = new Object[csize];
        this.elementCount = csize;
        Iterator itr = c.iterator();
        for (int i = 0; i < csize; ++i) {
            this.elementData[i] = itr.next();
        }
    }

    public Vector(int initialCapacity, int capacityIncrement) {
        this.finit$();
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        this.elementData = new Object[initialCapacity];
        this.capacityIncrement = capacityIncrement;
    }

    public Vector(int initialCapacity) {
        this.finit$();
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        this.elementData = new Object[initialCapacity];
    }

    public synchronized void copyInto(Object[] anArray) {
        System.arraycopy(this.elementData, 0, anArray, 0, this.elementCount);
    }

    public synchronized void trimToSize() {
        Object[] newArray = new Object[this.elementCount];
        System.arraycopy(this.elementData, 0, newArray, 0, this.elementCount);
        this.elementData = newArray;
    }

    public synchronized void ensureCapacity(int minCapacity) {
        if (this.elementData.length >= minCapacity) {
            return;
        }
        int newCapacity = this.capacityIncrement <= 0 ? this.elementData.length * 2 : this.elementData.length + this.capacityIncrement;
        Object[] newArray = new Object[Math.max(newCapacity, minCapacity)];
        System.arraycopy(this.elementData, 0, newArray, 0, this.elementData.length);
        this.elementData = newArray;
    }

    public synchronized void setSize(int newSize) {
        ++this.modCount;
        Object[] newArray = new Object[newSize];
        System.arraycopy(this.elementData, 0, newArray, 0, Math.min(newSize, this.elementCount));
        this.elementCount = newSize;
        this.elementData = newArray;
    }

    public int capacity() {
        return this.elementData.length;
    }

    public int size() {
        return this.elementCount;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public synchronized int indexOf(Object e, int index) {
        for (int i = index; i < this.elementCount; ++i) {
            if (!(e == null ? this.elementData[i] == null : e.equals(this.elementData[i]))) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(Object elem) {
        return this.indexOf(elem, 0);
    }

    public boolean contains(Object elem) {
        return this.indexOf(elem, 0) != -1;
    }

    public synchronized int lastIndexOf(Object e, int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        for (int i = index; i >= 0; --i) {
            if (!(e == null ? this.elementData[i] == null : e.equals(this.elementData[i]))) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(Object elem) {
        return this.lastIndexOf(elem, this.elementCount - 1);
    }

    public synchronized Object elementAt(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        return this.elementData[index];
    }

    public synchronized Object firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementAt(0);
    }

    public synchronized Object lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementAt(this.elementCount - 1);
    }

    public synchronized void setElementAt(Object obj, int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        this.elementData[index] = obj;
    }

    public synchronized Object set(int index, Object element) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        Object temp = this.elementData[index];
        this.elementData[index] = element;
        return temp;
    }

    public synchronized void removeElementAt(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        ++this.modCount;
        this.elementCount += -1;
        if (index < this.elementCount) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, this.elementCount - index);
        }
        this.elementData[this.elementCount] = null;
    }

    public void insertElementAt(Object obj, int index) {
        if (index > this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " > " + this.elementCount);
        }
        if (this.elementCount == this.elementData.length) {
            this.ensureCapacity(this.elementCount + 1);
        }
        ++this.modCount;
        ++this.elementCount;
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.elementCount - 1 - index);
        this.elementData[index] = obj;
    }

    public synchronized void addElement(Object obj) {
        if (this.elementCount == this.elementData.length) {
            this.ensureCapacity(this.elementCount + 1);
        }
        ++this.modCount;
        this.elementData[this.elementCount++] = obj;
    }

    public synchronized boolean removeElement(Object obj) {
        int idx = this.indexOf(obj);
        if (idx != -1) {
            this.removeElementAt(idx);
            return true;
        }
        return false;
    }

    public synchronized void removeAllElements() {
        ++this.modCount;
        if (this.elementCount == 0) {
            return;
        }
        for (int i = this.elementCount - 1; i >= 0; --i) {
            this.elementData[i] = null;
        }
        this.elementCount = 0;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized Object clone() {
        try {
            void ex;
            Vector clone = (Vector)super.clone();
            clone.elementData = (Object[])this.elementData.clone();
            return ex;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.toString());
        }
    }

    public synchronized Object[] toArray() {
        Object[] newArray = new Object[this.elementCount];
        this.copyInto(newArray);
        return newArray;
    }

    public synchronized Object[] toArray(Object[] array) {
        if (array.length < this.elementCount) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), this.elementCount);
        } else if (array.length > this.elementCount) {
            array[this.elementCount] = null;
        }
        System.arraycopy(this.elementData, 0, array, 0, this.elementCount);
        return array;
    }

    public synchronized Object get(int index) {
        return this.elementAt(index);
    }

    public boolean remove(Object o) {
        return this.removeElement(o);
    }

    public synchronized boolean add(Object o) {
        this.addElement(o);
        return true;
    }

    public void add(int index, Object element) {
        this.insertElementAt(element, index);
    }

    public synchronized Object remove(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        Object temp = this.elementData[index];
        this.removeElementAt(index);
        return temp;
    }

    public void clear() {
        this.removeAllElements();
    }

    public synchronized boolean containsAll(Collection c) {
        Iterator itr = c.iterator();
        int size = c.size();
        for (int pos = 0; pos < size; ++pos) {
            if (this.contains(itr.next())) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean addAll(Collection c) {
        return this.addAll(this.elementCount, c);
    }

    public synchronized boolean removeAll(Collection c) {
        return super.removeAll(c);
    }

    public synchronized boolean retainAll(Collection c) {
        return super.retainAll(c);
    }

    public synchronized boolean addAll(int index, Collection c) {
        if (index < 0 || index > this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        ++this.modCount;
        Iterator itr = c.iterator();
        int csize = c.size();
        this.ensureCapacity(this.elementCount + csize);
        int end = index + csize;
        if (this.elementCount > 0 && index != this.elementCount) {
            System.arraycopy(this.elementData, index, this.elementData, end, csize);
        }
        this.elementCount += csize;
        while (index < end) {
            this.elementData[index] = itr.next();
            ++index;
        }
        return csize > 0;
    }

    public synchronized boolean equals(Object c) {
        return super.equals(c);
    }

    public synchronized int hashCode() {
        return super.hashCode();
    }

    public synchronized String toString() {
        String r = "[";
        for (int i = 0; i < this.elementCount; ++i) {
            r = r + this.elementData[i];
            if (i >= this.elementCount - 1) continue;
            r = r + ", ";
        }
        r = r + "]";
        return r;
    }

    public synchronized Enumeration elements() {
        return new Enumeration(this){
            private /* synthetic */ Vector this$0;
            int i;
            {
                this.this$0 = this$0;
                this.finit$();
            }

            private /* synthetic */ void finit$() {
                this.i = 0;
            }

            public boolean hasMoreElements() {
                return this.i < this.this$0.elementCount;
            }

            public Object nextElement() {
                if (this.i >= this.this$0.elementCount) {
                    throw new NoSuchElementException();
                }
                return this.this$0.elementAt(this.i++);
            }
        };
    }

    public List subList(int fromIndex, int toIndex) {
        List sub = super.subList(fromIndex, toIndex);
        return Collections.synchronizedList(sub);
    }

    protected synchronized void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        if (fromIndex != toIndex) {
            System.arraycopy(this.elementData, toIndex, this.elementData, fromIndex, this.elementCount - toIndex);
            int save = this.elementCount;
            this.elementCount -= toIndex - fromIndex;
            for (int i = this.elementCount; i < save; ++i) {
                this.elementData[i] = null;
            }
        }
    }
}

