/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

class SubList
extends AbstractList {
    private AbstractList backingList;
    private int offset;
    private int size;

    static /* synthetic */ AbstractList access$2(SubList inst$, AbstractList write_parm_value$) {
        inst$.backingList = write_parm_value$;
        return inst$.backingList;
    }

    static /* synthetic */ int access$1(SubList inst$, int write_parm_value$) {
        inst$.offset = write_parm_value$;
        return inst$.offset;
    }

    public SubList(AbstractList backing, int fromIndex, int toIndex) {
        this.backingList = backing;
        this.modCount = this.backingList.modCount;
        this.offset = fromIndex;
        this.size = toIndex - fromIndex;
    }

    private void checkMod() {
        if (this.modCount != this.backingList.modCount) {
            throw new ConcurrentModificationException();
        }
    }

    private void checkBoundsInclusive(int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size:" + this.size);
        }
    }

    private void checkBoundsExclusive(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size:" + this.size);
        }
    }

    public int size() {
        this.checkMod();
        return this.size;
    }

    public Object set(int index, Object o) {
        this.checkMod();
        this.checkBoundsExclusive(index);
        o = this.backingList.set(index + this.offset, o);
        return o;
    }

    public Object get(int index) {
        this.checkMod();
        this.checkBoundsExclusive(index);
        return this.backingList.get(index + this.offset);
    }

    public void add(int index, Object o) {
        this.checkMod();
        this.checkBoundsInclusive(index);
        this.backingList.add(index + this.offset, o);
        ++this.modCount;
        ++this.size;
    }

    public Object remove(int index) {
        this.checkMod();
        this.checkBoundsExclusive(index);
        Object o = this.backingList.remove(index + this.offset);
        ++this.modCount;
        this.size += -1;
        return o;
    }

    public void removeRange(int fromIndex, int toIndex) {
        this.checkMod();
        this.checkBoundsExclusive(fromIndex);
        this.checkBoundsInclusive(toIndex);
        this.backingList.removeRange(this.offset + fromIndex, this.offset + toIndex);
        this.modCount = this.backingList.modCount;
        this.size -= toIndex - fromIndex;
    }

    public boolean addAll(int index, Collection c) {
        this.checkMod();
        this.checkBoundsInclusive(index);
        int csize = c.size();
        boolean result = this.backingList.addAll(this.offset + index, c);
        this.modCount = this.backingList.modCount;
        this.size += csize;
        return result;
    }

    public Iterator iterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int index) {
        this.checkMod();
        this.checkBoundsInclusive(index);
        return new ListIterator(this, index){
            private /* synthetic */ SubList this$0;
            private /* synthetic */ int val$index;
            ListIterator i;
            int position;
            {
                this.this$0 = this$0;
                this.finit$(parm$index);
            }

            private /* synthetic */ void finit$(int parm$index) {
                this.val$index = parm$index;
                this.i = this.this$0.backingList.listIterator(this.val$index + this.this$0.offset);
                this.position = this.val$index;
            }

            public boolean hasNext() {
                this.this$0.checkMod();
                return this.position < this.this$0.size;
            }

            public boolean hasPrevious() {
                this.this$0.checkMod();
                return this.position > 0;
            }

            public Object next() {
                if (this.position < this.this$0.size) {
                    Object o = this.i.next();
                    ++this.position;
                    return o;
                }
                throw new NoSuchElementException();
            }

            public Object previous() {
                if (this.position > 0) {
                    Object o = this.i.previous();
                    this.position += -1;
                    return o;
                }
                throw new NoSuchElementException();
            }

            public int nextIndex() {
                return this.this$0.offset + this.i.nextIndex();
            }

            public int previousIndex() {
                return this.this$0.offset + this.i.previousIndex();
            }

            public void remove() {
                this.i.remove();
                ++this.this$0.modCount;
                this.this$0.size = this.this$0.size + 1;
                this.position = this.nextIndex();
            }

            public void set(Object o) {
                this.i.set(o);
            }

            public void add(Object o) {
                this.i.add(o);
                ++this.this$0.modCount;
                this.this$0.size = this.this$0.size + 1;
                ++this.position;
            }
        };
    }
}

