/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class Properties
extends Hashtable {
    protected Properties defaults;
    private static final long serialVersionUID = 4112578634029874840L;

    public Properties() {
        this.defaults = null;
    }

    public Properties(Properties defaults) {
        this.defaults = defaults;
    }

    public void load(InputStream inStream) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));
        while ((line = reader.readLine()) != null) {
            boolean isDelim;
            int pos;
            char c = '\u0000';
            for (pos = 0; pos < line.length() && Character.isWhitespace(c = line.charAt(pos)); ++pos) {
            }
            if (pos == line.length() || c == '#' || c == '!') continue;
            StringBuffer key = new StringBuffer();
            block14: while (pos < line.length() && !Character.isWhitespace(c = line.charAt(pos++)) && c != '=' && c != ':') {
                if (c == '\\') {
                    if (pos == line.length()) {
                        line = reader.readLine();
                        for (pos = 0; pos < line.length() && Character.isWhitespace(c = line.charAt(pos)); ++pos) {
                        }
                        continue;
                    }
                    c = line.charAt(pos++);
                    switch (c) {
                        case 'n': {
                            key.append('\n');
                            break;
                        }
                        case 't': {
                            key.append('\t');
                            break;
                        }
                        case 'r': {
                            key.append('\r');
                            break;
                        }
                        case 'u': {
                            if (pos + 4 > line.length()) continue block14;
                            char uni = (char)Integer.parseInt(line.substring(pos, pos + 4), 16);
                            key.append(uni);
                            break;
                        }
                        default: {
                            key.append(c);
                        }
                    }
                    continue;
                }
                key.append(c);
            }
            boolean bl = isDelim = c == ':' || c == '=';
            while (pos < line.length() && Character.isWhitespace(c = line.charAt(pos))) {
                ++pos;
            }
            if (!(isDelim || c != ':' && c != '=')) {
                ++pos;
                while (pos < line.length() && Character.isWhitespace(c = line.charAt(pos))) {
                    ++pos;
                }
            }
            StringBuffer element = new StringBuffer(line.length() - pos);
            block18: while (pos < line.length()) {
                if ((c = line.charAt(pos++)) == '\\') {
                    if (pos == line.length()) {
                        line = reader.readLine();
                        for (pos = 0; pos < line.length() && Character.isWhitespace(c = line.charAt(pos)); ++pos) {
                        }
                        element.ensureCapacity(line.length() - pos + element.length());
                        continue;
                    }
                    c = line.charAt(pos++);
                    switch (c) {
                        case 'n': {
                            element.append('\n');
                            break;
                        }
                        case 't': {
                            element.append('\t');
                            break;
                        }
                        case 'r': {
                            element.append('\r');
                            break;
                        }
                        case 'u': {
                            if (pos + 4 > line.length()) continue block18;
                            char uni = (char)Integer.parseInt(line.substring(pos, pos + 4), 16);
                            element.append(uni);
                            break;
                        }
                        default: {
                            element.append(c);
                        }
                    }
                    continue;
                }
                element.append(c);
            }
            this.put(key.toString(), element.toString());
        }
    }

    public void save(OutputStream out, String header) {
        try {
            this.store(out, header);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void store(OutputStream out, String header) throws IOException {
        PrintWriter writer = new PrintWriter(out);
        if (header != null) {
            writer.println("#" + header);
        }
        writer.println("#" + new Date().toString());
        this.list(writer);
        writer.flush();
    }

    public Object setProperty(String key, String value) {
        return this.put(key, value);
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public String getProperty(String key, String defaultValue) {
        Properties prop = this;
        do {
            String value;
            if ((value = (String)prop.get(key)) == null) continue;
            return value;
        } while ((prop = prop.defaults) != null);
        return defaultValue;
    }

    private final void addHashEntries(Hashtable base) {
        if (this.defaults != null) {
            this.defaults.addHashEntries(base);
        }
        Enumeration keys = this.keys();
        while (keys.hasMoreElements()) {
            base.put(keys.nextElement(), base);
        }
    }

    public Enumeration propertyNames() {
        Hashtable t = new Hashtable();
        this.addHashEntries(t);
        return t.keys();
    }

    private String formatForOutput(String key, String value) {
        String hex;
        char c;
        int i;
        StringBuffer result = new StringBuffer(key.length() + value.length() + 16);
        boolean head = true;
        for (i = 0; i < key.length(); ++i) {
            c = key.charAt(i);
            switch (c) {
                case '\n': {
                    result.append("\\n");
                    break;
                }
                case '\r': {
                    result.append("\\r");
                    break;
                }
                case '\t': {
                    result.append("\\t");
                    break;
                }
                case '\\': {
                    result.append("\\\\");
                    break;
                }
                case '!': {
                    result.append("\\!");
                    break;
                }
                case '#': {
                    result.append("\\#");
                    break;
                }
                case '=': {
                    result.append("\\=");
                    break;
                }
                case ':': {
                    result.append("\\:");
                    break;
                }
                case ' ': {
                    result.append("\\ ");
                    break;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        hex = Integer.toHexString(c);
                        result.append("\\u0000".substring(0, 6 - hex.length()));
                        result.append(hex);
                        break;
                    }
                    result.append(c);
                }
            }
            if (c == ' ') continue;
            head = false;
        }
        result.append('=');
        head = true;
        for (i = 0; i < value.length(); ++i) {
            c = value.charAt(i);
            switch (c) {
                case '\n': {
                    result.append("\\n");
                    break;
                }
                case '\r': {
                    result.append("\\r");
                    break;
                }
                case '\t': {
                    result.append("\\t");
                    break;
                }
                case '\\': {
                    result.append("\\\\");
                    break;
                }
                case '!': {
                    result.append("\\!");
                    break;
                }
                case '#': {
                    result.append("\\#");
                    break;
                }
                case ' ': {
                    result.append(head ? "\\ " : " ");
                    break;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        hex = Integer.toHexString(c);
                        result.append("\\u0000".substring(0, 6 - hex.length()));
                        result.append(hex);
                        break;
                    }
                    result.append(c);
                }
            }
            if (c == ' ') continue;
            head = false;
        }
        return result.toString();
    }

    public void list(PrintStream out) {
        Enumeration keys = this.keys();
        Enumeration elts = this.elements();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String elt = (String)elts.nextElement();
            String output = this.formatForOutput(key, elt);
            out.println(output);
        }
    }

    public void list(PrintWriter out) {
        Enumeration keys = this.keys();
        Enumeration elts = this.elements();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String elt = (String)elts.nextElement();
            String output = this.formatForOutput(key, elt);
            out.println(output);
        }
    }
}

