/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class HashSet
extends AbstractSet
implements Set,
Cloneable,
Serializable {
    transient HashMap map;
    static final long serialVersionUID = -5024744406713321676L;

    public HashSet() {
        this.map = new HashMap();
    }

    public HashSet(int initialCapacity) {
        this.map = new HashMap(initialCapacity);
    }

    public HashSet(int initialCapacity, float loadFactor) {
        this.map = new HashMap(initialCapacity, loadFactor);
    }

    public HashSet(Collection c) {
        this.map = new HashMap();
        this.addAll(c);
    }

    public boolean add(Object o) {
        return this.map.put(o, Boolean.TRUE) == null;
    }

    public void clear() {
        this.map.clear();
    }

    public Object clone() {
        HashSet copy = null;
        try {
            copy = (HashSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        copy.map = (HashMap)this.map.clone();
        return copy;
    }

    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Iterator iterator() {
        return this.map.keySet().iterator();
    }

    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    public int size() {
        return this.map.size();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Iterator it = this.iterator();
        s.writeInt(this.map.buckets.length);
        s.writeFloat(this.map.loadFactor);
        s.writeInt(this.map.size);
        while (it.hasNext()) {
            s.writeObject(it.next());
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        int capacity = s.readInt();
        float loadFactor = s.readFloat();
        int size = s.readInt();
        this.map = new HashMap(capacity, loadFactor);
        for (int i = 0; i < size; ++i) {
            Object element = s.readObject();
            this.map.put(element, Boolean.TRUE);
        }
    }
}

