/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.BasicMapEntry;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class HashMap
extends AbstractMap
implements Map,
Cloneable,
Serializable {
    private static final int DEFAULT_CAPACITY = 11;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final long serialVersionUID = 362498820763181265L;
    int threshold;
    float loadFactor;
    transient Entry[] buckets;
    transient int modCount;
    transient int size;

    private /* synthetic */ void finit$() {
        this.loadFactor = 0.75f;
    }

    public HashMap() {
        this(11, 0.75f);
    }

    public HashMap(Map m) {
        this.finit$();
        int size = Math.max(m.size() * 2, 11);
        this.buckets = new Entry[size];
        this.threshold = (int)((float)size * this.loadFactor);
        this.putAll(m);
    }

    public HashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public HashMap(int initialCapacity, float loadFactor) {
        this.finit$();
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load Factor: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.buckets = new Entry[initialCapacity];
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean containsValue(Object value) {
        for (int i = 0; i < this.buckets.length; ++i) {
            Entry e = this.buckets[i];
            while (e != null) {
                if (value == null ? e.value == null : value.equals(e.value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public boolean containsKey(Object key) {
        int idx = this.hash(key);
        Entry e = this.buckets[idx];
        while (e != null) {
            if (key == null ? e.key == null : key.equals(e.key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public Object get(Object key) {
        int idx = this.hash(key);
        Entry e = this.buckets[idx];
        while (e != null) {
            if (key == null ? e.key == null : key.equals(e.key)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public Object put(Object key, Object value) {
        ++this.modCount;
        int idx = this.hash(key);
        Entry e = this.buckets[idx];
        while (e != null) {
            if (key == null ? e.key == null : key.equals(e.key)) {
                Object r = e.value;
                e.value = value;
                return r;
            }
            e = e.next;
        }
        if (++this.size > this.threshold) {
            this.rehash();
            idx = this.hash(key);
        }
        e = new Entry(key, value);
        e.next = this.buckets[idx];
        this.buckets[idx] = e;
        return null;
    }

    public Object remove(Object key) {
        ++this.modCount;
        int idx = this.hash(key);
        Entry e = this.buckets[idx];
        Entry last = null;
        while (e != null) {
            if (key == null ? e.key == null : key.equals(e.key)) {
                if (last == null) {
                    this.buckets[idx] = e.next;
                } else {
                    last.next = e.next;
                }
                this.size += -1;
                return e.value;
            }
            last = e;
            e = e.next;
        }
        return null;
    }

    public void putAll(Map m) {
        int msize = m.size();
        Iterator itr = m.entrySet().iterator();
        for (int i = 0; i < msize; ++i) {
            Map.Entry e = (Map.Entry)itr.next();
            if (e instanceof BasicMapEntry) {
                BasicMapEntry entry = (BasicMapEntry)e;
                this.put(entry.key, entry.value);
                continue;
            }
            this.put(e.getKey(), e.getValue());
        }
    }

    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = null;
        }
        this.size = 0;
    }

    public Object clone() {
        HashMap copy = null;
        try {
            copy = (HashMap)super.clone();
        }
        catch (CloneNotSupportedException x) {
            // empty catch block
        }
        copy.buckets = new Entry[this.buckets.length];
        for (int i = 0; i < this.buckets.length; ++i) {
            Entry e = this.buckets[i];
            Entry last = null;
            while (e != null) {
                if (last == null) {
                    copy.buckets[i] = new Entry(e.key, e.value);
                    last = copy.buckets[i];
                } else {
                    last = last.next = new Entry(e.key, e.value);
                }
                e = e.next;
            }
        }
        return copy;
    }

    public Set keySet() {
        return new AbstractSet(this){
            private /* synthetic */ HashMap this$0;
            {
                this.this$0 = this$0;
            }

            public int size() {
                return this.this$0.size;
            }

            public Iterator iterator() {
                return new HashIterator(this.this$0, 0);
            }

            public void clear() {
                this.this$0.clear();
            }

            public boolean contains(Object o) {
                return this.this$0.containsKey(o);
            }

            public boolean remove(Object o) {
                int oldsize = this.this$0.size;
                this.this$0.remove(o);
                return oldsize != this.this$0.size;
            }
        };
    }

    public Collection values() {
        return new AbstractCollection(this){
            private /* synthetic */ HashMap this$0;
            {
                this.this$0 = this$0;
            }

            public int size() {
                return this.this$0.size;
            }

            public Iterator iterator() {
                return new HashIterator(this.this$0, 1);
            }

            public void clear() {
                this.this$0.clear();
            }
        };
    }

    public Set entrySet() {
        return new AbstractSet(this){
            private /* synthetic */ HashMap this$0;
            {
                this.this$0 = this$0;
            }

            public int size() {
                return this.this$0.size;
            }

            public Iterator iterator() {
                return new HashIterator(this.this$0, 2);
            }

            public void clear() {
                this.this$0.clear();
            }

            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry me = (Map.Entry)o;
                Entry e = this.this$0.getEntry(me);
                return e != null;
            }

            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry me = (Map.Entry)o;
                Entry e = this.this$0.getEntry(me);
                if (e != null) {
                    this.this$0.remove(e.key);
                    return true;
                }
                return false;
            }
        };
    }

    private int hash(Object key) {
        if (key == null) {
            return 0;
        }
        return Math.abs(key.hashCode() % this.buckets.length);
    }

    private Entry getEntry(Map.Entry me) {
        int idx = this.hash(me.getKey());
        Entry e = this.buckets[idx];
        while (e != null) {
            if (e.equals(me)) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    private void rehash() {
        Entry[] oldBuckets = this.buckets;
        int newcapacity = this.buckets.length * 2 + 1;
        this.threshold = (int)((float)newcapacity * this.loadFactor);
        this.buckets = new Entry[newcapacity];
        for (int i = 0; i < oldBuckets.length; ++i) {
            Entry e = oldBuckets[i];
            while (e != null) {
                int idx = this.hash(e.key);
                Entry dest = this.buckets[idx];
                if (dest != null) {
                    while (dest.next != null) {
                        dest = dest.next;
                    }
                    dest.next = e;
                } else {
                    this.buckets[idx] = e;
                }
                Entry next = e.next;
                e.next = null;
                e = next;
            }
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.buckets.length);
        s.writeInt(this.size);
        Iterator it = this.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            s.writeObject(entry.getKey());
            s.writeObject(entry.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        int capacity = s.readInt();
        int len = s.readInt();
        this.size = 0;
        this.modCount = 0;
        this.buckets = new Entry[capacity];
        for (int i = 0; i < len; ++i) {
            Object key = s.readObject();
            Object value = s.readObject();
            this.put(key, value);
        }
    }

    class HashIterator
    implements Iterator {
        private /* synthetic */ HashMap this$0;
        static final int KEYS = 0;
        static final int VALUES = 1;
        static final int ENTRIES = 2;
        int type;
        int knownMod;
        int count;
        int idx;
        Entry last;
        Entry next;

        HashIterator(HashMap this$0, int type) {
            this.this$0 = this$0;
            this.type = type;
            this.knownMod = this$0.modCount;
            this.count = 0;
            this.idx = this$0.buckets.length;
        }

        public boolean hasNext() {
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.count < this.this$0.size;
        }

        public Object next() {
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.count == this.this$0.size) {
                throw new NoSuchElementException();
            }
            ++this.count;
            Entry e = null;
            if (this.next != null) {
                e = this.next;
            }
            while (e == null) {
                e = this.this$0.buckets[this.idx += -1];
            }
            this.next = e.next;
            this.last = e;
            if (this.type == 1) {
                return e.value;
            }
            if (this.type == 0) {
                return e.key;
            }
            return e;
        }

        public void remove() {
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.this$0.remove(this.last.key);
            ++this.knownMod;
            this.count += -1;
            this.last = null;
        }
    }

    static class Entry
    extends BasicMapEntry {
        Entry next;

        Entry(Object key, Object value) {
            super(key, value);
        }
    }
}

