/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;

public class BitSet
implements Cloneable,
Serializable {
    long[] bits;
    private static final long serialVersionUID = 7997698588986878753L;

    public BitSet() {
        this(64);
    }

    public BitSet(int nbits) {
        if (nbits < 0) {
            throw new NegativeArraySizeException();
        }
        int length = nbits / 64;
        if (nbits % 64 != 0) {
            ++length;
        }
        this.bits = new long[length];
    }

    public void and(BitSet bs) {
        int i;
        int max = Math.min(this.bits.length, bs.bits.length);
        for (i = 0; i < max; ++i) {
            this.bits[i] = this.bits[i] & bs.bits[i];
        }
        while (i < this.bits.length) {
            this.bits[i] = 0L;
            ++i;
        }
    }

    public void andNot(BitSet bs) {
        int max = Math.min(this.bits.length, bs.bits.length);
        for (int i = 0; i < max; ++i) {
            this.bits[i] = this.bits[i] & (bs.bits[i] ^ (long)-1);
        }
    }

    public void clear(int pos) {
        if (pos < 0) {
            throw new IndexOutOfBoundsException();
        }
        int bit = pos % 64;
        int offset = pos / 64;
        this.ensure(offset);
        this.bits[offset] = this.bits[offset] & (1L << (bit & 0x3F) ^ (long)-1);
    }

    public Object clone() {
        BitSet bs = new BitSet(this.bits.length * 64);
        System.arraycopy(this.bits, 0, bs.bits, 0, this.bits.length);
        return bs;
    }

    public boolean equals(Object obj) {
        int j;
        if (!(obj instanceof BitSet)) {
            return false;
        }
        BitSet bs = (BitSet)obj;
        int max = Math.min(this.bits.length, bs.bits.length);
        for (int i = 0; i < max; ++i) {
            if (this.bits[i] == bs.bits[i]) continue;
            return false;
        }
        for (j = i; j < this.bits.length; ++j) {
            if (this.bits[j] == 0L) continue;
            return false;
        }
        for (j = i; j < bs.bits.length; ++j) {
            if (bs.bits[j] == 0L) continue;
            return false;
        }
        return true;
    }

    public boolean get(int pos) {
        if (pos < 0) {
            throw new IndexOutOfBoundsException();
        }
        int bit = pos % 64;
        int offset = pos / 64;
        if (offset >= this.bits.length) {
            return false;
        }
        return (this.bits[offset] & 1L << (bit & 0x3F)) != 0L;
    }

    public int hashCode() {
        long h = 1234;
        for (int i = this.bits.length - 1; i >= 0; --i) {
            h ^= this.bits[i] * (long)(i + 1);
        }
        return (int)(h >> 32) ^ (int)h;
    }

    public int length() {
        int i;
        for (i = this.bits.length - 1; i >= 0 && this.bits[i] == 0L; --i) {
        }
        if (i < 0) {
            return 0;
        }
        int len = (i + 1) * 64;
        for (long b = this.bits[i]; b >= 0L; b <<= 1) {
            --len;
        }
        return len;
    }

    public void or(BitSet bs) {
        this.ensure(bs.bits.length - 1);
        for (int i = 0; i < bs.bits.length; ++i) {
            this.bits[i] = this.bits[i] | bs.bits[i];
        }
    }

    public void set(int pos) {
        if (pos < 0) {
            throw new IndexOutOfBoundsException();
        }
        int bit = pos % 64;
        int offset = pos / 64;
        this.ensure(offset);
        this.bits[offset] = this.bits[offset] | 1L << (bit & 0x3F);
    }

    public int size() {
        return this.bits.length * 64;
    }

    public String toString() {
        String r = "{";
        boolean first = true;
        for (int i = 0; i < this.bits.length; ++i) {
            long bit = 1L;
            long word = this.bits[i];
            if (word == 0L) continue;
            for (int j = 0; j < 64; ++j) {
                if ((word & bit) != 0L) {
                    if (!first) {
                        r = r + ", ";
                    }
                    r = r + Integer.toString(64 * i + j);
                    first = false;
                }
                bit <<= 1;
            }
        }
        r = r + "}";
        return r;
    }

    public void xor(BitSet bs) {
        this.ensure(bs.bits.length - 1);
        for (int i = 0; i < bs.bits.length; ++i) {
            this.bits[i] = this.bits[i] ^ bs.bits[i];
        }
    }

    private final void ensure(int lastElt) {
        if (lastElt + 1 > this.bits.length) {
            long[] nd = new long[lastElt + 1];
            System.arraycopy(this.bits, 0, nd, 0, this.bits.length);
            this.bits = nd;
        }
    }
}

