/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractList;
import java.util.Comparator;
import java.util.List;

public class Arrays {
    private static Comparator defaultComparator = new Comparator(null){
        private /* synthetic */ Arrays this$0;
        {
            this.this$0 = this$0;
        }

        public int compare(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }
    };

    private Arrays() {
    }

    public static int binarySearch(byte[] a, byte key) {
        int low = 0;
        int hi = a.length - 1;
        int mid = 0;
        while (low <= hi) {
            mid = low + hi >> 1;
            byte d = a[mid];
            if (d == key) {
                return mid;
            }
            if (d > key) {
                hi = mid - 1;
                continue;
            }
            low = ++mid;
        }
        return -mid - 1;
    }

    public static int binarySearch(char[] a, char key) {
        int low = 0;
        int hi = a.length - 1;
        int mid = 0;
        while (low <= hi) {
            mid = low + hi >> 1;
            char d = a[mid];
            if (d == key) {
                return mid;
            }
            if (d > key) {
                hi = mid - 1;
                continue;
            }
            low = ++mid;
        }
        return -mid - 1;
    }

    public static int binarySearch(double[] a, double key) {
        int low = 0;
        int hi = a.length - 1;
        int mid = 0;
        while (low <= hi) {
            mid = low + hi >> 1;
            double d = a[mid];
            if (d == key) {
                return mid;
            }
            if (d > key) {
                hi = mid - 1;
                continue;
            }
            low = ++mid;
        }
        return -mid - 1;
    }

    public static int binarySearch(float[] a, float key) {
        int low = 0;
        int hi = a.length - 1;
        int mid = 0;
        while (low <= hi) {
            mid = low + hi >> 1;
            float d = a[mid];
            if (d == key) {
                return mid;
            }
            if (d > key) {
                hi = mid - 1;
                continue;
            }
            low = ++mid;
        }
        return -mid - 1;
    }

    public static int binarySearch(int[] a, int key) {
        int low = 0;
        int hi = a.length - 1;
        int mid = 0;
        while (low <= hi) {
            mid = low + hi >> 1;
            int d = a[mid];
            if (d == key) {
                return mid;
            }
            if (d > key) {
                hi = mid - 1;
                continue;
            }
            low = ++mid;
        }
        return -mid - 1;
    }

    public static int binarySearch(long[] a, long key) {
        int low = 0;
        int hi = a.length - 1;
        int mid = 0;
        while (low <= hi) {
            mid = low + hi >> 1;
            long d = a[mid];
            if (d == key) {
                return mid;
            }
            if (d > key) {
                hi = mid - 1;
                continue;
            }
            low = ++mid;
        }
        return -mid - 1;
    }

    public static int binarySearch(short[] a, short key) {
        int low = 0;
        int hi = a.length - 1;
        int mid = 0;
        while (low <= hi) {
            mid = low + hi >> 1;
            short d = a[mid];
            if (d == key) {
                return mid;
            }
            if (d > key) {
                hi = mid - 1;
                continue;
            }
            low = ++mid;
        }
        return -mid - 1;
    }

    private static int objectSearch(Object[] a, Object key, Comparator c) {
        int low = 0;
        int hi = a.length - 1;
        int mid = 0;
        while (low <= hi) {
            mid = low + hi >> 1;
            int d = c.compare(key, a[mid]);
            if (d == 0) {
                return mid;
            }
            if (d < 0) {
                hi = mid - 1;
                continue;
            }
            low = ++mid;
        }
        return -mid - 1;
    }

    public static int binarySearch(Object[] a, Object key) {
        return Arrays.objectSearch(a, key, defaultComparator);
    }

    public static int binarySearch(Object[] a, Object key, Comparator c) {
        return Arrays.objectSearch(a, key, c);
    }

    public static boolean equals(byte[] a1, byte[] a2) {
        if (a1 == a2) {
            return true;
        }
        try {
            if (a1.length == a2.length) {
                for (int i = 0; i < a1.length; ++i) {
                    if (a1[i] == a2[i]) continue;
                    return false;
                }
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public static boolean equals(char[] a1, char[] a2) {
        if (a1 == a2) {
            return true;
        }
        try {
            if (a1.length == a2.length) {
                for (int i = 0; i < a1.length; ++i) {
                    if (a1[i] == a2[i]) continue;
                    return false;
                }
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public static boolean equals(double[] a1, double[] a2) {
        if (a1 == a2) {
            return true;
        }
        try {
            if (a1.length == a2.length) {
                for (int i = 0; i < a1.length; ++i) {
                    if (a1[i] == a2[i]) continue;
                    return false;
                }
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public static boolean equals(float[] a1, float[] a2) {
        if (a1 == a2) {
            return true;
        }
        try {
            if (a1.length == a2.length) {
                for (int i = 0; i < a1.length; ++i) {
                    if (a1[i] == a2[i]) continue;
                    return false;
                }
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public static boolean equals(long[] a1, long[] a2) {
        if (a1 == a2) {
            return true;
        }
        try {
            if (a1.length == a2.length) {
                for (int i = 0; i < a1.length; ++i) {
                    if (a1[i] == a2[i]) continue;
                    return false;
                }
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public static boolean equals(short[] a1, short[] a2) {
        if (a1 == a2) {
            return true;
        }
        try {
            if (a1.length == a2.length) {
                for (int i = 0; i < a1.length; ++i) {
                    if (a1[i] == a2[i]) continue;
                    return false;
                }
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public static boolean equals(boolean[] a1, boolean[] a2) {
        if (a1 == a2) {
            return true;
        }
        try {
            if (a1.length == a2.length) {
                for (int i = 0; i < a1.length; ++i) {
                    if (a1[i] == a2[i]) continue;
                    return false;
                }
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public static boolean equals(int[] a1, int[] a2) {
        if (a1 == a2) {
            return true;
        }
        try {
            if (a1.length == a2.length) {
                for (int i = 0; i < a1.length; ++i) {
                    if (a1[i] == a2[i]) continue;
                    return false;
                }
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public static boolean equals(Object[] a1, Object[] a2) {
        if (a1 == a2) {
            return true;
        }
        try {
            if (a1.length == a2.length) {
                for (int i = 0; i < a1.length; ++i) {
                    if (!(a1[i] == null ? a2[i] != null : !a1[i].equals(a2[i]))) continue;
                    return false;
                }
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public static void fill(boolean[] a, boolean val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(boolean[] a, int fromIndex, int toIndex, boolean val) {
        for (int i = fromIndex; i < toIndex; ++i) {
            a[i] = val;
        }
    }

    public static void fill(byte[] a, byte val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(byte[] a, int fromIndex, int toIndex, byte val) {
        for (int i = fromIndex; i < toIndex; ++i) {
            a[i] = val;
        }
    }

    public static void fill(char[] a, char val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(char[] a, int fromIndex, int toIndex, char val) {
        for (int i = fromIndex; i < toIndex; ++i) {
            a[i] = val;
        }
    }

    public static void fill(double[] a, double val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(double[] a, int fromIndex, int toIndex, double val) {
        for (int i = fromIndex; i < toIndex; ++i) {
            a[i] = val;
        }
    }

    public static void fill(float[] a, float val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(float[] a, int fromIndex, int toIndex, float val) {
        for (int i = fromIndex; i < toIndex; ++i) {
            a[i] = val;
        }
    }

    public static void fill(int[] a, int val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(int[] a, int fromIndex, int toIndex, int val) {
        for (int i = fromIndex; i < toIndex; ++i) {
            a[i] = val;
        }
    }

    public static void fill(long[] a, long val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(long[] a, int fromIndex, int toIndex, long val) {
        for (int i = fromIndex; i < toIndex; ++i) {
            a[i] = val;
        }
    }

    public static void fill(short[] a, short val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(short[] a, int fromIndex, int toIndex, short val) {
        for (int i = fromIndex; i < toIndex; ++i) {
            a[i] = val;
        }
    }

    public static void fill(Object[] a, Object val) {
        Arrays.fill(a, 0, a.length, val);
    }

    public static void fill(Object[] a, int fromIndex, int toIndex, Object val) {
        for (int i = fromIndex; i < toIndex; ++i) {
            a[i] = val;
        }
    }

    public static void sort(byte[] a) {
        Arrays.qsort(a, 0, a.length);
    }

    public static void sort(byte[] a, int fromIndex, int toIndex) {
        Arrays.qsort(a, fromIndex, toIndex);
    }

    private static int med3(int a, int b, int c, byte[] d) {
        if (d[a] < d[b]) {
            if (d[b] < d[c]) {
                return b;
            }
            if (d[a] < d[c]) {
                return c;
            }
            return a;
        }
        if (d[b] > d[c]) {
            return b;
        }
        if (d[a] > d[c]) {
            return c;
        }
        return a;
    }

    private static void swap(int i, int j, byte[] a) {
        byte c = a[i];
        a[i] = a[j];
        a[j] = c;
    }

    private static void qsort(byte[] a, int start, int n) {
        int pd;
        int pb;
        if (n <= 7) {
            for (int i = start + 1; i < start + n; ++i) {
                for (int j = i; j > 0 && a[j - 1] > a[j]; --j) {
                    Arrays.swap(j, j - 1, a);
                }
            }
            return;
        }
        int pm = n / 2;
        if (n > 7) {
            int pl = start;
            int pn = start + n - 1;
            if (n > 40) {
                int s = n / 8;
                pl = Arrays.med3(pl, pl + s, pl + 2 * s, a);
                pm = Arrays.med3(pm - s, pm, pm + s, a);
                pn = Arrays.med3(pn - 2 * s, pn - s, pn, a);
            }
            pm = Arrays.med3(pl, pm, pn, a);
        }
        int pv = start;
        Arrays.swap(pv, pm, a);
        int pa = pb = start;
        int pc = pd = start + n - 1;
        while (true) {
            int r;
            if (pb <= pc && (r = a[pb] - a[pv]) <= 0) {
                if (r == 0) {
                    Arrays.swap(pa, pb, a);
                    ++pa;
                }
                ++pb;
                continue;
            }
            while (pc >= pb && (r = a[pc] - a[pv]) >= 0) {
                if (r == 0) {
                    Arrays.swap(pc, pd, a);
                    --pd;
                }
                --pc;
            }
            if (pb > pc) break;
            Arrays.swap(pb, pc, a);
            ++pb;
            --pc;
        }
        int pn = start + n;
        int s = Math.min(pa - start, pb - pa);
        Arrays.vecswap(start, pb - s, s, a);
        s = Math.min(pd - pc, pn - pd - 1);
        Arrays.vecswap(pb, pn - s, s, a);
        s = pb - pa;
        if (s > 1) {
            Arrays.qsort(a, start, s);
        }
        if ((s = pd - pc) > 1) {
            Arrays.qsort(a, pn - s, s);
        }
    }

    private static void vecswap(int i, int j, int n, byte[] a) {
        while (n > 0) {
            Arrays.swap(i, j, a);
            ++i;
            ++j;
            --n;
        }
    }

    public static void sort(char[] a) {
        Arrays.qsort(a, 0, a.length);
    }

    public static void sort(char[] a, int fromIndex, int toIndex) {
        Arrays.qsort(a, fromIndex, toIndex);
    }

    private static int med3(int a, int b, int c, char[] d) {
        if (d[a] < d[b]) {
            if (d[b] < d[c]) {
                return b;
            }
            if (d[a] < d[c]) {
                return c;
            }
            return a;
        }
        if (d[b] > d[c]) {
            return b;
        }
        if (d[a] > d[c]) {
            return c;
        }
        return a;
    }

    private static void swap(int i, int j, char[] a) {
        char c = a[i];
        a[i] = a[j];
        a[j] = c;
    }

    private static void qsort(char[] a, int start, int n) {
        int pd;
        int pb;
        if (n <= 7) {
            for (int i = start + 1; i < start + n; ++i) {
                for (int j = i; j > 0 && a[j - 1] > a[j]; --j) {
                    Arrays.swap(j, j - 1, a);
                }
            }
            return;
        }
        int pm = n / 2;
        if (n > 7) {
            int pl = start;
            int pn = start + n - 1;
            if (n > 40) {
                int s = n / 8;
                pl = Arrays.med3(pl, pl + s, pl + 2 * s, a);
                pm = Arrays.med3(pm - s, pm, pm + s, a);
                pn = Arrays.med3(pn - 2 * s, pn - s, pn, a);
            }
            pm = Arrays.med3(pl, pm, pn, a);
        }
        int pv = start;
        Arrays.swap(pv, pm, a);
        int pa = pb = start;
        int pc = pd = start + n - 1;
        while (true) {
            int r;
            if (pb <= pc && (r = a[pb] - a[pv]) <= 0) {
                if (r == 0) {
                    Arrays.swap(pa, pb, a);
                    ++pa;
                }
                ++pb;
                continue;
            }
            while (pc >= pb && (r = a[pc] - a[pv]) >= 0) {
                if (r == 0) {
                    Arrays.swap(pc, pd, a);
                    --pd;
                }
                --pc;
            }
            if (pb > pc) break;
            Arrays.swap(pb, pc, a);
            ++pb;
            --pc;
        }
        int pn = start + n;
        int s = Math.min(pa - start, pb - pa);
        Arrays.vecswap(start, pb - s, s, a);
        s = Math.min(pd - pc, pn - pd - 1);
        Arrays.vecswap(pb, pn - s, s, a);
        s = pb - pa;
        if (s > 1) {
            Arrays.qsort(a, start, s);
        }
        if ((s = pd - pc) > 1) {
            Arrays.qsort(a, pn - s, s);
        }
    }

    private static void vecswap(int i, int j, int n, char[] a) {
        while (n > 0) {
            Arrays.swap(i, j, a);
            ++i;
            ++j;
            --n;
        }
    }

    public static void sort(double[] a) {
        Arrays.qsort(a, 0, a.length);
    }

    public static void sort(double[] a, int fromIndex, int toIndex) {
        Arrays.qsort(a, fromIndex, toIndex);
    }

    private static int med3(int a, int b, int c, double[] d) {
        if (d[a] < d[b]) {
            if (d[b] < d[c]) {
                return b;
            }
            if (d[a] < d[c]) {
                return c;
            }
            return a;
        }
        if (d[b] > d[c]) {
            return b;
        }
        if (d[a] > d[c]) {
            return c;
        }
        return a;
    }

    private static void swap(int i, int j, double[] a) {
        double c = a[i];
        a[i] = a[j];
        a[j] = c;
    }

    private static void qsort(double[] a, int start, int n) {
        int pd;
        int pb;
        if (n <= 7) {
            for (int i = start + 1; i < start + n; ++i) {
                for (int j = i; j > 0 && a[j - 1] > a[j]; --j) {
                    Arrays.swap(j, j - 1, a);
                }
            }
            return;
        }
        int pm = n / 2;
        if (n > 7) {
            int pl = start;
            int pn = start + n - 1;
            if (n > 40) {
                int s = n / 8;
                pl = Arrays.med3(pl, pl + s, pl + 2 * s, a);
                pm = Arrays.med3(pm - s, pm, pm + s, a);
                pn = Arrays.med3(pn - 2 * s, pn - s, pn, a);
            }
            pm = Arrays.med3(pl, pm, pn, a);
        }
        int pv = start;
        Arrays.swap(pv, pm, a);
        int pa = pb = start;
        int pc = pd = start + n - 1;
        while (true) {
            double r;
            if (pb <= pc && (r = a[pb] - a[pv]) <= 0.0) {
                if (r == 0.0) {
                    Arrays.swap(pa, pb, a);
                    ++pa;
                }
                ++pb;
                continue;
            }
            while (pc >= pb && (r = a[pc] - a[pv]) >= 0.0) {
                if (r == 0.0) {
                    Arrays.swap(pc, pd, a);
                    --pd;
                }
                --pc;
            }
            if (pb > pc) break;
            Arrays.swap(pb, pc, a);
            ++pb;
            --pc;
        }
        int pn = start + n;
        int s = Math.min(pa - start, pb - pa);
        Arrays.vecswap(start, pb - s, s, a);
        s = Math.min(pd - pc, pn - pd - 1);
        Arrays.vecswap(pb, pn - s, s, a);
        s = pb - pa;
        if (s > 1) {
            Arrays.qsort(a, start, s);
        }
        if ((s = pd - pc) > 1) {
            Arrays.qsort(a, pn - s, s);
        }
    }

    private static void vecswap(int i, int j, int n, double[] a) {
        while (n > 0) {
            Arrays.swap(i, j, a);
            ++i;
            ++j;
            --n;
        }
    }

    public static void sort(float[] a) {
        Arrays.qsort(a, 0, a.length);
    }

    public static void sort(float[] a, int fromIndex, int toIndex) {
        Arrays.qsort(a, fromIndex, toIndex);
    }

    private static int med3(int a, int b, int c, float[] d) {
        if (d[a] < d[b]) {
            if (d[b] < d[c]) {
                return b;
            }
            if (d[a] < d[c]) {
                return c;
            }
            return a;
        }
        if (d[b] > d[c]) {
            return b;
        }
        if (d[a] > d[c]) {
            return c;
        }
        return a;
    }

    private static void swap(int i, int j, float[] a) {
        float c = a[i];
        a[i] = a[j];
        a[j] = c;
    }

    private static void qsort(float[] a, int start, int n) {
        int pd;
        int pb;
        if (n <= 7) {
            for (int i = start + 1; i < start + n; ++i) {
                for (int j = i; j > 0 && a[j - 1] > a[j]; --j) {
                    Arrays.swap(j, j - 1, a);
                }
            }
            return;
        }
        int pm = n / 2;
        if (n > 7) {
            int pl = start;
            int pn = start + n - 1;
            if (n > 40) {
                int s = n / 8;
                pl = Arrays.med3(pl, pl + s, pl + 2 * s, a);
                pm = Arrays.med3(pm - s, pm, pm + s, a);
                pn = Arrays.med3(pn - 2 * s, pn - s, pn, a);
            }
            pm = Arrays.med3(pl, pm, pn, a);
        }
        int pv = start;
        Arrays.swap(pv, pm, a);
        int pa = pb = start;
        int pc = pd = start + n - 1;
        while (true) {
            float r;
            if (pb <= pc && (r = a[pb] - a[pv]) <= 0.0f) {
                if (r == 0.0f) {
                    Arrays.swap(pa, pb, a);
                    ++pa;
                }
                ++pb;
                continue;
            }
            while (pc >= pb && (r = a[pc] - a[pv]) >= 0.0f) {
                if (r == 0.0f) {
                    Arrays.swap(pc, pd, a);
                    --pd;
                }
                --pc;
            }
            if (pb > pc) break;
            Arrays.swap(pb, pc, a);
            ++pb;
            --pc;
        }
        int pn = start + n;
        int s = Math.min(pa - start, pb - pa);
        Arrays.vecswap(start, pb - s, s, a);
        s = Math.min(pd - pc, pn - pd - 1);
        Arrays.vecswap(pb, pn - s, s, a);
        s = pb - pa;
        if (s > 1) {
            Arrays.qsort(a, start, s);
        }
        if ((s = pd - pc) > 1) {
            Arrays.qsort(a, pn - s, s);
        }
    }

    private static void vecswap(int i, int j, int n, float[] a) {
        while (n > 0) {
            Arrays.swap(i, j, a);
            ++i;
            ++j;
            --n;
        }
    }

    public static void sort(int[] a) {
        Arrays.qsort(a, 0, a.length);
    }

    public static void sort(int[] a, int fromIndex, int toIndex) {
        Arrays.qsort(a, fromIndex, toIndex);
    }

    private static int med3(int a, int b, int c, int[] d) {
        if (d[a] < d[b]) {
            if (d[b] < d[c]) {
                return b;
            }
            if (d[a] < d[c]) {
                return c;
            }
            return a;
        }
        if (d[b] > d[c]) {
            return b;
        }
        if (d[a] > d[c]) {
            return c;
        }
        return a;
    }

    private static void swap(int i, int j, int[] a) {
        int c = a[i];
        a[i] = a[j];
        a[j] = c;
    }

    private static void qsort(int[] a, int start, int n) {
        int pd;
        int pb;
        if (n <= 7) {
            for (int i = start + 1; i < start + n; ++i) {
                for (int j = i; j > 0 && a[j - 1] > a[j]; --j) {
                    Arrays.swap(j, j - 1, a);
                }
            }
            return;
        }
        int pm = n / 2;
        if (n > 7) {
            int pl = start;
            int pn = start + n - 1;
            if (n > 40) {
                int s = n / 8;
                pl = Arrays.med3(pl, pl + s, pl + 2 * s, a);
                pm = Arrays.med3(pm - s, pm, pm + s, a);
                pn = Arrays.med3(pn - 2 * s, pn - s, pn, a);
            }
            pm = Arrays.med3(pl, pm, pn, a);
        }
        int pv = start;
        Arrays.swap(pv, pm, a);
        int pa = pb = start;
        int pc = pd = start + n - 1;
        while (true) {
            int r;
            if (pb <= pc && (r = a[pb] - a[pv]) <= 0) {
                if (r == 0) {
                    Arrays.swap(pa, pb, a);
                    ++pa;
                }
                ++pb;
                continue;
            }
            while (pc >= pb && (r = a[pc] - a[pv]) >= 0) {
                if (r == 0) {
                    Arrays.swap(pc, pd, a);
                    --pd;
                }
                --pc;
            }
            if (pb > pc) break;
            Arrays.swap(pb, pc, a);
            ++pb;
            --pc;
        }
        int pn = start + n;
        int s = Math.min(pa - start, pb - pa);
        Arrays.vecswap(start, pb - s, s, a);
        s = Math.min(pd - pc, pn - pd - 1);
        Arrays.vecswap(pb, pn - s, s, a);
        s = pb - pa;
        if (s > 1) {
            Arrays.qsort(a, start, s);
        }
        if ((s = pd - pc) > 1) {
            Arrays.qsort(a, pn - s, s);
        }
    }

    private static void vecswap(int i, int j, int n, int[] a) {
        while (n > 0) {
            Arrays.swap(i, j, a);
            ++i;
            ++j;
            --n;
        }
    }

    public static void sort(long[] a) {
        Arrays.qsort(a, 0, a.length);
    }

    public static void sort(long[] a, int fromIndex, int toIndex) {
        Arrays.qsort(a, fromIndex, toIndex);
    }

    private static int med3(int a, int b, int c, long[] d) {
        if (d[a] < d[b]) {
            if (d[b] < d[c]) {
                return b;
            }
            if (d[a] < d[c]) {
                return c;
            }
            return a;
        }
        if (d[b] > d[c]) {
            return b;
        }
        if (d[a] > d[c]) {
            return c;
        }
        return a;
    }

    private static void swap(int i, int j, long[] a) {
        long c = a[i];
        a[i] = a[j];
        a[j] = c;
    }

    private static void qsort(long[] a, int start, int n) {
        int pd;
        int pb;
        if (n <= 7) {
            for (int i = start + 1; i < start + n; ++i) {
                for (int j = i; j > 0 && a[j - 1] > a[j]; --j) {
                    Arrays.swap(j, j - 1, a);
                }
            }
            return;
        }
        int pm = n / 2;
        if (n > 7) {
            int pl = start;
            int pn = start + n - 1;
            if (n > 40) {
                int s = n / 8;
                pl = Arrays.med3(pl, pl + s, pl + 2 * s, a);
                pm = Arrays.med3(pm - s, pm, pm + s, a);
                pn = Arrays.med3(pn - 2 * s, pn - s, pn, a);
            }
            pm = Arrays.med3(pl, pm, pn, a);
        }
        int pv = start;
        Arrays.swap(pv, pm, a);
        int pa = pb = start;
        int pc = pd = start + n - 1;
        while (true) {
            long r;
            if (pb <= pc && (r = a[pb] - a[pv]) <= 0L) {
                if (r == 0L) {
                    Arrays.swap(pa, pb, a);
                    ++pa;
                }
                ++pb;
                continue;
            }
            while (pc >= pb && (r = a[pc] - a[pv]) >= 0L) {
                if (r == 0L) {
                    Arrays.swap(pc, pd, a);
                    --pd;
                }
                --pc;
            }
            if (pb > pc) break;
            Arrays.swap(pb, pc, a);
            ++pb;
            --pc;
        }
        int pn = start + n;
        int s = Math.min(pa - start, pb - pa);
        Arrays.vecswap(start, pb - s, s, a);
        s = Math.min(pd - pc, pn - pd - 1);
        Arrays.vecswap(pb, pn - s, s, a);
        s = pb - pa;
        if (s > 1) {
            Arrays.qsort(a, start, s);
        }
        if ((s = pd - pc) > 1) {
            Arrays.qsort(a, pn - s, s);
        }
    }

    private static void vecswap(int i, int j, int n, long[] a) {
        while (n > 0) {
            Arrays.swap(i, j, a);
            ++i;
            ++j;
            --n;
        }
    }

    public static void sort(short[] a) {
        Arrays.qsort(a, 0, a.length);
    }

    public static void sort(short[] a, int fromIndex, int toIndex) {
        Arrays.qsort(a, fromIndex, toIndex);
    }

    private static int med3(int a, int b, int c, short[] d) {
        if (d[a] < d[b]) {
            if (d[b] < d[c]) {
                return b;
            }
            if (d[a] < d[c]) {
                return c;
            }
            return a;
        }
        if (d[b] > d[c]) {
            return b;
        }
        if (d[a] > d[c]) {
            return c;
        }
        return a;
    }

    private static void swap(int i, int j, short[] a) {
        short c = a[i];
        a[i] = a[j];
        a[j] = c;
    }

    private static void qsort(short[] a, int start, int n) {
        int pd;
        int pb;
        if (n <= 7) {
            for (int i = start + 1; i < start + n; ++i) {
                for (int j = i; j > 0 && a[j - 1] > a[j]; --j) {
                    Arrays.swap(j, j - 1, a);
                }
            }
            return;
        }
        int pm = n / 2;
        if (n > 7) {
            int pl = start;
            int pn = start + n - 1;
            if (n > 40) {
                int s = n / 8;
                pl = Arrays.med3(pl, pl + s, pl + 2 * s, a);
                pm = Arrays.med3(pm - s, pm, pm + s, a);
                pn = Arrays.med3(pn - 2 * s, pn - s, pn, a);
            }
            pm = Arrays.med3(pl, pm, pn, a);
        }
        int pv = start;
        Arrays.swap(pv, pm, a);
        int pa = pb = start;
        int pc = pd = start + n - 1;
        while (true) {
            int r;
            if (pb <= pc && (r = a[pb] - a[pv]) <= 0) {
                if (r == 0) {
                    Arrays.swap(pa, pb, a);
                    ++pa;
                }
                ++pb;
                continue;
            }
            while (pc >= pb && (r = a[pc] - a[pv]) >= 0) {
                if (r == 0) {
                    Arrays.swap(pc, pd, a);
                    --pd;
                }
                --pc;
            }
            if (pb > pc) break;
            Arrays.swap(pb, pc, a);
            ++pb;
            --pc;
        }
        int pn = start + n;
        int s = Math.min(pa - start, pb - pa);
        Arrays.vecswap(start, pb - s, s, a);
        s = Math.min(pd - pc, pn - pd - 1);
        Arrays.vecswap(pb, pn - s, s, a);
        s = pb - pa;
        if (s > 1) {
            Arrays.qsort(a, start, s);
        }
        if ((s = pd - pc) > 1) {
            Arrays.qsort(a, pn - s, s);
        }
    }

    private static void vecswap(int i, int j, int n, short[] a) {
        while (n > 0) {
            Arrays.swap(i, j, a);
            ++i;
            ++j;
            --n;
        }
    }

    private static void mergeSort(Object[] a, int from, int to, Comparator c) {
        for (int chunk = from; chunk < to; chunk += 6) {
            int end = Math.min(chunk + 6, to);
            for (int i = chunk + 1; i < end; ++i) {
                if (c.compare(a[i - 1], a[i]) <= 0) continue;
                int j = i;
                Object elem = a[j];
                do {
                    a[j] = a[j - 1];
                } while (--j > chunk && c.compare(a[j - 1], elem) > 0);
                a[j] = elem;
            }
        }
        int len = to - from;
        if (len <= 6) {
            return;
        }
        Object[] src = a;
        Object[] dest = new Object[len];
        Object[] t = null;
        int srcDestDiff = -from;
        for (int size = 6; size < len; size <<= 1) {
            for (int start = from; start < to; start += size << 1) {
                int mid = start + size;
                int end = Math.min(to, mid + size);
                if (mid >= end || c.compare(src[mid - 1], src[mid]) <= 0) {
                    System.arraycopy(src, start, dest, start + srcDestDiff, end - start);
                    continue;
                }
                if (c.compare(src[start], src[end - 1]) > 0) {
                    System.arraycopy(src, start, dest, end - size + srcDestDiff, size);
                    System.arraycopy(src, mid, dest, start + srcDestDiff, end - mid);
                    continue;
                }
                int p1 = start;
                int p2 = mid;
                int i = start + srcDestDiff;
                while (p1 < mid && p2 < end) {
                    dest[i++] = src[c.compare(src[p1], src[p2]) <= 0 ? p1++ : p2++];
                }
                if (p1 < mid) {
                    System.arraycopy(src, p1, dest, i, mid - p1);
                    continue;
                }
                System.arraycopy(src, p2, dest, i, end - p2);
            }
            t = src;
            src = dest;
            dest = t;
            from += srcDestDiff;
            to += srcDestDiff;
            srcDestDiff = -srcDestDiff;
        }
        if (src != a) {
            System.arraycopy(src, 0, a, srcDestDiff, to);
        }
    }

    public static void sort(Object[] a) {
        Arrays.mergeSort(a, 0, a.length, defaultComparator);
    }

    public static void sort(Object[] a, Comparator c) {
        Arrays.mergeSort(a, 0, a.length, c);
    }

    public static void sort(Object[] a, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex " + fromIndex + " > toIndex " + toIndex);
        }
        Arrays.mergeSort(a, fromIndex, toIndex, defaultComparator);
    }

    public static void sort(Object[] a, int fromIndex, int toIndex, Comparator c) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex " + fromIndex + " > toIndex " + toIndex);
        }
        Arrays.mergeSort(a, fromIndex, toIndex, c);
    }

    public static List asList(Object[] a) {
        if (a == null) {
            throw new NullPointerException();
        }
        return new ListImpl(a);
    }

    static class ListImpl
    extends AbstractList {
        private Object[] a;

        ListImpl(Object[] a) {
            this.a = a;
        }

        public Object get(int index) {
            return this.a[index];
        }

        public int size() {
            return this.a.length;
        }

        public Object set(int index, Object element) {
            Object old = this.a[index];
            this.a[index] = element;
            return old;
        }
    }
}

