/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.SubList;

public abstract class AbstractList
extends AbstractCollection
implements List {
    protected transient int modCount;

    private /* synthetic */ void finit$() {
        this.modCount = 0;
    }

    public abstract Object get(int var1);

    public void add(int index, Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean add(Object o) {
        this.add(this.size(), o);
        return true;
    }

    public boolean addAll(int index, Collection c) {
        Iterator itr = c.iterator();
        int size = c.size();
        for (int pos = 0; pos < size; ++pos) {
            this.add(index++, itr.next());
        }
        return size > 0;
    }

    public void clear() {
        this.removeRange(0, this.size());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        int size = this.size();
        if (size != ((List)o).size()) {
            return false;
        }
        Iterator itr1 = this.iterator();
        Iterator itr2 = ((List)o).iterator();
        for (int pos = 0; pos < size; ++pos) {
            Object e = itr1.next();
            if (!(e == null ? itr2.next() != null : !e.equals(itr2.next()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        Iterator itr = this.iterator();
        int size = this.size();
        for (int pos = 0; pos < size; ++pos) {
            Object obj = itr.next();
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    public int indexOf(Object o) {
        ListIterator itr = this.listIterator(0);
        int size = this.size();
        for (int pos = 0; pos < size; ++pos) {
            if (!(o == null ? itr.next() == null : o.equals(itr.next()))) continue;
            return pos;
        }
        return -1;
    }

    public Iterator iterator() {
        return new AbstractListItr(this, 0);
    }

    public int lastIndexOf(Object o) {
        int size = this.size();
        ListIterator itr = this.listIterator(size);
        for (int pos = size; pos > 0; --pos) {
            if (!(o == null ? itr.previous() == null : o.equals(itr.previous()))) continue;
            return pos - 1;
        }
        return -1;
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size:" + this.size());
        }
        return new AbstractListItr(this, index);
    }

    public Object remove(int index) {
        throw new UnsupportedOperationException();
    }

    protected void removeRange(int fromIndex, int toIndex) {
        ListIterator itr = this.listIterator(fromIndex);
        for (int index = fromIndex; index < toIndex; ++index) {
            itr.next();
            itr.remove();
        }
    }

    public Object set(int index, Object o) {
        throw new UnsupportedOperationException();
    }

    public List subList(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException(fromIndex + " > " + toIndex);
        }
        if (fromIndex < 0 || toIndex > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return new SubList(this, fromIndex, toIndex);
    }

    public AbstractList() {
        this.finit$();
    }

    class AbstractListItr
    implements ListIterator {
        private /* synthetic */ AbstractList this$0;
        private int knownMod;
        private int position;
        private int lastReturned;
        private int size;

        private /* synthetic */ void finit$() {
            this.knownMod = this.this$0.modCount;
            this.lastReturned = -1;
            this.size = this.this$0.size();
        }

        AbstractListItr(AbstractList this$0, int start_pos) {
            this.this$0 = this$0;
            this.finit$();
            this.position = start_pos;
        }

        private void checkMod() {
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean hasNext() {
            this.checkMod();
            return this.position < this.size;
        }

        public boolean hasPrevious() {
            this.checkMod();
            return this.position > 0;
        }

        public Object next() {
            this.checkMod();
            if (this.position < this.size) {
                this.lastReturned = this.position++;
                return this.this$0.get(this.lastReturned);
            }
            throw new NoSuchElementException();
        }

        public Object previous() {
            this.checkMod();
            if (this.position > 0) {
                this.lastReturned = this.position += -1;
                return this.this$0.get(this.lastReturned);
            }
            throw new NoSuchElementException();
        }

        public int nextIndex() {
            this.checkMod();
            return this.position;
        }

        public int previousIndex() {
            this.checkMod();
            return this.position - 1;
        }

        public void remove() {
            this.checkMod();
            if (this.lastReturned < 0) {
                throw new IllegalStateException();
            }
            this.this$0.remove(this.lastReturned);
            ++this.knownMod;
            this.position = this.lastReturned;
            this.lastReturned = -1;
        }

        public void set(Object o) {
            this.checkMod();
            if (this.lastReturned < 0) {
                throw new IllegalStateException();
            }
            this.this$0.set(this.lastReturned, o);
        }

        public void add(Object o) {
            this.checkMod();
            this.this$0.add(this.position++, o);
            this.lastReturned = -1;
            ++this.knownMod;
        }
    }
}

